/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.transactions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.transactions.SubmitMultiSignedResult;
import org.xrpl.xrpl4j.model.client.transactions.TransactionResult;
import org.xrpl.xrpl4j.model.transactions.Transaction;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SubmitMultiSignedResult", generator="Immutables")
@Immutable
public final class ImmutableSubmitMultiSignedResult<TxnType extends Transaction>
implements SubmitMultiSignedResult<TxnType> {
    @Nullable
    private final String status;
    private final String result;
    private final Integer resultCode;
    private final String resultMessage;
    private final String transactionBlob;
    private final TransactionResult<TxnType> transaction;

    private ImmutableSubmitMultiSignedResult(@Nullable String status, String result, Integer resultCode, String resultMessage, String transactionBlob, TransactionResult<TxnType> transaction) {
        this.status = status;
        this.result = result;
        this.resultCode = resultCode;
        this.resultMessage = resultMessage;
        this.transactionBlob = transactionBlob;
        this.transaction = transaction;
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="engine_result")
    public String result() {
        return this.result;
    }

    @Override
    @JsonProperty(value="engine_result_code")
    public Integer resultCode() {
        return this.resultCode;
    }

    @Override
    @JsonProperty(value="engine_result_message")
    public String resultMessage() {
        return this.resultMessage;
    }

    @Override
    @JsonProperty(value="tx_blob")
    public String transactionBlob() {
        return this.transactionBlob;
    }

    @Override
    @JsonProperty(value="tx_json")
    public TransactionResult<TxnType> transaction() {
        return this.transaction;
    }

    public final ImmutableSubmitMultiSignedResult<TxnType> withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableSubmitMultiSignedResult<TxnType>(newValue, this.result, this.resultCode, this.resultMessage, this.transactionBlob, this.transaction);
    }

    public final ImmutableSubmitMultiSignedResult<TxnType> withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableSubmitMultiSignedResult<TxnType>(value, this.result, this.resultCode, this.resultMessage, this.transactionBlob, this.transaction);
    }

    public final ImmutableSubmitMultiSignedResult<TxnType> withResult(String value) {
        String newValue = Objects.requireNonNull(value, "result");
        if (this.result.equals(newValue)) {
            return this;
        }
        return new ImmutableSubmitMultiSignedResult<TxnType>(this.status, newValue, this.resultCode, this.resultMessage, this.transactionBlob, this.transaction);
    }

    public final ImmutableSubmitMultiSignedResult<TxnType> withResultCode(Integer value) {
        Integer newValue = Objects.requireNonNull(value, "resultCode");
        if (this.resultCode.equals(newValue)) {
            return this;
        }
        return new ImmutableSubmitMultiSignedResult<TxnType>(this.status, this.result, newValue, this.resultMessage, this.transactionBlob, this.transaction);
    }

    public final ImmutableSubmitMultiSignedResult<TxnType> withResultMessage(String value) {
        String newValue = Objects.requireNonNull(value, "resultMessage");
        if (this.resultMessage.equals(newValue)) {
            return this;
        }
        return new ImmutableSubmitMultiSignedResult<TxnType>(this.status, this.result, this.resultCode, newValue, this.transactionBlob, this.transaction);
    }

    public final ImmutableSubmitMultiSignedResult<TxnType> withTransactionBlob(String value) {
        String newValue = Objects.requireNonNull(value, "transactionBlob");
        if (this.transactionBlob.equals(newValue)) {
            return this;
        }
        return new ImmutableSubmitMultiSignedResult<TxnType>(this.status, this.result, this.resultCode, this.resultMessage, newValue, this.transaction);
    }

    public final ImmutableSubmitMultiSignedResult<TxnType> withTransaction(TransactionResult<TxnType> value) {
        if (this.transaction == value) {
            return this;
        }
        TransactionResult<TxnType> newValue = Objects.requireNonNull(value, "transaction");
        return new ImmutableSubmitMultiSignedResult<TxnType>(this.status, this.result, this.resultCode, this.resultMessage, this.transactionBlob, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSubmitMultiSignedResult && this.equalTo((ImmutableSubmitMultiSignedResult)another);
    }

    private boolean equalTo(ImmutableSubmitMultiSignedResult<?> another) {
        return Objects.equals(this.status, another.status) && this.result.equals(another.result) && this.resultCode.equals(another.resultCode) && this.resultMessage.equals(another.resultMessage) && this.transactionBlob.equals(another.transactionBlob) && this.transaction.equals(another.transaction);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + this.result.hashCode();
        h += (h << 5) + this.resultCode.hashCode();
        h += (h << 5) + this.resultMessage.hashCode();
        h += (h << 5) + this.transactionBlob.hashCode();
        h += (h << 5) + this.transaction.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SubmitMultiSignedResult").omitNullValues().add("status", (Object)this.status).add("result", (Object)this.result).add("resultCode", (Object)this.resultCode).add("resultMessage", (Object)this.resultMessage).add("transactionBlob", (Object)this.transactionBlob).add("transaction", this.transaction).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static <TxnType extends Transaction> ImmutableSubmitMultiSignedResult<TxnType> fromJson(Json<TxnType> json) {
        Builder builder = ImmutableSubmitMultiSignedResult.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.result != null) {
            builder.result(json.result);
        }
        if (json.resultCode != null) {
            builder.resultCode(json.resultCode);
        }
        if (json.resultMessage != null) {
            builder.resultMessage(json.resultMessage);
        }
        if (json.transactionBlob != null) {
            builder.transactionBlob(json.transactionBlob);
        }
        if (json.transaction != null) {
            builder.transaction(json.transaction);
        }
        return builder.build();
    }

    public static <TxnType extends Transaction> ImmutableSubmitMultiSignedResult<TxnType> copyOf(SubmitMultiSignedResult<TxnType> instance) {
        if (instance instanceof ImmutableSubmitMultiSignedResult) {
            return (ImmutableSubmitMultiSignedResult)instance;
        }
        return ImmutableSubmitMultiSignedResult.builder().from(instance).build();
    }

    public static <TxnType extends Transaction> Builder<TxnType> builder() {
        return new Builder();
    }

    @Generated(from="SubmitMultiSignedResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<TxnType extends Transaction> {
        private static final long INIT_BIT_RESULT = 1L;
        private static final long INIT_BIT_RESULT_CODE = 2L;
        private static final long INIT_BIT_RESULT_MESSAGE = 4L;
        private static final long INIT_BIT_TRANSACTION_BLOB = 8L;
        private static final long INIT_BIT_TRANSACTION = 16L;
        private long initBits = 31L;
        @Nullable
        private String status;
        @Nullable
        private String result;
        @Nullable
        private Integer resultCode;
        @Nullable
        private String resultMessage;
        @Nullable
        private String transactionBlob;
        @Nullable
        private TransactionResult<TxnType> transaction;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<TxnType> from(SubmitMultiSignedResult<TxnType> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<TxnType> from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<String> statusOptional;
            XrplResult instance;
            if (object instanceof SubmitMultiSignedResult) {
                instance = (SubmitMultiSignedResult)object;
                this.result(instance.result());
                this.resultCode(instance.resultCode());
                this.transactionBlob(instance.transactionBlob());
                this.resultMessage(instance.resultMessage());
                this.transaction(instance.transaction());
            }
            if (object instanceof XrplResult && (statusOptional = (instance = (XrplResult)object).status()).isPresent()) {
                this.status(statusOptional);
            }
        }

        @CanIgnoreReturnValue
        public final Builder<TxnType> status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder<TxnType> status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @JsonProperty(value="engine_result")
        @CanIgnoreReturnValue
        public final Builder<TxnType> result(String result) {
            this.result = Objects.requireNonNull(result, "result");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="engine_result_code")
        @CanIgnoreReturnValue
        public final Builder<TxnType> resultCode(Integer resultCode) {
            this.resultCode = Objects.requireNonNull(resultCode, "resultCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="engine_result_message")
        @CanIgnoreReturnValue
        public final Builder<TxnType> resultMessage(String resultMessage) {
            this.resultMessage = Objects.requireNonNull(resultMessage, "resultMessage");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="tx_blob")
        @CanIgnoreReturnValue
        public final Builder<TxnType> transactionBlob(String transactionBlob) {
            this.transactionBlob = Objects.requireNonNull(transactionBlob, "transactionBlob");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="tx_json")
        @CanIgnoreReturnValue
        public final Builder<TxnType> transaction(TransactionResult<TxnType> transaction) {
            this.transaction = Objects.requireNonNull(transaction, "transaction");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableSubmitMultiSignedResult<TxnType> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSubmitMultiSignedResult(this.status, this.result, this.resultCode, this.resultMessage, this.transactionBlob, this.transaction);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("result");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("resultCode");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("resultMessage");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("transactionBlob");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("transaction");
            }
            return "Cannot build SubmitMultiSignedResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SubmitMultiSignedResult", generator="Immutables")
    static final class Json<TxnType extends Transaction>
    implements SubmitMultiSignedResult<TxnType> {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        String result;
        @Nullable
        Integer resultCode;
        @Nullable
        String resultMessage;
        @Nullable
        String transactionBlob;
        @Nullable
        TransactionResult<TxnType> transaction;

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="engine_result")
        public void setResult(String result) {
            this.result = result;
        }

        @JsonProperty(value="engine_result_code")
        public void setResultCode(Integer resultCode) {
            this.resultCode = resultCode;
        }

        @JsonProperty(value="engine_result_message")
        public void setResultMessage(String resultMessage) {
            this.resultMessage = resultMessage;
        }

        @JsonProperty(value="tx_blob")
        public void setTransactionBlob(String transactionBlob) {
            this.transactionBlob = transactionBlob;
        }

        @JsonProperty(value="tx_json")
        public void setTransaction(TransactionResult<TxnType> transaction) {
            this.transaction = transaction;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String result() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer resultCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String resultMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String transactionBlob() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TransactionResult<TxnType> transaction() {
            throw new UnsupportedOperationException();
        }
    }
}

