/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.server;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.server.ServerInfoLastClose;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ServerInfoLastClose", generator="Immutables")
@Immutable
public final class ImmutableServerInfoLastClose
implements ServerInfoLastClose {
    private final Double convergeTimeSeconds;
    private final UnsignedInteger proposers;

    private ImmutableServerInfoLastClose(Double convergeTimeSeconds, UnsignedInteger proposers) {
        this.convergeTimeSeconds = convergeTimeSeconds;
        this.proposers = proposers;
    }

    @Override
    @JsonProperty(value="converge_time_s")
    public Double convergeTimeSeconds() {
        return this.convergeTimeSeconds;
    }

    @Override
    @JsonProperty(value="proposers")
    public UnsignedInteger proposers() {
        return this.proposers;
    }

    public final ImmutableServerInfoLastClose withConvergeTimeSeconds(Double value) {
        Double newValue = Objects.requireNonNull(value, "convergeTimeSeconds");
        if (this.convergeTimeSeconds.equals(newValue)) {
            return this;
        }
        return new ImmutableServerInfoLastClose(newValue, this.proposers);
    }

    public final ImmutableServerInfoLastClose withProposers(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "proposers");
        if (this.proposers.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableServerInfoLastClose(this.convergeTimeSeconds, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServerInfoLastClose && this.equalTo((ImmutableServerInfoLastClose)another);
    }

    private boolean equalTo(ImmutableServerInfoLastClose another) {
        return this.convergeTimeSeconds.equals(another.convergeTimeSeconds) && this.proposers.equals((Object)another.proposers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.convergeTimeSeconds.hashCode();
        h += (h << 5) + this.proposers.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ServerInfoLastClose").omitNullValues().add("convergeTimeSeconds", (Object)this.convergeTimeSeconds).add("proposers", (Object)this.proposers).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableServerInfoLastClose fromJson(Json json) {
        Builder builder = ImmutableServerInfoLastClose.builder();
        if (json.convergeTimeSeconds != null) {
            builder.convergeTimeSeconds(json.convergeTimeSeconds);
        }
        if (json.proposers != null) {
            builder.proposers(json.proposers);
        }
        return builder.build();
    }

    public static ImmutableServerInfoLastClose copyOf(ServerInfoLastClose instance) {
        if (instance instanceof ImmutableServerInfoLastClose) {
            return (ImmutableServerInfoLastClose)instance;
        }
        return ImmutableServerInfoLastClose.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ServerInfoLastClose", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CONVERGE_TIME_SECONDS = 1L;
        private static final long INIT_BIT_PROPOSERS = 2L;
        private long initBits = 3L;
        @Nullable
        private Double convergeTimeSeconds;
        @Nullable
        private UnsignedInteger proposers;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ServerInfoLastClose instance) {
            Objects.requireNonNull(instance, "instance");
            this.convergeTimeSeconds(instance.convergeTimeSeconds());
            this.proposers(instance.proposers());
            return this;
        }

        @JsonProperty(value="converge_time_s")
        @CanIgnoreReturnValue
        public final Builder convergeTimeSeconds(Double convergeTimeSeconds) {
            this.convergeTimeSeconds = Objects.requireNonNull(convergeTimeSeconds, "convergeTimeSeconds");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="proposers")
        @CanIgnoreReturnValue
        public final Builder proposers(UnsignedInteger proposers) {
            this.proposers = Objects.requireNonNull(proposers, "proposers");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableServerInfoLastClose build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServerInfoLastClose(this.convergeTimeSeconds, this.proposers);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("convergeTimeSeconds");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("proposers");
            }
            return "Cannot build ServerInfoLastClose, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ServerInfoLastClose", generator="Immutables")
    static final class Json
    implements ServerInfoLastClose {
        @Nullable
        Double convergeTimeSeconds;
        @Nullable
        UnsignedInteger proposers;

        Json() {
        }

        @JsonProperty(value="converge_time_s")
        public void setConvergeTimeSeconds(Double convergeTimeSeconds) {
            this.convergeTimeSeconds = convergeTimeSeconds;
        }

        @JsonProperty(value="proposers")
        public void setProposers(UnsignedInteger proposers) {
            this.proposers = proposers;
        }

        @Override
        public Double convergeTimeSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger proposers() {
            throw new UnsupportedOperationException();
        }
    }
}

