/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.path;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.path.PathAlternative;
import org.xrpl.xrpl4j.model.client.path.RipplePathFindResult;
import org.xrpl.xrpl4j.model.transactions.Address;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RipplePathFindResult", generator="Immutables")
@Immutable
public final class ImmutableRipplePathFindResult
implements RipplePathFindResult {
    @Nullable
    private final String status;
    private final ImmutableList<PathAlternative> alternatives;
    private final Address destinationAccount;
    private final ImmutableList<String> destinationCurrencies;

    private ImmutableRipplePathFindResult(@Nullable String status, ImmutableList<PathAlternative> alternatives, Address destinationAccount, ImmutableList<String> destinationCurrencies) {
        this.status = status;
        this.alternatives = alternatives;
        this.destinationAccount = destinationAccount;
        this.destinationCurrencies = destinationCurrencies;
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @JsonProperty(value="alternatives")
    public ImmutableList<PathAlternative> alternatives() {
        return this.alternatives;
    }

    @Override
    @JsonProperty(value="destination_account")
    public Address destinationAccount() {
        return this.destinationAccount;
    }

    @JsonProperty(value="destination_currencies")
    public ImmutableList<String> destinationCurrencies() {
        return this.destinationCurrencies;
    }

    public final ImmutableRipplePathFindResult withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableRipplePathFindResult(newValue, this.alternatives, this.destinationAccount, this.destinationCurrencies);
    }

    public final ImmutableRipplePathFindResult withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableRipplePathFindResult(value, this.alternatives, this.destinationAccount, this.destinationCurrencies);
    }

    public final ImmutableRipplePathFindResult withAlternatives(PathAlternative ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRipplePathFindResult(this.status, (ImmutableList<PathAlternative>)newValue, this.destinationAccount, this.destinationCurrencies);
    }

    public final ImmutableRipplePathFindResult withAlternatives(Iterable<? extends PathAlternative> elements) {
        if (this.alternatives == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRipplePathFindResult(this.status, (ImmutableList<PathAlternative>)newValue, this.destinationAccount, this.destinationCurrencies);
    }

    public final ImmutableRipplePathFindResult withDestinationAccount(Address value) {
        if (this.destinationAccount == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "destinationAccount");
        return new ImmutableRipplePathFindResult(this.status, this.alternatives, newValue, this.destinationCurrencies);
    }

    public final ImmutableRipplePathFindResult withDestinationCurrencies(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRipplePathFindResult(this.status, this.alternatives, this.destinationAccount, (ImmutableList<String>)newValue);
    }

    public final ImmutableRipplePathFindResult withDestinationCurrencies(Iterable<String> elements) {
        if (this.destinationCurrencies == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRipplePathFindResult(this.status, this.alternatives, this.destinationAccount, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRipplePathFindResult && this.equalTo((ImmutableRipplePathFindResult)another);
    }

    private boolean equalTo(ImmutableRipplePathFindResult another) {
        return Objects.equals(this.status, another.status) && this.alternatives.equals(another.alternatives) && this.destinationAccount.equals(another.destinationAccount) && this.destinationCurrencies.equals(another.destinationCurrencies);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + this.alternatives.hashCode();
        h += (h << 5) + this.destinationAccount.hashCode();
        h += (h << 5) + this.destinationCurrencies.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RipplePathFindResult").omitNullValues().add("status", (Object)this.status).add("alternatives", this.alternatives).add("destinationAccount", (Object)this.destinationAccount).add("destinationCurrencies", this.destinationCurrencies).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRipplePathFindResult fromJson(Json json) {
        Builder builder = ImmutableRipplePathFindResult.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.alternatives != null) {
            builder.addAllAlternatives(json.alternatives);
        }
        if (json.destinationAccount != null) {
            builder.destinationAccount(json.destinationAccount);
        }
        if (json.destinationCurrencies != null) {
            builder.addAllDestinationCurrencies(json.destinationCurrencies);
        }
        return builder.build();
    }

    public static ImmutableRipplePathFindResult copyOf(RipplePathFindResult instance) {
        if (instance instanceof ImmutableRipplePathFindResult) {
            return (ImmutableRipplePathFindResult)instance;
        }
        return ImmutableRipplePathFindResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RipplePathFindResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DESTINATION_ACCOUNT = 1L;
        private long initBits = 1L;
        @Nullable
        private String status;
        private ImmutableList.Builder<PathAlternative> alternatives = ImmutableList.builder();
        @Nullable
        private Address destinationAccount;
        private ImmutableList.Builder<String> destinationCurrencies = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RipplePathFindResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<String> statusOptional;
            XrplResult instance;
            if (object instanceof RipplePathFindResult) {
                instance = (RipplePathFindResult)object;
                this.addAllAlternatives(instance.alternatives());
                this.addAllDestinationCurrencies(instance.destinationCurrencies());
                this.destinationAccount(instance.destinationAccount());
            }
            if (object instanceof XrplResult && (statusOptional = (instance = (XrplResult)object).status()).isPresent()) {
                this.status(statusOptional);
            }
        }

        @CanIgnoreReturnValue
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAlternatives(PathAlternative element) {
            this.alternatives.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAlternatives(PathAlternative ... elements) {
            this.alternatives.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="alternatives")
        @CanIgnoreReturnValue
        public final Builder alternatives(Iterable<? extends PathAlternative> elements) {
            this.alternatives = ImmutableList.builder();
            return this.addAllAlternatives(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAlternatives(Iterable<? extends PathAlternative> elements) {
            this.alternatives.addAll(elements);
            return this;
        }

        @JsonProperty(value="destination_account")
        @CanIgnoreReturnValue
        public final Builder destinationAccount(Address destinationAccount) {
            this.destinationAccount = Objects.requireNonNull(destinationAccount, "destinationAccount");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDestinationCurrencies(String element) {
            this.destinationCurrencies.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDestinationCurrencies(String ... elements) {
            this.destinationCurrencies.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="destination_currencies")
        @CanIgnoreReturnValue
        public final Builder destinationCurrencies(Iterable<String> elements) {
            this.destinationCurrencies = ImmutableList.builder();
            return this.addAllDestinationCurrencies(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDestinationCurrencies(Iterable<String> elements) {
            this.destinationCurrencies.addAll(elements);
            return this;
        }

        public ImmutableRipplePathFindResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRipplePathFindResult(this.status, this.alternatives.build(), this.destinationAccount, this.destinationCurrencies.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("destinationAccount");
            }
            return "Cannot build RipplePathFindResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RipplePathFindResult", generator="Immutables")
    static final class Json
    implements RipplePathFindResult {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        List<PathAlternative> alternatives = ImmutableList.of();
        @Nullable
        Address destinationAccount;
        @Nullable
        List<String> destinationCurrencies = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="alternatives")
        public void setAlternatives(List<PathAlternative> alternatives) {
            this.alternatives = alternatives;
        }

        @JsonProperty(value="destination_account")
        public void setDestinationAccount(Address destinationAccount) {
            this.destinationAccount = destinationAccount;
        }

        @JsonProperty(value="destination_currencies")
        public void setDestinationCurrencies(List<String> destinationCurrencies) {
            this.destinationCurrencies = destinationCurrencies;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<PathAlternative> alternatives() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address destinationAccount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> destinationCurrencies() {
            throw new UnsupportedOperationException();
        }
    }
}

