/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.ledger;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Optional;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.LegacyLedgerSpecifierUtils;
import org.xrpl.xrpl4j.model.client.XrplRequestParams;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.common.LedgerSpecifier;
import org.xrpl.xrpl4j.model.client.ledger.ImmutableLedgerRequestParams;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@JsonSerialize(as=ImmutableLedgerRequestParams.class)
@JsonDeserialize(as=ImmutableLedgerRequestParams.class)
@Value.Immutable
public interface LedgerRequestParams
extends XrplRequestParams {
    public static ImmutableLedgerRequestParams.Builder builder() {
        return ImmutableLedgerRequestParams.builder();
    }

    @JsonIgnore
    @Deprecated
    @Value.Auxiliary
    public Optional<Hash256> ledgerHash();

    @JsonIgnore
    @Deprecated
    @Nullable
    @Value.Auxiliary
    public LedgerIndex ledgerIndex();

    @JsonUnwrapped
    @Value.Default
    default public LedgerSpecifier ledgerSpecifier() {
        return LegacyLedgerSpecifierUtils.computeLedgerSpecifier(this.ledgerHash(), this.ledgerIndex());
    }

    @Value.Default
    default public boolean full() {
        return false;
    }

    @Value.Default
    default public boolean accounts() {
        return false;
    }

    @Value.Default
    default public boolean transactions() {
        return false;
    }

    @Value.Derived
    default public boolean expand() {
        return true;
    }

    @JsonProperty(value="owner_funds")
    @Value.Default
    default public boolean ownerFunds() {
        return false;
    }

    @Value.Derived
    default public boolean binary() {
        return false;
    }

    @Value.Default
    default public boolean queue() {
        return false;
    }
}

