/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.fees;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.fees.FeeDrops;
import org.xrpl.xrpl4j.model.client.fees.FeeLevels;
import org.xrpl.xrpl4j.model.client.fees.FeeResult;
import org.xrpl.xrpl4j.model.jackson.modules.UnsignedIntegerStringDeserializer;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FeeResult", generator="Immutables")
@Immutable
public final class ImmutableFeeResult
implements FeeResult {
    @Nullable
    private final String status;
    private final UnsignedInteger currentLedgerSize;
    private final UnsignedInteger currentQueueSize;
    private final FeeDrops drops;
    private final UnsignedInteger expectedLedgerSize;
    private final LedgerIndex ledgerCurrentIndex;
    private final FeeLevels levels;
    @Nullable
    private final UnsignedInteger maxQueueSize;

    private ImmutableFeeResult(@Nullable String status, UnsignedInteger currentLedgerSize, UnsignedInteger currentQueueSize, FeeDrops drops, UnsignedInteger expectedLedgerSize, LedgerIndex ledgerCurrentIndex, FeeLevels levels, @Nullable UnsignedInteger maxQueueSize) {
        this.status = status;
        this.currentLedgerSize = currentLedgerSize;
        this.currentQueueSize = currentQueueSize;
        this.drops = drops;
        this.expectedLedgerSize = expectedLedgerSize;
        this.ledgerCurrentIndex = ledgerCurrentIndex;
        this.levels = levels;
        this.maxQueueSize = maxQueueSize;
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="current_ledger_size")
    @JsonDeserialize(using=UnsignedIntegerStringDeserializer.class)
    @JsonSerialize(using=ToStringSerializer.class)
    public UnsignedInteger currentLedgerSize() {
        return this.currentLedgerSize;
    }

    @Override
    @JsonProperty(value="current_queue_size")
    @JsonDeserialize(using=UnsignedIntegerStringDeserializer.class)
    @JsonSerialize(using=ToStringSerializer.class)
    public UnsignedInteger currentQueueSize() {
        return this.currentQueueSize;
    }

    @Override
    @JsonProperty(value="drops")
    public FeeDrops drops() {
        return this.drops;
    }

    @Override
    @JsonProperty(value="expected_ledger_size")
    @JsonDeserialize(using=UnsignedIntegerStringDeserializer.class)
    @JsonSerialize(using=ToStringSerializer.class)
    public UnsignedInteger expectedLedgerSize() {
        return this.expectedLedgerSize;
    }

    @Override
    @JsonProperty(value="ledger_current_index")
    public LedgerIndex ledgerCurrentIndex() {
        return this.ledgerCurrentIndex;
    }

    @Override
    @JsonProperty(value="levels")
    public FeeLevels levels() {
        return this.levels;
    }

    @Override
    @JsonProperty(value="max_queue_size")
    @JsonDeserialize(contentUsing=UnsignedIntegerStringDeserializer.class)
    @JsonSerialize(contentUsing=ToStringSerializer.class)
    public Optional<UnsignedInteger> maxQueueSize() {
        return Optional.ofNullable(this.maxQueueSize);
    }

    public final ImmutableFeeResult withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableFeeResult(newValue, this.currentLedgerSize, this.currentQueueSize, this.drops, this.expectedLedgerSize, this.ledgerCurrentIndex, this.levels, this.maxQueueSize);
    }

    public final ImmutableFeeResult withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableFeeResult(value, this.currentLedgerSize, this.currentQueueSize, this.drops, this.expectedLedgerSize, this.ledgerCurrentIndex, this.levels, this.maxQueueSize);
    }

    public final ImmutableFeeResult withCurrentLedgerSize(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "currentLedgerSize");
        if (this.currentLedgerSize.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableFeeResult(this.status, newValue, this.currentQueueSize, this.drops, this.expectedLedgerSize, this.ledgerCurrentIndex, this.levels, this.maxQueueSize);
    }

    public final ImmutableFeeResult withCurrentQueueSize(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "currentQueueSize");
        if (this.currentQueueSize.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableFeeResult(this.status, this.currentLedgerSize, newValue, this.drops, this.expectedLedgerSize, this.ledgerCurrentIndex, this.levels, this.maxQueueSize);
    }

    public final ImmutableFeeResult withDrops(FeeDrops value) {
        if (this.drops == value) {
            return this;
        }
        FeeDrops newValue = Objects.requireNonNull(value, "drops");
        return new ImmutableFeeResult(this.status, this.currentLedgerSize, this.currentQueueSize, newValue, this.expectedLedgerSize, this.ledgerCurrentIndex, this.levels, this.maxQueueSize);
    }

    public final ImmutableFeeResult withExpectedLedgerSize(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "expectedLedgerSize");
        if (this.expectedLedgerSize.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableFeeResult(this.status, this.currentLedgerSize, this.currentQueueSize, this.drops, newValue, this.ledgerCurrentIndex, this.levels, this.maxQueueSize);
    }

    public final ImmutableFeeResult withLedgerCurrentIndex(LedgerIndex value) {
        if (this.ledgerCurrentIndex == value) {
            return this;
        }
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerCurrentIndex");
        return new ImmutableFeeResult(this.status, this.currentLedgerSize, this.currentQueueSize, this.drops, this.expectedLedgerSize, newValue, this.levels, this.maxQueueSize);
    }

    public final ImmutableFeeResult withLevels(FeeLevels value) {
        if (this.levels == value) {
            return this;
        }
        FeeLevels newValue = Objects.requireNonNull(value, "levels");
        return new ImmutableFeeResult(this.status, this.currentLedgerSize, this.currentQueueSize, this.drops, this.expectedLedgerSize, this.ledgerCurrentIndex, newValue, this.maxQueueSize);
    }

    public final ImmutableFeeResult withMaxQueueSize(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "maxQueueSize");
        if (Objects.equals(this.maxQueueSize, newValue)) {
            return this;
        }
        return new ImmutableFeeResult(this.status, this.currentLedgerSize, this.currentQueueSize, this.drops, this.expectedLedgerSize, this.ledgerCurrentIndex, this.levels, newValue);
    }

    public final ImmutableFeeResult withMaxQueueSize(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.maxQueueSize, value)) {
            return this;
        }
        return new ImmutableFeeResult(this.status, this.currentLedgerSize, this.currentQueueSize, this.drops, this.expectedLedgerSize, this.ledgerCurrentIndex, this.levels, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFeeResult && this.equalTo((ImmutableFeeResult)another);
    }

    private boolean equalTo(ImmutableFeeResult another) {
        return Objects.equals(this.status, another.status) && this.currentLedgerSize.equals((Object)another.currentLedgerSize) && this.currentQueueSize.equals((Object)another.currentQueueSize) && this.drops.equals(another.drops) && this.expectedLedgerSize.equals((Object)another.expectedLedgerSize) && this.ledgerCurrentIndex.equals(another.ledgerCurrentIndex) && this.levels.equals(another.levels) && Objects.equals(this.maxQueueSize, another.maxQueueSize);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + this.currentLedgerSize.hashCode();
        h += (h << 5) + this.currentQueueSize.hashCode();
        h += (h << 5) + this.drops.hashCode();
        h += (h << 5) + this.expectedLedgerSize.hashCode();
        h += (h << 5) + this.ledgerCurrentIndex.hashCode();
        h += (h << 5) + this.levels.hashCode();
        h += (h << 5) + Objects.hashCode(this.maxQueueSize);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FeeResult").omitNullValues().add("status", (Object)this.status).add("currentLedgerSize", (Object)this.currentLedgerSize).add("currentQueueSize", (Object)this.currentQueueSize).add("drops", (Object)this.drops).add("expectedLedgerSize", (Object)this.expectedLedgerSize).add("ledgerCurrentIndex", (Object)this.ledgerCurrentIndex).add("levels", (Object)this.levels).add("maxQueueSize", (Object)this.maxQueueSize).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFeeResult fromJson(Json json) {
        Builder builder = ImmutableFeeResult.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.currentLedgerSize != null) {
            builder.currentLedgerSize(json.currentLedgerSize);
        }
        if (json.currentQueueSize != null) {
            builder.currentQueueSize(json.currentQueueSize);
        }
        if (json.drops != null) {
            builder.drops(json.drops);
        }
        if (json.expectedLedgerSize != null) {
            builder.expectedLedgerSize(json.expectedLedgerSize);
        }
        if (json.ledgerCurrentIndex != null) {
            builder.ledgerCurrentIndex(json.ledgerCurrentIndex);
        }
        if (json.levels != null) {
            builder.levels(json.levels);
        }
        if (json.maxQueueSize != null) {
            builder.maxQueueSize(json.maxQueueSize);
        }
        return builder.build();
    }

    public static ImmutableFeeResult copyOf(FeeResult instance) {
        if (instance instanceof ImmutableFeeResult) {
            return (ImmutableFeeResult)instance;
        }
        return ImmutableFeeResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FeeResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CURRENT_LEDGER_SIZE = 1L;
        private static final long INIT_BIT_CURRENT_QUEUE_SIZE = 2L;
        private static final long INIT_BIT_DROPS = 4L;
        private static final long INIT_BIT_EXPECTED_LEDGER_SIZE = 8L;
        private static final long INIT_BIT_LEDGER_CURRENT_INDEX = 16L;
        private static final long INIT_BIT_LEVELS = 32L;
        private long initBits = 63L;
        @Nullable
        private String status;
        @Nullable
        private UnsignedInteger currentLedgerSize;
        @Nullable
        private UnsignedInteger currentQueueSize;
        @Nullable
        private FeeDrops drops;
        @Nullable
        private UnsignedInteger expectedLedgerSize;
        @Nullable
        private LedgerIndex ledgerCurrentIndex;
        @Nullable
        private FeeLevels levels;
        @Nullable
        private UnsignedInteger maxQueueSize;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(FeeResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            XrplResult instance;
            Optional<String> statusOptional;
            if (object instanceof XrplResult && (statusOptional = (instance = (XrplResult)object).status()).isPresent()) {
                this.status(statusOptional);
            }
            if (object instanceof FeeResult) {
                instance = (FeeResult)object;
                this.drops(instance.drops());
                this.currentLedgerSize(instance.currentLedgerSize());
                Optional<UnsignedInteger> maxQueueSizeOptional = instance.maxQueueSize();
                if (maxQueueSizeOptional.isPresent()) {
                    this.maxQueueSize(maxQueueSizeOptional);
                }
                this.currentQueueSize(instance.currentQueueSize());
                this.expectedLedgerSize(instance.expectedLedgerSize());
                this.ledgerCurrentIndex(instance.ledgerCurrentIndex());
                this.levels(instance.levels());
            }
        }

        @CanIgnoreReturnValue
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @JsonProperty(value="current_ledger_size")
        @JsonDeserialize(using=UnsignedIntegerStringDeserializer.class)
        @JsonSerialize(using=ToStringSerializer.class)
        @CanIgnoreReturnValue
        public final Builder currentLedgerSize(UnsignedInteger currentLedgerSize) {
            this.currentLedgerSize = Objects.requireNonNull(currentLedgerSize, "currentLedgerSize");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="current_queue_size")
        @JsonDeserialize(using=UnsignedIntegerStringDeserializer.class)
        @JsonSerialize(using=ToStringSerializer.class)
        @CanIgnoreReturnValue
        public final Builder currentQueueSize(UnsignedInteger currentQueueSize) {
            this.currentQueueSize = Objects.requireNonNull(currentQueueSize, "currentQueueSize");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="drops")
        @CanIgnoreReturnValue
        public final Builder drops(FeeDrops drops) {
            this.drops = Objects.requireNonNull(drops, "drops");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="expected_ledger_size")
        @JsonDeserialize(using=UnsignedIntegerStringDeserializer.class)
        @JsonSerialize(using=ToStringSerializer.class)
        @CanIgnoreReturnValue
        public final Builder expectedLedgerSize(UnsignedInteger expectedLedgerSize) {
            this.expectedLedgerSize = Objects.requireNonNull(expectedLedgerSize, "expectedLedgerSize");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="ledger_current_index")
        @CanIgnoreReturnValue
        public final Builder ledgerCurrentIndex(LedgerIndex ledgerCurrentIndex) {
            this.ledgerCurrentIndex = Objects.requireNonNull(ledgerCurrentIndex, "ledgerCurrentIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="levels")
        @CanIgnoreReturnValue
        public final Builder levels(FeeLevels levels) {
            this.levels = Objects.requireNonNull(levels, "levels");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maxQueueSize(UnsignedInteger maxQueueSize) {
            this.maxQueueSize = Objects.requireNonNull(maxQueueSize, "maxQueueSize");
            return this;
        }

        @JsonProperty(value="max_queue_size")
        @JsonDeserialize(contentUsing=UnsignedIntegerStringDeserializer.class)
        @JsonSerialize(contentUsing=ToStringSerializer.class)
        @CanIgnoreReturnValue
        public final Builder maxQueueSize(Optional<? extends UnsignedInteger> maxQueueSize) {
            this.maxQueueSize = maxQueueSize.orElse(null);
            return this;
        }

        public ImmutableFeeResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFeeResult(this.status, this.currentLedgerSize, this.currentQueueSize, this.drops, this.expectedLedgerSize, this.ledgerCurrentIndex, this.levels, this.maxQueueSize);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("currentLedgerSize");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("currentQueueSize");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("drops");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("expectedLedgerSize");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("ledgerCurrentIndex");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("levels");
            }
            return "Cannot build FeeResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FeeResult", generator="Immutables")
    static final class Json
    implements FeeResult {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        UnsignedInteger currentLedgerSize;
        @Nullable
        UnsignedInteger currentQueueSize;
        @Nullable
        FeeDrops drops;
        @Nullable
        UnsignedInteger expectedLedgerSize;
        @Nullable
        LedgerIndex ledgerCurrentIndex;
        @Nullable
        FeeLevels levels;
        @Nullable
        Optional<UnsignedInteger> maxQueueSize = Optional.empty();

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="current_ledger_size")
        @JsonDeserialize(using=UnsignedIntegerStringDeserializer.class)
        @JsonSerialize(using=ToStringSerializer.class)
        public void setCurrentLedgerSize(UnsignedInteger currentLedgerSize) {
            this.currentLedgerSize = currentLedgerSize;
        }

        @JsonProperty(value="current_queue_size")
        @JsonDeserialize(using=UnsignedIntegerStringDeserializer.class)
        @JsonSerialize(using=ToStringSerializer.class)
        public void setCurrentQueueSize(UnsignedInteger currentQueueSize) {
            this.currentQueueSize = currentQueueSize;
        }

        @JsonProperty(value="drops")
        public void setDrops(FeeDrops drops) {
            this.drops = drops;
        }

        @JsonProperty(value="expected_ledger_size")
        @JsonDeserialize(using=UnsignedIntegerStringDeserializer.class)
        @JsonSerialize(using=ToStringSerializer.class)
        public void setExpectedLedgerSize(UnsignedInteger expectedLedgerSize) {
            this.expectedLedgerSize = expectedLedgerSize;
        }

        @JsonProperty(value="ledger_current_index")
        public void setLedgerCurrentIndex(LedgerIndex ledgerCurrentIndex) {
            this.ledgerCurrentIndex = ledgerCurrentIndex;
        }

        @JsonProperty(value="levels")
        public void setLevels(FeeLevels levels) {
            this.levels = levels;
        }

        @JsonProperty(value="max_queue_size")
        @JsonDeserialize(contentUsing=UnsignedIntegerStringDeserializer.class)
        @JsonSerialize(contentUsing=ToStringSerializer.class)
        public void setMaxQueueSize(Optional<UnsignedInteger> maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger currentLedgerSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger currentQueueSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FeeDrops drops() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger expectedLedgerSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerIndex ledgerCurrentIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FeeLevels levels() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> maxQueueSize() {
            throw new UnsupportedOperationException();
        }
    }
}

