/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.fees;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.fees.FeeDrops;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FeeDrops", generator="Immutables")
@Immutable
public final class ImmutableFeeDrops
implements FeeDrops {
    private final XrpCurrencyAmount baseFee;
    private final XrpCurrencyAmount minimumFee;
    private final XrpCurrencyAmount medianFee;
    private final XrpCurrencyAmount openLedgerFee;

    private ImmutableFeeDrops(XrpCurrencyAmount baseFee, XrpCurrencyAmount minimumFee, XrpCurrencyAmount medianFee, XrpCurrencyAmount openLedgerFee) {
        this.baseFee = baseFee;
        this.minimumFee = minimumFee;
        this.medianFee = medianFee;
        this.openLedgerFee = openLedgerFee;
    }

    @Override
    @JsonProperty(value="base_fee")
    public XrpCurrencyAmount baseFee() {
        return this.baseFee;
    }

    @Override
    @JsonProperty(value="minimum_fee")
    public XrpCurrencyAmount minimumFee() {
        return this.minimumFee;
    }

    @Override
    @JsonProperty(value="median_fee")
    public XrpCurrencyAmount medianFee() {
        return this.medianFee;
    }

    @Override
    @JsonProperty(value="open_ledger_fee")
    public XrpCurrencyAmount openLedgerFee() {
        return this.openLedgerFee;
    }

    public final ImmutableFeeDrops withBaseFee(XrpCurrencyAmount value) {
        if (this.baseFee == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "baseFee");
        return new ImmutableFeeDrops(newValue, this.minimumFee, this.medianFee, this.openLedgerFee);
    }

    public final ImmutableFeeDrops withMinimumFee(XrpCurrencyAmount value) {
        if (this.minimumFee == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "minimumFee");
        return new ImmutableFeeDrops(this.baseFee, newValue, this.medianFee, this.openLedgerFee);
    }

    public final ImmutableFeeDrops withMedianFee(XrpCurrencyAmount value) {
        if (this.medianFee == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "medianFee");
        return new ImmutableFeeDrops(this.baseFee, this.minimumFee, newValue, this.openLedgerFee);
    }

    public final ImmutableFeeDrops withOpenLedgerFee(XrpCurrencyAmount value) {
        if (this.openLedgerFee == value) {
            return this;
        }
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "openLedgerFee");
        return new ImmutableFeeDrops(this.baseFee, this.minimumFee, this.medianFee, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFeeDrops && this.equalTo((ImmutableFeeDrops)another);
    }

    private boolean equalTo(ImmutableFeeDrops another) {
        return this.baseFee.equals(another.baseFee) && this.minimumFee.equals(another.minimumFee) && this.medianFee.equals(another.medianFee) && this.openLedgerFee.equals(another.openLedgerFee);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.baseFee.hashCode();
        h += (h << 5) + this.minimumFee.hashCode();
        h += (h << 5) + this.medianFee.hashCode();
        h += (h << 5) + this.openLedgerFee.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FeeDrops").omitNullValues().add("baseFee", (Object)this.baseFee).add("minimumFee", (Object)this.minimumFee).add("medianFee", (Object)this.medianFee).add("openLedgerFee", (Object)this.openLedgerFee).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFeeDrops fromJson(Json json) {
        Builder builder = ImmutableFeeDrops.builder();
        if (json.baseFee != null) {
            builder.baseFee(json.baseFee);
        }
        if (json.minimumFee != null) {
            builder.minimumFee(json.minimumFee);
        }
        if (json.medianFee != null) {
            builder.medianFee(json.medianFee);
        }
        if (json.openLedgerFee != null) {
            builder.openLedgerFee(json.openLedgerFee);
        }
        return builder.build();
    }

    public static ImmutableFeeDrops copyOf(FeeDrops instance) {
        if (instance instanceof ImmutableFeeDrops) {
            return (ImmutableFeeDrops)instance;
        }
        return ImmutableFeeDrops.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FeeDrops", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BASE_FEE = 1L;
        private static final long INIT_BIT_MINIMUM_FEE = 2L;
        private static final long INIT_BIT_MEDIAN_FEE = 4L;
        private static final long INIT_BIT_OPEN_LEDGER_FEE = 8L;
        private long initBits = 15L;
        @Nullable
        private XrpCurrencyAmount baseFee;
        @Nullable
        private XrpCurrencyAmount minimumFee;
        @Nullable
        private XrpCurrencyAmount medianFee;
        @Nullable
        private XrpCurrencyAmount openLedgerFee;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FeeDrops instance) {
            Objects.requireNonNull(instance, "instance");
            this.baseFee(instance.baseFee());
            this.minimumFee(instance.minimumFee());
            this.medianFee(instance.medianFee());
            this.openLedgerFee(instance.openLedgerFee());
            return this;
        }

        @JsonProperty(value="base_fee")
        @CanIgnoreReturnValue
        public final Builder baseFee(XrpCurrencyAmount baseFee) {
            this.baseFee = Objects.requireNonNull(baseFee, "baseFee");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="minimum_fee")
        @CanIgnoreReturnValue
        public final Builder minimumFee(XrpCurrencyAmount minimumFee) {
            this.minimumFee = Objects.requireNonNull(minimumFee, "minimumFee");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="median_fee")
        @CanIgnoreReturnValue
        public final Builder medianFee(XrpCurrencyAmount medianFee) {
            this.medianFee = Objects.requireNonNull(medianFee, "medianFee");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="open_ledger_fee")
        @CanIgnoreReturnValue
        public final Builder openLedgerFee(XrpCurrencyAmount openLedgerFee) {
            this.openLedgerFee = Objects.requireNonNull(openLedgerFee, "openLedgerFee");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableFeeDrops build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFeeDrops(this.baseFee, this.minimumFee, this.medianFee, this.openLedgerFee);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("baseFee");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("minimumFee");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("medianFee");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("openLedgerFee");
            }
            return "Cannot build FeeDrops, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FeeDrops", generator="Immutables")
    static final class Json
    implements FeeDrops {
        @Nullable
        XrpCurrencyAmount baseFee;
        @Nullable
        XrpCurrencyAmount minimumFee;
        @Nullable
        XrpCurrencyAmount medianFee;
        @Nullable
        XrpCurrencyAmount openLedgerFee;

        Json() {
        }

        @JsonProperty(value="base_fee")
        public void setBaseFee(XrpCurrencyAmount baseFee) {
            this.baseFee = baseFee;
        }

        @JsonProperty(value="minimum_fee")
        public void setMinimumFee(XrpCurrencyAmount minimumFee) {
            this.minimumFee = minimumFee;
        }

        @JsonProperty(value="median_fee")
        public void setMedianFee(XrpCurrencyAmount medianFee) {
            this.medianFee = medianFee;
        }

        @JsonProperty(value="open_ledger_fee")
        public void setOpenLedgerFee(XrpCurrencyAmount openLedgerFee) {
            this.openLedgerFee = openLedgerFee;
        }

        @Override
        public XrpCurrencyAmount baseFee() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount minimumFee() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount medianFee() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XrpCurrencyAmount openLedgerFee() {
            throw new UnsupportedOperationException();
        }
    }
}

