/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.common;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import java.util.Objects;
import org.xrpl.xrpl4j.model.immutables.FluentCompareTo;

public class LedgerIndex {
    @Deprecated
    public static final LedgerIndex CURRENT = LedgerIndex.of("current");
    @Deprecated
    public static final LedgerIndex VALIDATED = LedgerIndex.of("validated");
    @Deprecated
    public static final LedgerIndex CLOSED = LedgerIndex.of("closed");
    private final String value;

    @Deprecated
    public LedgerIndex(String value) {
        this.value = value;
    }

    @Deprecated
    public static LedgerIndex of(String value) throws NumberFormatException {
        Objects.requireNonNull(value);
        if (LedgerIndex.isValidShortcut(value)) {
            return new LedgerIndex(value);
        }
        UnsignedLong.valueOf((String)value);
        return new LedgerIndex(value);
    }

    @Deprecated
    public static LedgerIndex of(UnsignedLong value) {
        Objects.requireNonNull(value);
        return new LedgerIndex(value.toString());
    }

    public static LedgerIndex of(UnsignedInteger value) {
        Objects.requireNonNull(value);
        return new LedgerIndex(value.toString());
    }

    private static boolean isValidShortcut(String value) {
        if (value.equals("current")) {
            return true;
        }
        if (value.equals("validated")) {
            return true;
        }
        return value.equals("closed");
    }

    @Deprecated
    public String value() {
        return this.value;
    }

    @Deprecated
    public UnsignedLong unsignedLongValue() {
        return UnsignedLong.valueOf((String)this.value);
    }

    public UnsignedInteger unsignedIntegerValue() {
        return UnsignedInteger.valueOf((String)this.value);
    }

    @Deprecated
    public LedgerIndex plus(UnsignedLong other) {
        return LedgerIndex.of(this.unsignedLongValue().plus(other));
    }

    public LedgerIndex plus(UnsignedInteger other) {
        this.checkAdditionOverflow(other);
        return LedgerIndex.of(this.unsignedIntegerValue().plus(other));
    }

    public LedgerIndex plus(LedgerIndex other) {
        return this.plus(other.unsignedIntegerValue());
    }

    public LedgerIndex minus(LedgerIndex other) {
        return this.minus(other.unsignedIntegerValue());
    }

    public LedgerIndex minus(UnsignedInteger value) {
        this.checkSubtractionOverflow(value);
        return LedgerIndex.of(this.unsignedIntegerValue().minus(value));
    }

    private void checkAdditionOverflow(UnsignedInteger addedValue) {
        Preconditions.checkArgument((boolean)FluentCompareTo.is(UnsignedInteger.MAX_VALUE.minus(addedValue)).greaterThanEqualTo(this.unsignedIntegerValue()), (Object)String.format("Value too large. Adding %s would cause an overflow.", addedValue));
    }

    private void checkSubtractionOverflow(UnsignedInteger subtractedValue) {
        Preconditions.checkArgument((boolean)FluentCompareTo.is(subtractedValue).lessThanOrEqualTo(this.unsignedIntegerValue()), (Object)String.format("Value too large. Subtracting %s would cause an overflow.", subtractedValue));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LedgerIndex)) {
            return false;
        }
        LedgerIndex that = (LedgerIndex)obj;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value();
    }
}

