/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.primitives.UnsignedInteger;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.accounts.ImmutableTrustLine;
import org.xrpl.xrpl4j.model.transactions.Address;

@JsonSerialize(as=ImmutableTrustLine.class)
@JsonDeserialize(as=ImmutableTrustLine.class)
@Value.Immutable
public interface TrustLine {
    public static ImmutableTrustLine.Builder builder() {
        return ImmutableTrustLine.builder();
    }

    public Address account();

    public String balance();

    public String currency();

    public String limit();

    @JsonProperty(value="limit_peer")
    public String limitPeer();

    @JsonProperty(value="quality_in")
    public UnsignedInteger qualityIn();

    @JsonProperty(value="quality_out")
    public UnsignedInteger qualityOut();

    @JsonProperty(value="no_ripple")
    @Value.Default
    default public boolean noRipple() {
        return false;
    }

    @JsonProperty(value="no_ripple_peer")
    @Value.Default
    default public boolean noRipplePeer() {
        return false;
    }

    @Value.Default
    default public boolean authorized() {
        return false;
    }

    @JsonProperty(value="peer_authorized")
    @Value.Default
    default public boolean peerAuthorized() {
        return false;
    }

    @Value.Default
    default public boolean freeze() {
        return false;
    }

    @JsonProperty(value="freeze_peer")
    @Value.Default
    default public boolean freezePeer() {
        return false;
    }
}

