/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.accounts.TrustLine;
import org.xrpl.xrpl4j.model.transactions.Address;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TrustLine", generator="Immutables")
@Immutable
public final class ImmutableTrustLine
implements TrustLine {
    private final Address account;
    private final String balance;
    private final String currency;
    private final String limit;
    private final String limitPeer;
    private final UnsignedInteger qualityIn;
    private final UnsignedInteger qualityOut;
    private final boolean noRipple;
    private final boolean noRipplePeer;
    private final boolean authorized;
    private final boolean peerAuthorized;
    private final boolean freeze;
    private final boolean freezePeer;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTrustLine(Builder builder) {
        this.account = builder.account;
        this.balance = builder.balance;
        this.currency = builder.currency;
        this.limit = builder.limit;
        this.limitPeer = builder.limitPeer;
        this.qualityIn = builder.qualityIn;
        this.qualityOut = builder.qualityOut;
        if (builder.noRippleIsSet()) {
            this.initShim.noRipple(builder.noRipple);
        }
        if (builder.noRipplePeerIsSet()) {
            this.initShim.noRipplePeer(builder.noRipplePeer);
        }
        if (builder.authorizedIsSet()) {
            this.initShim.authorized(builder.authorized);
        }
        if (builder.peerAuthorizedIsSet()) {
            this.initShim.peerAuthorized(builder.peerAuthorized);
        }
        if (builder.freezeIsSet()) {
            this.initShim.freeze(builder.freeze);
        }
        if (builder.freezePeerIsSet()) {
            this.initShim.freezePeer(builder.freezePeer);
        }
        this.noRipple = this.initShim.noRipple();
        this.noRipplePeer = this.initShim.noRipplePeer();
        this.authorized = this.initShim.authorized();
        this.peerAuthorized = this.initShim.peerAuthorized();
        this.freeze = this.initShim.freeze();
        this.freezePeer = this.initShim.freezePeer();
        this.initShim = null;
    }

    private ImmutableTrustLine(Address account, String balance, String currency, String limit, String limitPeer, UnsignedInteger qualityIn, UnsignedInteger qualityOut, boolean noRipple, boolean noRipplePeer, boolean authorized, boolean peerAuthorized, boolean freeze, boolean freezePeer) {
        this.account = account;
        this.balance = balance;
        this.currency = currency;
        this.limit = limit;
        this.limitPeer = limitPeer;
        this.qualityIn = qualityIn;
        this.qualityOut = qualityOut;
        this.noRipple = noRipple;
        this.noRipplePeer = noRipplePeer;
        this.authorized = authorized;
        this.peerAuthorized = peerAuthorized;
        this.freeze = freeze;
        this.freezePeer = freezePeer;
        this.initShim = null;
    }

    private boolean noRippleInitialize() {
        return TrustLine.super.noRipple();
    }

    private boolean noRipplePeerInitialize() {
        return TrustLine.super.noRipplePeer();
    }

    private boolean authorizedInitialize() {
        return TrustLine.super.authorized();
    }

    private boolean peerAuthorizedInitialize() {
        return TrustLine.super.peerAuthorized();
    }

    private boolean freezeInitialize() {
        return TrustLine.super.freeze();
    }

    private boolean freezePeerInitialize() {
        return TrustLine.super.freezePeer();
    }

    @Override
    @JsonProperty(value="account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="balance")
    public String balance() {
        return this.balance;
    }

    @Override
    @JsonProperty(value="currency")
    public String currency() {
        return this.currency;
    }

    @Override
    @JsonProperty(value="limit")
    public String limit() {
        return this.limit;
    }

    @Override
    @JsonProperty(value="limit_peer")
    public String limitPeer() {
        return this.limitPeer;
    }

    @Override
    @JsonProperty(value="quality_in")
    public UnsignedInteger qualityIn() {
        return this.qualityIn;
    }

    @Override
    @JsonProperty(value="quality_out")
    public UnsignedInteger qualityOut() {
        return this.qualityOut;
    }

    @Override
    @JsonProperty(value="no_ripple")
    public boolean noRipple() {
        InitShim shim = this.initShim;
        return shim != null ? shim.noRipple() : this.noRipple;
    }

    @Override
    @JsonProperty(value="no_ripple_peer")
    public boolean noRipplePeer() {
        InitShim shim = this.initShim;
        return shim != null ? shim.noRipplePeer() : this.noRipplePeer;
    }

    @Override
    @JsonProperty(value="authorized")
    public boolean authorized() {
        InitShim shim = this.initShim;
        return shim != null ? shim.authorized() : this.authorized;
    }

    @Override
    @JsonProperty(value="peer_authorized")
    public boolean peerAuthorized() {
        InitShim shim = this.initShim;
        return shim != null ? shim.peerAuthorized() : this.peerAuthorized;
    }

    @Override
    @JsonProperty(value="freeze")
    public boolean freeze() {
        InitShim shim = this.initShim;
        return shim != null ? shim.freeze() : this.freeze;
    }

    @Override
    @JsonProperty(value="freeze_peer")
    public boolean freezePeer() {
        InitShim shim = this.initShim;
        return shim != null ? shim.freezePeer() : this.freezePeer;
    }

    public final ImmutableTrustLine withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableTrustLine(newValue, this.balance, this.currency, this.limit, this.limitPeer, this.qualityIn, this.qualityOut, this.noRipple, this.noRipplePeer, this.authorized, this.peerAuthorized, this.freeze, this.freezePeer);
    }

    public final ImmutableTrustLine withBalance(String value) {
        String newValue = Objects.requireNonNull(value, "balance");
        if (this.balance.equals(newValue)) {
            return this;
        }
        return new ImmutableTrustLine(this.account, newValue, this.currency, this.limit, this.limitPeer, this.qualityIn, this.qualityOut, this.noRipple, this.noRipplePeer, this.authorized, this.peerAuthorized, this.freeze, this.freezePeer);
    }

    public final ImmutableTrustLine withCurrency(String value) {
        String newValue = Objects.requireNonNull(value, "currency");
        if (this.currency.equals(newValue)) {
            return this;
        }
        return new ImmutableTrustLine(this.account, this.balance, newValue, this.limit, this.limitPeer, this.qualityIn, this.qualityOut, this.noRipple, this.noRipplePeer, this.authorized, this.peerAuthorized, this.freeze, this.freezePeer);
    }

    public final ImmutableTrustLine withLimit(String value) {
        String newValue = Objects.requireNonNull(value, "limit");
        if (this.limit.equals(newValue)) {
            return this;
        }
        return new ImmutableTrustLine(this.account, this.balance, this.currency, newValue, this.limitPeer, this.qualityIn, this.qualityOut, this.noRipple, this.noRipplePeer, this.authorized, this.peerAuthorized, this.freeze, this.freezePeer);
    }

    public final ImmutableTrustLine withLimitPeer(String value) {
        String newValue = Objects.requireNonNull(value, "limitPeer");
        if (this.limitPeer.equals(newValue)) {
            return this;
        }
        return new ImmutableTrustLine(this.account, this.balance, this.currency, this.limit, newValue, this.qualityIn, this.qualityOut, this.noRipple, this.noRipplePeer, this.authorized, this.peerAuthorized, this.freeze, this.freezePeer);
    }

    public final ImmutableTrustLine withQualityIn(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "qualityIn");
        if (this.qualityIn.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableTrustLine(this.account, this.balance, this.currency, this.limit, this.limitPeer, newValue, this.qualityOut, this.noRipple, this.noRipplePeer, this.authorized, this.peerAuthorized, this.freeze, this.freezePeer);
    }

    public final ImmutableTrustLine withQualityOut(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "qualityOut");
        if (this.qualityOut.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableTrustLine(this.account, this.balance, this.currency, this.limit, this.limitPeer, this.qualityIn, newValue, this.noRipple, this.noRipplePeer, this.authorized, this.peerAuthorized, this.freeze, this.freezePeer);
    }

    public final ImmutableTrustLine withNoRipple(boolean value) {
        if (this.noRipple == value) {
            return this;
        }
        return new ImmutableTrustLine(this.account, this.balance, this.currency, this.limit, this.limitPeer, this.qualityIn, this.qualityOut, value, this.noRipplePeer, this.authorized, this.peerAuthorized, this.freeze, this.freezePeer);
    }

    public final ImmutableTrustLine withNoRipplePeer(boolean value) {
        if (this.noRipplePeer == value) {
            return this;
        }
        return new ImmutableTrustLine(this.account, this.balance, this.currency, this.limit, this.limitPeer, this.qualityIn, this.qualityOut, this.noRipple, value, this.authorized, this.peerAuthorized, this.freeze, this.freezePeer);
    }

    public final ImmutableTrustLine withAuthorized(boolean value) {
        if (this.authorized == value) {
            return this;
        }
        return new ImmutableTrustLine(this.account, this.balance, this.currency, this.limit, this.limitPeer, this.qualityIn, this.qualityOut, this.noRipple, this.noRipplePeer, value, this.peerAuthorized, this.freeze, this.freezePeer);
    }

    public final ImmutableTrustLine withPeerAuthorized(boolean value) {
        if (this.peerAuthorized == value) {
            return this;
        }
        return new ImmutableTrustLine(this.account, this.balance, this.currency, this.limit, this.limitPeer, this.qualityIn, this.qualityOut, this.noRipple, this.noRipplePeer, this.authorized, value, this.freeze, this.freezePeer);
    }

    public final ImmutableTrustLine withFreeze(boolean value) {
        if (this.freeze == value) {
            return this;
        }
        return new ImmutableTrustLine(this.account, this.balance, this.currency, this.limit, this.limitPeer, this.qualityIn, this.qualityOut, this.noRipple, this.noRipplePeer, this.authorized, this.peerAuthorized, value, this.freezePeer);
    }

    public final ImmutableTrustLine withFreezePeer(boolean value) {
        if (this.freezePeer == value) {
            return this;
        }
        return new ImmutableTrustLine(this.account, this.balance, this.currency, this.limit, this.limitPeer, this.qualityIn, this.qualityOut, this.noRipple, this.noRipplePeer, this.authorized, this.peerAuthorized, this.freeze, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTrustLine && this.equalTo((ImmutableTrustLine)another);
    }

    private boolean equalTo(ImmutableTrustLine another) {
        return this.account.equals(another.account) && this.balance.equals(another.balance) && this.currency.equals(another.currency) && this.limit.equals(another.limit) && this.limitPeer.equals(another.limitPeer) && this.qualityIn.equals((Object)another.qualityIn) && this.qualityOut.equals((Object)another.qualityOut) && this.noRipple == another.noRipple && this.noRipplePeer == another.noRipplePeer && this.authorized == another.authorized && this.peerAuthorized == another.peerAuthorized && this.freeze == another.freeze && this.freezePeer == another.freezePeer;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.balance.hashCode();
        h += (h << 5) + this.currency.hashCode();
        h += (h << 5) + this.limit.hashCode();
        h += (h << 5) + this.limitPeer.hashCode();
        h += (h << 5) + this.qualityIn.hashCode();
        h += (h << 5) + this.qualityOut.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.noRipple);
        h += (h << 5) + Booleans.hashCode((boolean)this.noRipplePeer);
        h += (h << 5) + Booleans.hashCode((boolean)this.authorized);
        h += (h << 5) + Booleans.hashCode((boolean)this.peerAuthorized);
        h += (h << 5) + Booleans.hashCode((boolean)this.freeze);
        h += (h << 5) + Booleans.hashCode((boolean)this.freezePeer);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TrustLine").omitNullValues().add("account", (Object)this.account).add("balance", (Object)this.balance).add("currency", (Object)this.currency).add("limit", (Object)this.limit).add("limitPeer", (Object)this.limitPeer).add("qualityIn", (Object)this.qualityIn).add("qualityOut", (Object)this.qualityOut).add("noRipple", this.noRipple).add("noRipplePeer", this.noRipplePeer).add("authorized", this.authorized).add("peerAuthorized", this.peerAuthorized).add("freeze", this.freeze).add("freezePeer", this.freezePeer).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTrustLine fromJson(Json json) {
        Builder builder = ImmutableTrustLine.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.balance != null) {
            builder.balance(json.balance);
        }
        if (json.currency != null) {
            builder.currency(json.currency);
        }
        if (json.limit != null) {
            builder.limit(json.limit);
        }
        if (json.limitPeer != null) {
            builder.limitPeer(json.limitPeer);
        }
        if (json.qualityIn != null) {
            builder.qualityIn(json.qualityIn);
        }
        if (json.qualityOut != null) {
            builder.qualityOut(json.qualityOut);
        }
        if (json.noRippleIsSet) {
            builder.noRipple(json.noRipple);
        }
        if (json.noRipplePeerIsSet) {
            builder.noRipplePeer(json.noRipplePeer);
        }
        if (json.authorizedIsSet) {
            builder.authorized(json.authorized);
        }
        if (json.peerAuthorizedIsSet) {
            builder.peerAuthorized(json.peerAuthorized);
        }
        if (json.freezeIsSet) {
            builder.freeze(json.freeze);
        }
        if (json.freezePeerIsSet) {
            builder.freezePeer(json.freezePeer);
        }
        return builder.build();
    }

    public static ImmutableTrustLine copyOf(TrustLine instance) {
        if (instance instanceof ImmutableTrustLine) {
            return (ImmutableTrustLine)instance;
        }
        return ImmutableTrustLine.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TrustLine", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_BALANCE = 2L;
        private static final long INIT_BIT_CURRENCY = 4L;
        private static final long INIT_BIT_LIMIT = 8L;
        private static final long INIT_BIT_LIMIT_PEER = 16L;
        private static final long INIT_BIT_QUALITY_IN = 32L;
        private static final long INIT_BIT_QUALITY_OUT = 64L;
        private static final long OPT_BIT_NO_RIPPLE = 1L;
        private static final long OPT_BIT_NO_RIPPLE_PEER = 2L;
        private static final long OPT_BIT_AUTHORIZED = 4L;
        private static final long OPT_BIT_PEER_AUTHORIZED = 8L;
        private static final long OPT_BIT_FREEZE = 16L;
        private static final long OPT_BIT_FREEZE_PEER = 32L;
        private long initBits = 127L;
        private long optBits;
        @Nullable
        private Address account;
        @Nullable
        private String balance;
        @Nullable
        private String currency;
        @Nullable
        private String limit;
        @Nullable
        private String limitPeer;
        @Nullable
        private UnsignedInteger qualityIn;
        @Nullable
        private UnsignedInteger qualityOut;
        private boolean noRipple;
        private boolean noRipplePeer;
        private boolean authorized;
        private boolean peerAuthorized;
        private boolean freeze;
        private boolean freezePeer;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TrustLine instance) {
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            this.balance(instance.balance());
            this.currency(instance.currency());
            this.limit(instance.limit());
            this.limitPeer(instance.limitPeer());
            this.qualityIn(instance.qualityIn());
            this.qualityOut(instance.qualityOut());
            this.noRipple(instance.noRipple());
            this.noRipplePeer(instance.noRipplePeer());
            this.authorized(instance.authorized());
            this.peerAuthorized(instance.peerAuthorized());
            this.freeze(instance.freeze());
            this.freezePeer(instance.freezePeer());
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="balance")
        @CanIgnoreReturnValue
        public final Builder balance(String balance) {
            this.balance = Objects.requireNonNull(balance, "balance");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="currency")
        @CanIgnoreReturnValue
        public final Builder currency(String currency) {
            this.currency = Objects.requireNonNull(currency, "currency");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="limit")
        @CanIgnoreReturnValue
        public final Builder limit(String limit) {
            this.limit = Objects.requireNonNull(limit, "limit");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="limit_peer")
        @CanIgnoreReturnValue
        public final Builder limitPeer(String limitPeer) {
            this.limitPeer = Objects.requireNonNull(limitPeer, "limitPeer");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="quality_in")
        @CanIgnoreReturnValue
        public final Builder qualityIn(UnsignedInteger qualityIn) {
            this.qualityIn = Objects.requireNonNull(qualityIn, "qualityIn");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="quality_out")
        @CanIgnoreReturnValue
        public final Builder qualityOut(UnsignedInteger qualityOut) {
            this.qualityOut = Objects.requireNonNull(qualityOut, "qualityOut");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="no_ripple")
        @CanIgnoreReturnValue
        public final Builder noRipple(boolean noRipple) {
            this.noRipple = noRipple;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="no_ripple_peer")
        @CanIgnoreReturnValue
        public final Builder noRipplePeer(boolean noRipplePeer) {
            this.noRipplePeer = noRipplePeer;
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="authorized")
        @CanIgnoreReturnValue
        public final Builder authorized(boolean authorized) {
            this.authorized = authorized;
            this.optBits |= 4L;
            return this;
        }

        @JsonProperty(value="peer_authorized")
        @CanIgnoreReturnValue
        public final Builder peerAuthorized(boolean peerAuthorized) {
            this.peerAuthorized = peerAuthorized;
            this.optBits |= 8L;
            return this;
        }

        @JsonProperty(value="freeze")
        @CanIgnoreReturnValue
        public final Builder freeze(boolean freeze) {
            this.freeze = freeze;
            this.optBits |= 0x10L;
            return this;
        }

        @JsonProperty(value="freeze_peer")
        @CanIgnoreReturnValue
        public final Builder freezePeer(boolean freezePeer) {
            this.freezePeer = freezePeer;
            this.optBits |= 0x20L;
            return this;
        }

        public ImmutableTrustLine build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTrustLine(this);
        }

        private boolean noRippleIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean noRipplePeerIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean authorizedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean peerAuthorizedIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean freezeIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean freezePeerIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("balance");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("currency");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("limit");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("limitPeer");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("qualityIn");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("qualityOut");
            }
            return "Cannot build TrustLine, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TrustLine", generator="Immutables")
    static final class Json
    implements TrustLine {
        @Nullable
        Address account;
        @Nullable
        String balance;
        @Nullable
        String currency;
        @Nullable
        String limit;
        @Nullable
        String limitPeer;
        @Nullable
        UnsignedInteger qualityIn;
        @Nullable
        UnsignedInteger qualityOut;
        boolean noRipple;
        boolean noRippleIsSet;
        boolean noRipplePeer;
        boolean noRipplePeerIsSet;
        boolean authorized;
        boolean authorizedIsSet;
        boolean peerAuthorized;
        boolean peerAuthorizedIsSet;
        boolean freeze;
        boolean freezeIsSet;
        boolean freezePeer;
        boolean freezePeerIsSet;

        Json() {
        }

        @JsonProperty(value="account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="balance")
        public void setBalance(String balance) {
            this.balance = balance;
        }

        @JsonProperty(value="currency")
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @JsonProperty(value="limit")
        public void setLimit(String limit) {
            this.limit = limit;
        }

        @JsonProperty(value="limit_peer")
        public void setLimitPeer(String limitPeer) {
            this.limitPeer = limitPeer;
        }

        @JsonProperty(value="quality_in")
        public void setQualityIn(UnsignedInteger qualityIn) {
            this.qualityIn = qualityIn;
        }

        @JsonProperty(value="quality_out")
        public void setQualityOut(UnsignedInteger qualityOut) {
            this.qualityOut = qualityOut;
        }

        @JsonProperty(value="no_ripple")
        public void setNoRipple(boolean noRipple) {
            this.noRipple = noRipple;
            this.noRippleIsSet = true;
        }

        @JsonProperty(value="no_ripple_peer")
        public void setNoRipplePeer(boolean noRipplePeer) {
            this.noRipplePeer = noRipplePeer;
            this.noRipplePeerIsSet = true;
        }

        @JsonProperty(value="authorized")
        public void setAuthorized(boolean authorized) {
            this.authorized = authorized;
            this.authorizedIsSet = true;
        }

        @JsonProperty(value="peer_authorized")
        public void setPeerAuthorized(boolean peerAuthorized) {
            this.peerAuthorized = peerAuthorized;
            this.peerAuthorizedIsSet = true;
        }

        @JsonProperty(value="freeze")
        public void setFreeze(boolean freeze) {
            this.freeze = freeze;
            this.freezeIsSet = true;
        }

        @JsonProperty(value="freeze_peer")
        public void setFreezePeer(boolean freezePeer) {
            this.freezePeer = freezePeer;
            this.freezePeerIsSet = true;
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String balance() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String currency() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String limit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String limitPeer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger qualityIn() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger qualityOut() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean noRipple() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean noRipplePeer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean authorized() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean peerAuthorized() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean freeze() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean freezePeer() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="TrustLine", generator="Immutables")
    private final class InitShim {
        private byte noRippleBuildStage = 0;
        private boolean noRipple;
        private byte noRipplePeerBuildStage = 0;
        private boolean noRipplePeer;
        private byte authorizedBuildStage = 0;
        private boolean authorized;
        private byte peerAuthorizedBuildStage = 0;
        private boolean peerAuthorized;
        private byte freezeBuildStage = 0;
        private boolean freeze;
        private byte freezePeerBuildStage = 0;
        private boolean freezePeer;

        private InitShim() {
        }

        boolean noRipple() {
            if (this.noRippleBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.noRippleBuildStage == 0) {
                this.noRippleBuildStage = (byte)-1;
                this.noRipple = ImmutableTrustLine.this.noRippleInitialize();
                this.noRippleBuildStage = 1;
            }
            return this.noRipple;
        }

        void noRipple(boolean noRipple) {
            this.noRipple = noRipple;
            this.noRippleBuildStage = 1;
        }

        boolean noRipplePeer() {
            if (this.noRipplePeerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.noRipplePeerBuildStage == 0) {
                this.noRipplePeerBuildStage = (byte)-1;
                this.noRipplePeer = ImmutableTrustLine.this.noRipplePeerInitialize();
                this.noRipplePeerBuildStage = 1;
            }
            return this.noRipplePeer;
        }

        void noRipplePeer(boolean noRipplePeer) {
            this.noRipplePeer = noRipplePeer;
            this.noRipplePeerBuildStage = 1;
        }

        boolean authorized() {
            if (this.authorizedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.authorizedBuildStage == 0) {
                this.authorizedBuildStage = (byte)-1;
                this.authorized = ImmutableTrustLine.this.authorizedInitialize();
                this.authorizedBuildStage = 1;
            }
            return this.authorized;
        }

        void authorized(boolean authorized) {
            this.authorized = authorized;
            this.authorizedBuildStage = 1;
        }

        boolean peerAuthorized() {
            if (this.peerAuthorizedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.peerAuthorizedBuildStage == 0) {
                this.peerAuthorizedBuildStage = (byte)-1;
                this.peerAuthorized = ImmutableTrustLine.this.peerAuthorizedInitialize();
                this.peerAuthorizedBuildStage = 1;
            }
            return this.peerAuthorized;
        }

        void peerAuthorized(boolean peerAuthorized) {
            this.peerAuthorized = peerAuthorized;
            this.peerAuthorizedBuildStage = 1;
        }

        boolean freeze() {
            if (this.freezeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.freezeBuildStage == 0) {
                this.freezeBuildStage = (byte)-1;
                this.freeze = ImmutableTrustLine.this.freezeInitialize();
                this.freezeBuildStage = 1;
            }
            return this.freeze;
        }

        void freeze(boolean freeze) {
            this.freeze = freeze;
            this.freezeBuildStage = 1;
        }

        boolean freezePeer() {
            if (this.freezePeerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.freezePeerBuildStage == 0) {
                this.freezePeerBuildStage = (byte)-1;
                this.freezePeer = ImmutableTrustLine.this.freezePeerInitialize();
                this.freezePeerBuildStage = 1;
            }
            return this.freezePeer;
        }

        void freezePeer(boolean freezePeer) {
            this.freezePeer = freezePeer;
            this.freezePeerBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.noRippleBuildStage == -1) {
                attributes.add("noRipple");
            }
            if (this.noRipplePeerBuildStage == -1) {
                attributes.add("noRipplePeer");
            }
            if (this.authorizedBuildStage == -1) {
                attributes.add("authorized");
            }
            if (this.peerAuthorizedBuildStage == -1) {
                attributes.add("peerAuthorized");
            }
            if (this.freezeBuildStage == -1) {
                attributes.add("freeze");
            }
            if (this.freezePeerBuildStage == -1) {
                attributes.add("freezePeer");
            }
            return "Cannot build TrustLine, attribute initializers form cycle " + attributes;
        }
    }
}

