/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.accounts.QueueData;
import org.xrpl.xrpl4j.model.client.accounts.QueueTransaction;
import org.xrpl.xrpl4j.model.transactions.XrpCurrencyAmount;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="QueueData", generator="Immutables")
@Immutable
public final class ImmutableQueueData
implements QueueData {
    private final UnsignedInteger transactionCount;
    private final boolean authChangeQueued;
    @Nullable
    private final UnsignedInteger lowestSequence;
    @Nullable
    private final UnsignedInteger highestSequence;
    @Nullable
    private final XrpCurrencyAmount maxSpendDropsTotal;
    private final ImmutableList<QueueTransaction> transactions;

    private ImmutableQueueData(Builder builder) {
        this.transactionCount = builder.transactionCount;
        this.lowestSequence = builder.lowestSequence;
        this.highestSequence = builder.highestSequence;
        this.maxSpendDropsTotal = builder.maxSpendDropsTotal;
        this.transactions = builder.transactions.build();
        this.authChangeQueued = builder.authChangeQueuedIsSet() ? builder.authChangeQueued : QueueData.super.authChangeQueued();
    }

    private ImmutableQueueData(UnsignedInteger transactionCount, boolean authChangeQueued, @Nullable UnsignedInteger lowestSequence, @Nullable UnsignedInteger highestSequence, @Nullable XrpCurrencyAmount maxSpendDropsTotal, ImmutableList<QueueTransaction> transactions) {
        this.transactionCount = transactionCount;
        this.authChangeQueued = authChangeQueued;
        this.lowestSequence = lowestSequence;
        this.highestSequence = highestSequence;
        this.maxSpendDropsTotal = maxSpendDropsTotal;
        this.transactions = transactions;
    }

    @Override
    @JsonProperty(value="txn_count")
    public UnsignedInteger transactionCount() {
        return this.transactionCount;
    }

    @Override
    @JsonProperty(value="auth_change_queued")
    public boolean authChangeQueued() {
        return this.authChangeQueued;
    }

    @Override
    @JsonProperty(value="lowest_sequence")
    public Optional<UnsignedInteger> lowestSequence() {
        return Optional.ofNullable(this.lowestSequence);
    }

    @Override
    @JsonProperty(value="highest_sequence")
    public Optional<UnsignedInteger> highestSequence() {
        return Optional.ofNullable(this.highestSequence);
    }

    @Override
    @JsonProperty(value="max_spend_drops_total")
    public Optional<XrpCurrencyAmount> maxSpendDropsTotal() {
        return Optional.ofNullable(this.maxSpendDropsTotal);
    }

    @JsonProperty(value="transactions")
    public ImmutableList<QueueTransaction> transactions() {
        return this.transactions;
    }

    public final ImmutableQueueData withTransactionCount(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "transactionCount");
        if (this.transactionCount.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableQueueData(newValue, this.authChangeQueued, this.lowestSequence, this.highestSequence, this.maxSpendDropsTotal, this.transactions);
    }

    public final ImmutableQueueData withAuthChangeQueued(boolean value) {
        if (this.authChangeQueued == value) {
            return this;
        }
        return new ImmutableQueueData(this.transactionCount, value, this.lowestSequence, this.highestSequence, this.maxSpendDropsTotal, this.transactions);
    }

    public final ImmutableQueueData withLowestSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "lowestSequence");
        if (Objects.equals(this.lowestSequence, newValue)) {
            return this;
        }
        return new ImmutableQueueData(this.transactionCount, this.authChangeQueued, newValue, this.highestSequence, this.maxSpendDropsTotal, this.transactions);
    }

    public final ImmutableQueueData withLowestSequence(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.lowestSequence, value)) {
            return this;
        }
        return new ImmutableQueueData(this.transactionCount, this.authChangeQueued, value, this.highestSequence, this.maxSpendDropsTotal, this.transactions);
    }

    public final ImmutableQueueData withHighestSequence(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "highestSequence");
        if (Objects.equals(this.highestSequence, newValue)) {
            return this;
        }
        return new ImmutableQueueData(this.transactionCount, this.authChangeQueued, this.lowestSequence, newValue, this.maxSpendDropsTotal, this.transactions);
    }

    public final ImmutableQueueData withHighestSequence(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.highestSequence, value)) {
            return this;
        }
        return new ImmutableQueueData(this.transactionCount, this.authChangeQueued, this.lowestSequence, value, this.maxSpendDropsTotal, this.transactions);
    }

    public final ImmutableQueueData withMaxSpendDropsTotal(XrpCurrencyAmount value) {
        XrpCurrencyAmount newValue = Objects.requireNonNull(value, "maxSpendDropsTotal");
        if (this.maxSpendDropsTotal == newValue) {
            return this;
        }
        return new ImmutableQueueData(this.transactionCount, this.authChangeQueued, this.lowestSequence, this.highestSequence, newValue, this.transactions);
    }

    public final ImmutableQueueData withMaxSpendDropsTotal(Optional<? extends XrpCurrencyAmount> optional) {
        XrpCurrencyAmount value = optional.orElse(null);
        if (this.maxSpendDropsTotal == value) {
            return this;
        }
        return new ImmutableQueueData(this.transactionCount, this.authChangeQueued, this.lowestSequence, this.highestSequence, value, this.transactions);
    }

    public final ImmutableQueueData withTransactions(QueueTransaction ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableQueueData(this.transactionCount, this.authChangeQueued, this.lowestSequence, this.highestSequence, this.maxSpendDropsTotal, (ImmutableList<QueueTransaction>)newValue);
    }

    public final ImmutableQueueData withTransactions(Iterable<? extends QueueTransaction> elements) {
        if (this.transactions == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableQueueData(this.transactionCount, this.authChangeQueued, this.lowestSequence, this.highestSequence, this.maxSpendDropsTotal, (ImmutableList<QueueTransaction>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQueueData && this.equalTo((ImmutableQueueData)another);
    }

    private boolean equalTo(ImmutableQueueData another) {
        return this.transactionCount.equals((Object)another.transactionCount) && this.authChangeQueued == another.authChangeQueued && Objects.equals(this.lowestSequence, another.lowestSequence) && Objects.equals(this.highestSequence, another.highestSequence) && Objects.equals(this.maxSpendDropsTotal, another.maxSpendDropsTotal) && this.transactions.equals(another.transactions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transactionCount.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.authChangeQueued);
        h += (h << 5) + Objects.hashCode(this.lowestSequence);
        h += (h << 5) + Objects.hashCode(this.highestSequence);
        h += (h << 5) + Objects.hashCode(this.maxSpendDropsTotal);
        h += (h << 5) + this.transactions.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"QueueData").omitNullValues().add("transactionCount", (Object)this.transactionCount).add("authChangeQueued", this.authChangeQueued).add("lowestSequence", (Object)this.lowestSequence).add("highestSequence", (Object)this.highestSequence).add("maxSpendDropsTotal", (Object)this.maxSpendDropsTotal).add("transactions", this.transactions).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableQueueData fromJson(Json json) {
        Builder builder = ImmutableQueueData.builder();
        if (json.transactionCount != null) {
            builder.transactionCount(json.transactionCount);
        }
        if (json.authChangeQueuedIsSet) {
            builder.authChangeQueued(json.authChangeQueued);
        }
        if (json.lowestSequence != null) {
            builder.lowestSequence(json.lowestSequence);
        }
        if (json.highestSequence != null) {
            builder.highestSequence(json.highestSequence);
        }
        if (json.maxSpendDropsTotal != null) {
            builder.maxSpendDropsTotal(json.maxSpendDropsTotal);
        }
        if (json.transactions != null) {
            builder.addAllTransactions(json.transactions);
        }
        return builder.build();
    }

    public static ImmutableQueueData copyOf(QueueData instance) {
        if (instance instanceof ImmutableQueueData) {
            return (ImmutableQueueData)instance;
        }
        return ImmutableQueueData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="QueueData", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRANSACTION_COUNT = 1L;
        private static final long OPT_BIT_AUTH_CHANGE_QUEUED = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private UnsignedInteger transactionCount;
        private boolean authChangeQueued;
        @Nullable
        private UnsignedInteger lowestSequence;
        @Nullable
        private UnsignedInteger highestSequence;
        @Nullable
        private XrpCurrencyAmount maxSpendDropsTotal;
        private ImmutableList.Builder<QueueTransaction> transactions = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(QueueData instance) {
            Optional<XrpCurrencyAmount> maxSpendDropsTotalOptional;
            Optional<UnsignedInteger> highestSequenceOptional;
            Objects.requireNonNull(instance, "instance");
            this.transactionCount(instance.transactionCount());
            this.authChangeQueued(instance.authChangeQueued());
            Optional<UnsignedInteger> lowestSequenceOptional = instance.lowestSequence();
            if (lowestSequenceOptional.isPresent()) {
                this.lowestSequence(lowestSequenceOptional);
            }
            if ((highestSequenceOptional = instance.highestSequence()).isPresent()) {
                this.highestSequence(highestSequenceOptional);
            }
            if ((maxSpendDropsTotalOptional = instance.maxSpendDropsTotal()).isPresent()) {
                this.maxSpendDropsTotal(maxSpendDropsTotalOptional);
            }
            this.addAllTransactions(instance.transactions());
            return this;
        }

        @JsonProperty(value="txn_count")
        @CanIgnoreReturnValue
        public final Builder transactionCount(UnsignedInteger transactionCount) {
            this.transactionCount = Objects.requireNonNull(transactionCount, "transactionCount");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="auth_change_queued")
        @CanIgnoreReturnValue
        public final Builder authChangeQueued(boolean authChangeQueued) {
            this.authChangeQueued = authChangeQueued;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lowestSequence(UnsignedInteger lowestSequence) {
            this.lowestSequence = Objects.requireNonNull(lowestSequence, "lowestSequence");
            return this;
        }

        @JsonProperty(value="lowest_sequence")
        @CanIgnoreReturnValue
        public final Builder lowestSequence(Optional<? extends UnsignedInteger> lowestSequence) {
            this.lowestSequence = lowestSequence.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder highestSequence(UnsignedInteger highestSequence) {
            this.highestSequence = Objects.requireNonNull(highestSequence, "highestSequence");
            return this;
        }

        @JsonProperty(value="highest_sequence")
        @CanIgnoreReturnValue
        public final Builder highestSequence(Optional<? extends UnsignedInteger> highestSequence) {
            this.highestSequence = highestSequence.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maxSpendDropsTotal(XrpCurrencyAmount maxSpendDropsTotal) {
            this.maxSpendDropsTotal = Objects.requireNonNull(maxSpendDropsTotal, "maxSpendDropsTotal");
            return this;
        }

        @JsonProperty(value="max_spend_drops_total")
        @CanIgnoreReturnValue
        public final Builder maxSpendDropsTotal(Optional<? extends XrpCurrencyAmount> maxSpendDropsTotal) {
            this.maxSpendDropsTotal = maxSpendDropsTotal.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTransactions(QueueTransaction element) {
            this.transactions.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTransactions(QueueTransaction ... elements) {
            this.transactions.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="transactions")
        @CanIgnoreReturnValue
        public final Builder transactions(Iterable<? extends QueueTransaction> elements) {
            this.transactions = ImmutableList.builder();
            return this.addAllTransactions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTransactions(Iterable<? extends QueueTransaction> elements) {
            this.transactions.addAll(elements);
            return this;
        }

        public ImmutableQueueData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableQueueData(this);
        }

        private boolean authChangeQueuedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transactionCount");
            }
            return "Cannot build QueueData, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="QueueData", generator="Immutables")
    static final class Json
    implements QueueData {
        @Nullable
        UnsignedInteger transactionCount;
        boolean authChangeQueued;
        boolean authChangeQueuedIsSet;
        @Nullable
        Optional<UnsignedInteger> lowestSequence = Optional.empty();
        @Nullable
        Optional<UnsignedInteger> highestSequence = Optional.empty();
        @Nullable
        Optional<XrpCurrencyAmount> maxSpendDropsTotal = Optional.empty();
        @Nullable
        List<QueueTransaction> transactions = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="txn_count")
        public void setTransactionCount(UnsignedInteger transactionCount) {
            this.transactionCount = transactionCount;
        }

        @JsonProperty(value="auth_change_queued")
        public void setAuthChangeQueued(boolean authChangeQueued) {
            this.authChangeQueued = authChangeQueued;
            this.authChangeQueuedIsSet = true;
        }

        @JsonProperty(value="lowest_sequence")
        public void setLowestSequence(Optional<UnsignedInteger> lowestSequence) {
            this.lowestSequence = lowestSequence;
        }

        @JsonProperty(value="highest_sequence")
        public void setHighestSequence(Optional<UnsignedInteger> highestSequence) {
            this.highestSequence = highestSequence;
        }

        @JsonProperty(value="max_spend_drops_total")
        public void setMaxSpendDropsTotal(Optional<XrpCurrencyAmount> maxSpendDropsTotal) {
            this.maxSpendDropsTotal = maxSpendDropsTotal;
        }

        @JsonProperty(value="transactions")
        public void setTransactions(List<QueueTransaction> transactions) {
            this.transactions = transactions;
        }

        @Override
        public UnsignedInteger transactionCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean authChangeQueued() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> lowestSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> highestSequence() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<XrpCurrencyAmount> maxSpendDropsTotal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<QueueTransaction> transactions() {
            throw new UnsupportedOperationException();
        }
    }
}

