/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.accounts.AccountObjectsRequestParams;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.common.LedgerSpecifier;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.Marker;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AccountObjectsRequestParams", generator="Immutables")
@Immutable
public final class ImmutableAccountObjectsRequestParams
implements AccountObjectsRequestParams {
    private final Address account;
    @Nullable
    private final AccountObjectsRequestParams.AccountObjectType type;
    private final boolean deletionBlockersOnly;
    @Nullable
    private final Hash256 ledgerHash;
    @Nullable
    private final LedgerIndex ledgerIndex;
    private final LedgerSpecifier ledgerSpecifier;
    @Nullable
    private final UnsignedInteger limit;
    @Nullable
    private final Marker marker;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAccountObjectsRequestParams(Builder builder) {
        this.account = builder.account;
        this.type = builder.type;
        this.ledgerHash = builder.ledgerHash;
        this.ledgerIndex = builder.ledgerIndex;
        this.limit = builder.limit;
        this.marker = builder.marker;
        if (builder.deletionBlockersOnlyIsSet()) {
            this.initShim.deletionBlockersOnly(builder.deletionBlockersOnly);
        }
        if (builder.ledgerSpecifier != null) {
            this.initShim.ledgerSpecifier(builder.ledgerSpecifier);
        }
        this.deletionBlockersOnly = this.initShim.deletionBlockersOnly();
        this.ledgerSpecifier = this.initShim.ledgerSpecifier();
        this.initShim = null;
    }

    private ImmutableAccountObjectsRequestParams(Address account, @Nullable AccountObjectsRequestParams.AccountObjectType type, boolean deletionBlockersOnly, @Nullable Hash256 ledgerHash, @Nullable LedgerIndex ledgerIndex, LedgerSpecifier ledgerSpecifier, @Nullable UnsignedInteger limit, @Nullable Marker marker) {
        this.account = account;
        this.type = type;
        this.deletionBlockersOnly = deletionBlockersOnly;
        this.ledgerHash = ledgerHash;
        this.ledgerIndex = ledgerIndex;
        this.ledgerSpecifier = ledgerSpecifier;
        this.limit = limit;
        this.marker = marker;
        this.initShim = null;
    }

    private boolean deletionBlockersOnlyInitialize() {
        return AccountObjectsRequestParams.super.deletionBlockersOnly();
    }

    private LedgerSpecifier ledgerSpecifierInitialize() {
        return AccountObjectsRequestParams.super.ledgerSpecifier();
    }

    @Override
    @JsonProperty(value="account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="type")
    public Optional<AccountObjectsRequestParams.AccountObjectType> type() {
        return Optional.ofNullable(this.type);
    }

    @Override
    @JsonProperty(value="deletion_blockers_only")
    public boolean deletionBlockersOnly() {
        InitShim shim = this.initShim;
        return shim != null ? shim.deletionBlockersOnly() : this.deletionBlockersOnly;
    }

    @Override
    @JsonProperty(value="ledgerHash")
    @JsonIgnore
    @Deprecated
    public Optional<Hash256> ledgerHash() {
        return Optional.ofNullable(this.ledgerHash);
    }

    @Override
    @JsonProperty(value="ledgerIndex")
    @JsonIgnore
    @Deprecated
    @Nullable
    public LedgerIndex ledgerIndex() {
        return this.ledgerIndex;
    }

    @Override
    @JsonProperty(value="ledgerSpecifier")
    @JsonUnwrapped
    public LedgerSpecifier ledgerSpecifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ledgerSpecifier() : this.ledgerSpecifier;
    }

    @Override
    @JsonProperty(value="limit")
    public Optional<UnsignedInteger> limit() {
        return Optional.ofNullable(this.limit);
    }

    @Override
    @JsonProperty(value="marker")
    public Optional<Marker> marker() {
        return Optional.ofNullable(this.marker);
    }

    public final ImmutableAccountObjectsRequestParams withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableAccountObjectsRequestParams(newValue, this.type, this.deletionBlockersOnly, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.limit, this.marker);
    }

    public final ImmutableAccountObjectsRequestParams withType(AccountObjectsRequestParams.AccountObjectType value) {
        AccountObjectsRequestParams.AccountObjectType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableAccountObjectsRequestParams(this.account, newValue, this.deletionBlockersOnly, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.limit, this.marker);
    }

    public final ImmutableAccountObjectsRequestParams withType(Optional<? extends AccountObjectsRequestParams.AccountObjectType> optional) {
        AccountObjectsRequestParams.AccountObjectType value = optional.orElse(null);
        if (Objects.equals((Object)this.type, (Object)value)) {
            return this;
        }
        return new ImmutableAccountObjectsRequestParams(this.account, value, this.deletionBlockersOnly, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.limit, this.marker);
    }

    public final ImmutableAccountObjectsRequestParams withDeletionBlockersOnly(boolean value) {
        if (this.deletionBlockersOnly == value) {
            return this;
        }
        return new ImmutableAccountObjectsRequestParams(this.account, this.type, value, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.limit, this.marker);
    }

    @Deprecated
    public final ImmutableAccountObjectsRequestParams withLedgerHash(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "ledgerHash");
        if (this.ledgerHash == newValue) {
            return this;
        }
        return new ImmutableAccountObjectsRequestParams(this.account, this.type, this.deletionBlockersOnly, newValue, this.ledgerIndex, this.ledgerSpecifier, this.limit, this.marker);
    }

    @Deprecated
    public final ImmutableAccountObjectsRequestParams withLedgerHash(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.ledgerHash == value) {
            return this;
        }
        return new ImmutableAccountObjectsRequestParams(this.account, this.type, this.deletionBlockersOnly, value, this.ledgerIndex, this.ledgerSpecifier, this.limit, this.marker);
    }

    @Deprecated
    public final ImmutableAccountObjectsRequestParams withLedgerIndex(@Nullable LedgerIndex value) {
        if (this.ledgerIndex == value) {
            return this;
        }
        return new ImmutableAccountObjectsRequestParams(this.account, this.type, this.deletionBlockersOnly, this.ledgerHash, value, this.ledgerSpecifier, this.limit, this.marker);
    }

    public final ImmutableAccountObjectsRequestParams withLedgerSpecifier(LedgerSpecifier value) {
        if (this.ledgerSpecifier == value) {
            return this;
        }
        LedgerSpecifier newValue = Objects.requireNonNull(value, "ledgerSpecifier");
        return new ImmutableAccountObjectsRequestParams(this.account, this.type, this.deletionBlockersOnly, this.ledgerHash, this.ledgerIndex, newValue, this.limit, this.marker);
    }

    public final ImmutableAccountObjectsRequestParams withLimit(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "limit");
        if (Objects.equals(this.limit, newValue)) {
            return this;
        }
        return new ImmutableAccountObjectsRequestParams(this.account, this.type, this.deletionBlockersOnly, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, newValue, this.marker);
    }

    public final ImmutableAccountObjectsRequestParams withLimit(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return new ImmutableAccountObjectsRequestParams(this.account, this.type, this.deletionBlockersOnly, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, value, this.marker);
    }

    public final ImmutableAccountObjectsRequestParams withMarker(Marker value) {
        Marker newValue = Objects.requireNonNull(value, "marker");
        if (this.marker == newValue) {
            return this;
        }
        return new ImmutableAccountObjectsRequestParams(this.account, this.type, this.deletionBlockersOnly, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.limit, newValue);
    }

    public final ImmutableAccountObjectsRequestParams withMarker(Optional<? extends Marker> optional) {
        Marker value = optional.orElse(null);
        if (this.marker == value) {
            return this;
        }
        return new ImmutableAccountObjectsRequestParams(this.account, this.type, this.deletionBlockersOnly, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.limit, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccountObjectsRequestParams && this.equalTo((ImmutableAccountObjectsRequestParams)another);
    }

    private boolean equalTo(ImmutableAccountObjectsRequestParams another) {
        return this.account.equals(another.account) && Objects.equals((Object)this.type, (Object)another.type) && this.deletionBlockersOnly == another.deletionBlockersOnly && this.ledgerSpecifier.equals(another.ledgerSpecifier) && Objects.equals(this.limit, another.limit) && Objects.equals(this.marker, another.marker);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.type);
        h += (h << 5) + Booleans.hashCode((boolean)this.deletionBlockersOnly);
        h += (h << 5) + this.ledgerSpecifier.hashCode();
        h += (h << 5) + Objects.hashCode(this.limit);
        h += (h << 5) + Objects.hashCode(this.marker);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AccountObjectsRequestParams").omitNullValues().add("account", (Object)this.account).add("type", (Object)this.type).add("deletionBlockersOnly", this.deletionBlockersOnly).add("ledgerSpecifier", (Object)this.ledgerSpecifier).add("limit", (Object)this.limit).add("marker", (Object)this.marker).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAccountObjectsRequestParams fromJson(Json json) {
        Builder builder = ImmutableAccountObjectsRequestParams.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.deletionBlockersOnlyIsSet) {
            builder.deletionBlockersOnly(json.deletionBlockersOnly);
        }
        if (json.ledgerHash != null) {
            builder.ledgerHash(json.ledgerHash);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.ledgerSpecifier != null) {
            builder.ledgerSpecifier(json.ledgerSpecifier);
        }
        if (json.limit != null) {
            builder.limit(json.limit);
        }
        if (json.marker != null) {
            builder.marker(json.marker);
        }
        return builder.build();
    }

    public static ImmutableAccountObjectsRequestParams copyOf(AccountObjectsRequestParams instance) {
        if (instance instanceof ImmutableAccountObjectsRequestParams) {
            return (ImmutableAccountObjectsRequestParams)instance;
        }
        return ImmutableAccountObjectsRequestParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AccountObjectsRequestParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long OPT_BIT_DELETION_BLOCKERS_ONLY = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private Address account;
        @Nullable
        private AccountObjectsRequestParams.AccountObjectType type;
        private boolean deletionBlockersOnly;
        @Nullable
        private Hash256 ledgerHash;
        @Nullable
        private LedgerIndex ledgerIndex;
        @Nullable
        private LedgerSpecifier ledgerSpecifier;
        @Nullable
        private UnsignedInteger limit;
        @Nullable
        private Marker marker;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AccountObjectsRequestParams instance) {
            Optional<Marker> markerOptional;
            LedgerIndex ledgerIndexValue;
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            Optional<AccountObjectsRequestParams.AccountObjectType> typeOptional = instance.type();
            if (typeOptional.isPresent()) {
                this.type(typeOptional);
            }
            this.deletionBlockersOnly(instance.deletionBlockersOnly());
            Optional<Hash256> ledgerHashOptional = instance.ledgerHash();
            if (ledgerHashOptional.isPresent()) {
                this.ledgerHash(ledgerHashOptional);
            }
            if ((ledgerIndexValue = instance.ledgerIndex()) != null) {
                this.ledgerIndex(ledgerIndexValue);
            }
            this.ledgerSpecifier(instance.ledgerSpecifier());
            Optional<UnsignedInteger> limitOptional = instance.limit();
            if (limitOptional.isPresent()) {
                this.limit(limitOptional);
            }
            if ((markerOptional = instance.marker()).isPresent()) {
                this.marker(markerOptional);
            }
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(AccountObjectsRequestParams.AccountObjectType type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        @JsonProperty(value="type")
        @CanIgnoreReturnValue
        public final Builder type(Optional<? extends AccountObjectsRequestParams.AccountObjectType> type) {
            this.type = type.orElse(null);
            return this;
        }

        @JsonProperty(value="deletion_blockers_only")
        @CanIgnoreReturnValue
        public final Builder deletionBlockersOnly(boolean deletionBlockersOnly) {
            this.deletionBlockersOnly = deletionBlockersOnly;
            this.optBits |= 1L;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ledgerHash(Hash256 ledgerHash) {
            this.ledgerHash = Objects.requireNonNull(ledgerHash, "ledgerHash");
            return this;
        }

        @JsonProperty(value="ledgerHash")
        @JsonIgnore
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ledgerHash(Optional<? extends Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash.orElse(null);
            return this;
        }

        @JsonProperty(value="ledgerIndex")
        @JsonIgnore
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ledgerIndex(@Nullable LedgerIndex ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
            return this;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder ledgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = Objects.requireNonNull(ledgerSpecifier, "ledgerSpecifier");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder limit(UnsignedInteger limit) {
            this.limit = Objects.requireNonNull(limit, "limit");
            return this;
        }

        @JsonProperty(value="limit")
        @CanIgnoreReturnValue
        public final Builder limit(Optional<? extends UnsignedInteger> limit) {
            this.limit = limit.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder marker(Marker marker) {
            this.marker = Objects.requireNonNull(marker, "marker");
            return this;
        }

        @JsonProperty(value="marker")
        @CanIgnoreReturnValue
        public final Builder marker(Optional<? extends Marker> marker) {
            this.marker = marker.orElse(null);
            return this;
        }

        public ImmutableAccountObjectsRequestParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAccountObjectsRequestParams(this);
        }

        private boolean deletionBlockersOnlyIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            return "Cannot build AccountObjectsRequestParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AccountObjectsRequestParams", generator="Immutables")
    static final class Json
    implements AccountObjectsRequestParams {
        @Nullable
        Address account;
        @Nullable
        Optional<AccountObjectsRequestParams.AccountObjectType> type = Optional.empty();
        boolean deletionBlockersOnly;
        boolean deletionBlockersOnlyIsSet;
        @Nullable
        Optional<Hash256> ledgerHash = Optional.empty();
        @Nullable
        LedgerIndex ledgerIndex;
        @Nullable
        LedgerSpecifier ledgerSpecifier;
        @Nullable
        Optional<UnsignedInteger> limit = Optional.empty();
        @Nullable
        Optional<Marker> marker = Optional.empty();

        Json() {
        }

        @JsonProperty(value="account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="type")
        public void setType(Optional<AccountObjectsRequestParams.AccountObjectType> type) {
            this.type = type;
        }

        @JsonProperty(value="deletion_blockers_only")
        public void setDeletionBlockersOnly(boolean deletionBlockersOnly) {
            this.deletionBlockersOnly = deletionBlockersOnly;
            this.deletionBlockersOnlyIsSet = true;
        }

        @JsonProperty(value="ledgerHash")
        @JsonIgnore
        public void setLedgerHash(Optional<Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash;
        }

        @JsonProperty(value="ledgerIndex")
        @JsonIgnore
        public void setLedgerIndex(@Nullable LedgerIndex ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        public void setLedgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = ledgerSpecifier;
        }

        @JsonProperty(value="limit")
        public void setLimit(Optional<UnsignedInteger> limit) {
            this.limit = limit;
        }

        @JsonProperty(value="marker")
        public void setMarker(Optional<Marker> marker) {
            this.marker = marker;
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<AccountObjectsRequestParams.AccountObjectType> type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean deletionBlockersOnly() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> ledgerHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerIndex ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerSpecifier ledgerSpecifier() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> limit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Marker> marker() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="AccountObjectsRequestParams", generator="Immutables")
    private final class InitShim {
        private byte deletionBlockersOnlyBuildStage = 0;
        private boolean deletionBlockersOnly;
        private byte ledgerSpecifierBuildStage = 0;
        private LedgerSpecifier ledgerSpecifier;

        private InitShim() {
        }

        boolean deletionBlockersOnly() {
            if (this.deletionBlockersOnlyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.deletionBlockersOnlyBuildStage == 0) {
                this.deletionBlockersOnlyBuildStage = (byte)-1;
                this.deletionBlockersOnly = ImmutableAccountObjectsRequestParams.this.deletionBlockersOnlyInitialize();
                this.deletionBlockersOnlyBuildStage = 1;
            }
            return this.deletionBlockersOnly;
        }

        void deletionBlockersOnly(boolean deletionBlockersOnly) {
            this.deletionBlockersOnly = deletionBlockersOnly;
            this.deletionBlockersOnlyBuildStage = 1;
        }

        LedgerSpecifier ledgerSpecifier() {
            if (this.ledgerSpecifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ledgerSpecifierBuildStage == 0) {
                this.ledgerSpecifierBuildStage = (byte)-1;
                this.ledgerSpecifier = Objects.requireNonNull(ImmutableAccountObjectsRequestParams.this.ledgerSpecifierInitialize(), "ledgerSpecifier");
                this.ledgerSpecifierBuildStage = 1;
            }
            return this.ledgerSpecifier;
        }

        void ledgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = ledgerSpecifier;
            this.ledgerSpecifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.deletionBlockersOnlyBuildStage == -1) {
                attributes.add("deletionBlockersOnly");
            }
            if (this.ledgerSpecifierBuildStage == -1) {
                attributes.add("ledgerSpecifier");
            }
            return "Cannot build AccountObjectsRequestParams, attribute initializers form cycle " + attributes;
        }
    }
}

