/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.accounts.AccountChannelsResult;
import org.xrpl.xrpl4j.model.client.accounts.PaymentChannelResultObject;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.Marker;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AccountChannelsResult", generator="Immutables")
@Immutable
public final class ImmutableAccountChannelsResult
implements AccountChannelsResult {
    @Nullable
    private final String status;
    private final Address account;
    private final ImmutableList<PaymentChannelResultObject> channels;
    @Nullable
    private final Hash256 ledgerHash;
    @Nullable
    private final LedgerIndex ledgerIndex;
    @Nullable
    private final LedgerIndex ledgerCurrentIndex;
    private final boolean validated;
    @Nullable
    private final UnsignedInteger limit;
    @Nullable
    private final Marker marker;

    private ImmutableAccountChannelsResult(Builder builder) {
        this.status = builder.status;
        this.account = builder.account;
        this.channels = builder.channels.build();
        this.ledgerHash = builder.ledgerHash;
        this.ledgerIndex = builder.ledgerIndex;
        this.ledgerCurrentIndex = builder.ledgerCurrentIndex;
        this.limit = builder.limit;
        this.marker = builder.marker;
        this.validated = builder.validatedIsSet() ? builder.validated : AccountChannelsResult.super.validated();
    }

    private ImmutableAccountChannelsResult(@Nullable String status, Address account, ImmutableList<PaymentChannelResultObject> channels, @Nullable Hash256 ledgerHash, @Nullable LedgerIndex ledgerIndex, @Nullable LedgerIndex ledgerCurrentIndex, boolean validated, @Nullable UnsignedInteger limit, @Nullable Marker marker) {
        this.status = status;
        this.account = account;
        this.channels = channels;
        this.ledgerHash = ledgerHash;
        this.ledgerIndex = ledgerIndex;
        this.ledgerCurrentIndex = ledgerCurrentIndex;
        this.validated = validated;
        this.limit = limit;
        this.marker = marker;
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="account")
    public Address account() {
        return this.account;
    }

    @JsonProperty(value="channels")
    public ImmutableList<PaymentChannelResultObject> channels() {
        return this.channels;
    }

    @Override
    @JsonProperty(value="ledger_hash")
    @Deprecated
    @Nullable
    public Hash256 ledgerHash() {
        return this.ledgerHash;
    }

    @Override
    @JsonProperty(value="ledger_index")
    @Deprecated
    @Nullable
    public LedgerIndex ledgerIndex() {
        return this.ledgerIndex;
    }

    @Override
    @JsonProperty(value="ledger_current_index")
    public Optional<LedgerIndex> ledgerCurrentIndex() {
        return Optional.ofNullable(this.ledgerCurrentIndex);
    }

    @Override
    @JsonProperty(value="validated")
    public boolean validated() {
        return this.validated;
    }

    @Override
    @JsonProperty(value="limit")
    public Optional<UnsignedInteger> limit() {
        return Optional.ofNullable(this.limit);
    }

    @Override
    @JsonProperty(value="marker")
    public Optional<Marker> marker() {
        return Optional.ofNullable(this.marker);
    }

    public final ImmutableAccountChannelsResult withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableAccountChannelsResult(newValue, this.account, this.channels, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, this.limit, this.marker);
    }

    public final ImmutableAccountChannelsResult withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableAccountChannelsResult(value, this.account, this.channels, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, this.limit, this.marker);
    }

    public final ImmutableAccountChannelsResult withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableAccountChannelsResult(this.status, newValue, this.channels, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, this.limit, this.marker);
    }

    public final ImmutableAccountChannelsResult withChannels(PaymentChannelResultObject ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableAccountChannelsResult(this.status, this.account, (ImmutableList<PaymentChannelResultObject>)newValue, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, this.limit, this.marker);
    }

    public final ImmutableAccountChannelsResult withChannels(Iterable<? extends PaymentChannelResultObject> elements) {
        if (this.channels == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableAccountChannelsResult(this.status, this.account, (ImmutableList<PaymentChannelResultObject>)newValue, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, this.limit, this.marker);
    }

    @Deprecated
    public final ImmutableAccountChannelsResult withLedgerHash(@Nullable Hash256 value) {
        if (this.ledgerHash == value) {
            return this;
        }
        return new ImmutableAccountChannelsResult(this.status, this.account, this.channels, value, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, this.limit, this.marker);
    }

    @Deprecated
    public final ImmutableAccountChannelsResult withLedgerIndex(@Nullable LedgerIndex value) {
        if (this.ledgerIndex == value) {
            return this;
        }
        return new ImmutableAccountChannelsResult(this.status, this.account, this.channels, this.ledgerHash, value, this.ledgerCurrentIndex, this.validated, this.limit, this.marker);
    }

    public final ImmutableAccountChannelsResult withLedgerCurrentIndex(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerCurrentIndex");
        if (this.ledgerCurrentIndex == newValue) {
            return this;
        }
        return new ImmutableAccountChannelsResult(this.status, this.account, this.channels, this.ledgerHash, this.ledgerIndex, newValue, this.validated, this.limit, this.marker);
    }

    public final ImmutableAccountChannelsResult withLedgerCurrentIndex(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.ledgerCurrentIndex == value) {
            return this;
        }
        return new ImmutableAccountChannelsResult(this.status, this.account, this.channels, this.ledgerHash, this.ledgerIndex, value, this.validated, this.limit, this.marker);
    }

    public final ImmutableAccountChannelsResult withValidated(boolean value) {
        if (this.validated == value) {
            return this;
        }
        return new ImmutableAccountChannelsResult(this.status, this.account, this.channels, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, value, this.limit, this.marker);
    }

    public final ImmutableAccountChannelsResult withLimit(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "limit");
        if (Objects.equals(this.limit, newValue)) {
            return this;
        }
        return new ImmutableAccountChannelsResult(this.status, this.account, this.channels, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, newValue, this.marker);
    }

    public final ImmutableAccountChannelsResult withLimit(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return new ImmutableAccountChannelsResult(this.status, this.account, this.channels, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, value, this.marker);
    }

    public final ImmutableAccountChannelsResult withMarker(Marker value) {
        Marker newValue = Objects.requireNonNull(value, "marker");
        if (this.marker == newValue) {
            return this;
        }
        return new ImmutableAccountChannelsResult(this.status, this.account, this.channels, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, this.limit, newValue);
    }

    public final ImmutableAccountChannelsResult withMarker(Optional<? extends Marker> optional) {
        Marker value = optional.orElse(null);
        if (this.marker == value) {
            return this;
        }
        return new ImmutableAccountChannelsResult(this.status, this.account, this.channels, this.ledgerHash, this.ledgerIndex, this.ledgerCurrentIndex, this.validated, this.limit, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccountChannelsResult && this.equalTo((ImmutableAccountChannelsResult)another);
    }

    private boolean equalTo(ImmutableAccountChannelsResult another) {
        return Objects.equals(this.status, another.status) && this.account.equals(another.account) && this.channels.equals(another.channels) && Objects.equals(this.ledgerHash, another.ledgerHash) && Objects.equals(this.ledgerIndex, another.ledgerIndex) && Objects.equals(this.ledgerCurrentIndex, another.ledgerCurrentIndex) && this.validated == another.validated && Objects.equals(this.limit, another.limit) && Objects.equals(this.marker, another.marker);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.channels.hashCode();
        h += (h << 5) + Objects.hashCode(this.ledgerHash);
        h += (h << 5) + Objects.hashCode(this.ledgerIndex);
        h += (h << 5) + Objects.hashCode(this.ledgerCurrentIndex);
        h += (h << 5) + Booleans.hashCode((boolean)this.validated);
        h += (h << 5) + Objects.hashCode(this.limit);
        h += (h << 5) + Objects.hashCode(this.marker);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AccountChannelsResult").omitNullValues().add("status", (Object)this.status).add("account", (Object)this.account).add("channels", this.channels).add("ledgerHash", (Object)this.ledgerHash).add("ledgerIndex", (Object)this.ledgerIndex).add("ledgerCurrentIndex", (Object)this.ledgerCurrentIndex).add("validated", this.validated).add("limit", (Object)this.limit).add("marker", (Object)this.marker).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAccountChannelsResult fromJson(Json json) {
        Builder builder = ImmutableAccountChannelsResult.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.channels != null) {
            builder.addAllChannels(json.channels);
        }
        if (json.ledgerHash != null) {
            builder.ledgerHash(json.ledgerHash);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.ledgerCurrentIndex != null) {
            builder.ledgerCurrentIndex(json.ledgerCurrentIndex);
        }
        if (json.validatedIsSet) {
            builder.validated(json.validated);
        }
        if (json.limit != null) {
            builder.limit(json.limit);
        }
        if (json.marker != null) {
            builder.marker(json.marker);
        }
        return builder.build();
    }

    public static ImmutableAccountChannelsResult copyOf(AccountChannelsResult instance) {
        if (instance instanceof ImmutableAccountChannelsResult) {
            return (ImmutableAccountChannelsResult)instance;
        }
        return ImmutableAccountChannelsResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AccountChannelsResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long OPT_BIT_VALIDATED = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String status;
        @Nullable
        private Address account;
        private ImmutableList.Builder<PaymentChannelResultObject> channels = ImmutableList.builder();
        @Nullable
        private Hash256 ledgerHash;
        @Nullable
        private LedgerIndex ledgerIndex;
        @Nullable
        private LedgerIndex ledgerCurrentIndex;
        private boolean validated;
        @Nullable
        private UnsignedInteger limit;
        @Nullable
        private Marker marker;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AccountChannelsResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<String> statusOptional;
            XrplResult instance;
            if (object instanceof AccountChannelsResult) {
                Optional<UnsignedInteger> limitOptional;
                Optional<Marker> markerOptional;
                instance = (AccountChannelsResult)object;
                Hash256 ledgerHashValue = instance.ledgerHash();
                if (ledgerHashValue != null) {
                    this.ledgerHash(ledgerHashValue);
                }
                this.addAllChannels(instance.channels());
                this.validated(instance.validated());
                LedgerIndex ledgerIndexValue = instance.ledgerIndex();
                if (ledgerIndexValue != null) {
                    this.ledgerIndex(ledgerIndexValue);
                }
                if ((markerOptional = instance.marker()).isPresent()) {
                    this.marker(markerOptional);
                }
                if ((limitOptional = instance.limit()).isPresent()) {
                    this.limit(limitOptional);
                }
                this.account(instance.account());
                Optional<LedgerIndex> ledgerCurrentIndexOptional = instance.ledgerCurrentIndex();
                if (ledgerCurrentIndexOptional.isPresent()) {
                    this.ledgerCurrentIndex(ledgerCurrentIndexOptional);
                }
            }
            if (object instanceof XrplResult && (statusOptional = (instance = (XrplResult)object).status()).isPresent()) {
                this.status(statusOptional);
            }
        }

        @CanIgnoreReturnValue
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addChannels(PaymentChannelResultObject element) {
            this.channels.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addChannels(PaymentChannelResultObject ... elements) {
            this.channels.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="channels")
        @CanIgnoreReturnValue
        public final Builder channels(Iterable<? extends PaymentChannelResultObject> elements) {
            this.channels = ImmutableList.builder();
            return this.addAllChannels(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllChannels(Iterable<? extends PaymentChannelResultObject> elements) {
            this.channels.addAll(elements);
            return this;
        }

        @JsonProperty(value="ledger_hash")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ledgerHash(@Nullable Hash256 ledgerHash) {
            this.ledgerHash = ledgerHash;
            return this;
        }

        @JsonProperty(value="ledger_index")
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ledgerIndex(@Nullable LedgerIndex ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ledgerCurrentIndex(LedgerIndex ledgerCurrentIndex) {
            this.ledgerCurrentIndex = Objects.requireNonNull(ledgerCurrentIndex, "ledgerCurrentIndex");
            return this;
        }

        @JsonProperty(value="ledger_current_index")
        @CanIgnoreReturnValue
        public final Builder ledgerCurrentIndex(Optional<? extends LedgerIndex> ledgerCurrentIndex) {
            this.ledgerCurrentIndex = ledgerCurrentIndex.orElse(null);
            return this;
        }

        @JsonProperty(value="validated")
        @CanIgnoreReturnValue
        public final Builder validated(boolean validated) {
            this.validated = validated;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder limit(UnsignedInteger limit) {
            this.limit = Objects.requireNonNull(limit, "limit");
            return this;
        }

        @JsonProperty(value="limit")
        @CanIgnoreReturnValue
        public final Builder limit(Optional<? extends UnsignedInteger> limit) {
            this.limit = limit.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder marker(Marker marker) {
            this.marker = Objects.requireNonNull(marker, "marker");
            return this;
        }

        @JsonProperty(value="marker")
        @CanIgnoreReturnValue
        public final Builder marker(Optional<? extends Marker> marker) {
            this.marker = marker.orElse(null);
            return this;
        }

        public ImmutableAccountChannelsResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAccountChannelsResult(this);
        }

        private boolean validatedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            return "Cannot build AccountChannelsResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AccountChannelsResult", generator="Immutables")
    static final class Json
    implements AccountChannelsResult {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        Address account;
        @Nullable
        List<PaymentChannelResultObject> channels = ImmutableList.of();
        @Nullable
        Hash256 ledgerHash;
        @Nullable
        LedgerIndex ledgerIndex;
        @Nullable
        Optional<LedgerIndex> ledgerCurrentIndex = Optional.empty();
        boolean validated;
        boolean validatedIsSet;
        @Nullable
        Optional<UnsignedInteger> limit = Optional.empty();
        @Nullable
        Optional<Marker> marker = Optional.empty();

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="channels")
        public void setChannels(List<PaymentChannelResultObject> channels) {
            this.channels = channels;
        }

        @JsonProperty(value="ledger_hash")
        public void setLedgerHash(@Nullable Hash256 ledgerHash) {
            this.ledgerHash = ledgerHash;
        }

        @JsonProperty(value="ledger_index")
        public void setLedgerIndex(@Nullable LedgerIndex ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="ledger_current_index")
        public void setLedgerCurrentIndex(Optional<LedgerIndex> ledgerCurrentIndex) {
            this.ledgerCurrentIndex = ledgerCurrentIndex;
        }

        @JsonProperty(value="validated")
        public void setValidated(boolean validated) {
            this.validated = validated;
            this.validatedIsSet = true;
        }

        @JsonProperty(value="limit")
        public void setLimit(Optional<UnsignedInteger> limit) {
            this.limit = limit;
        }

        @JsonProperty(value="marker")
        public void setMarker(Optional<Marker> marker) {
            this.marker = marker;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<PaymentChannelResultObject> channels() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 ledgerHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerIndex ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> ledgerCurrentIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean validated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> limit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Marker> marker() {
            throw new UnsupportedOperationException();
        }
    }
}

