/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.accounts.AccountChannelsRequestParams;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.common.LedgerSpecifier;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.Marker;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AccountChannelsRequestParams", generator="Immutables")
@Immutable
public final class ImmutableAccountChannelsRequestParams
implements AccountChannelsRequestParams {
    private final Address account;
    @Nullable
    private final Address destinationAccount;
    @Nullable
    private final Hash256 ledgerHash;
    @Nullable
    private final LedgerIndex ledgerIndex;
    private final LedgerSpecifier ledgerSpecifier;
    @Nullable
    private final UnsignedInteger limit;
    @Nullable
    private final Marker marker;

    private ImmutableAccountChannelsRequestParams(Builder builder) {
        this.account = builder.account;
        this.destinationAccount = builder.destinationAccount;
        this.ledgerHash = builder.ledgerHash;
        this.ledgerIndex = builder.ledgerIndex;
        this.limit = builder.limit;
        this.marker = builder.marker;
        this.ledgerSpecifier = builder.ledgerSpecifier != null ? builder.ledgerSpecifier : Objects.requireNonNull(AccountChannelsRequestParams.super.ledgerSpecifier(), "ledgerSpecifier");
    }

    private ImmutableAccountChannelsRequestParams(Address account, @Nullable Address destinationAccount, @Nullable Hash256 ledgerHash, @Nullable LedgerIndex ledgerIndex, LedgerSpecifier ledgerSpecifier, @Nullable UnsignedInteger limit, @Nullable Marker marker) {
        this.account = account;
        this.destinationAccount = destinationAccount;
        this.ledgerHash = ledgerHash;
        this.ledgerIndex = ledgerIndex;
        this.ledgerSpecifier = ledgerSpecifier;
        this.limit = limit;
        this.marker = marker;
    }

    @Override
    @JsonProperty(value="account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="destination_account")
    public Optional<Address> destinationAccount() {
        return Optional.ofNullable(this.destinationAccount);
    }

    @Override
    @JsonProperty(value="ledgerHash")
    @JsonIgnore
    @Deprecated
    public Optional<Hash256> ledgerHash() {
        return Optional.ofNullable(this.ledgerHash);
    }

    @Override
    @JsonProperty(value="ledgerIndex")
    @JsonIgnore
    @Deprecated
    @Nullable
    public LedgerIndex ledgerIndex() {
        return this.ledgerIndex;
    }

    @Override
    @JsonProperty(value="ledgerSpecifier")
    @JsonUnwrapped
    public LedgerSpecifier ledgerSpecifier() {
        return this.ledgerSpecifier;
    }

    @Override
    @JsonProperty(value="limit")
    public Optional<UnsignedInteger> limit() {
        return Optional.ofNullable(this.limit);
    }

    @Override
    @JsonProperty(value="marker")
    public Optional<Marker> marker() {
        return Optional.ofNullable(this.marker);
    }

    public final ImmutableAccountChannelsRequestParams withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableAccountChannelsRequestParams(newValue, this.destinationAccount, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.limit, this.marker);
    }

    public final ImmutableAccountChannelsRequestParams withDestinationAccount(Address value) {
        Address newValue = Objects.requireNonNull(value, "destinationAccount");
        if (this.destinationAccount == newValue) {
            return this;
        }
        return new ImmutableAccountChannelsRequestParams(this.account, newValue, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.limit, this.marker);
    }

    public final ImmutableAccountChannelsRequestParams withDestinationAccount(Optional<? extends Address> optional) {
        Address value = optional.orElse(null);
        if (this.destinationAccount == value) {
            return this;
        }
        return new ImmutableAccountChannelsRequestParams(this.account, value, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.limit, this.marker);
    }

    @Deprecated
    public final ImmutableAccountChannelsRequestParams withLedgerHash(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "ledgerHash");
        if (this.ledgerHash == newValue) {
            return this;
        }
        return new ImmutableAccountChannelsRequestParams(this.account, this.destinationAccount, newValue, this.ledgerIndex, this.ledgerSpecifier, this.limit, this.marker);
    }

    @Deprecated
    public final ImmutableAccountChannelsRequestParams withLedgerHash(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.ledgerHash == value) {
            return this;
        }
        return new ImmutableAccountChannelsRequestParams(this.account, this.destinationAccount, value, this.ledgerIndex, this.ledgerSpecifier, this.limit, this.marker);
    }

    @Deprecated
    public final ImmutableAccountChannelsRequestParams withLedgerIndex(@Nullable LedgerIndex value) {
        if (this.ledgerIndex == value) {
            return this;
        }
        return new ImmutableAccountChannelsRequestParams(this.account, this.destinationAccount, this.ledgerHash, value, this.ledgerSpecifier, this.limit, this.marker);
    }

    public final ImmutableAccountChannelsRequestParams withLedgerSpecifier(LedgerSpecifier value) {
        if (this.ledgerSpecifier == value) {
            return this;
        }
        LedgerSpecifier newValue = Objects.requireNonNull(value, "ledgerSpecifier");
        return new ImmutableAccountChannelsRequestParams(this.account, this.destinationAccount, this.ledgerHash, this.ledgerIndex, newValue, this.limit, this.marker);
    }

    public final ImmutableAccountChannelsRequestParams withLimit(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "limit");
        if (Objects.equals(this.limit, newValue)) {
            return this;
        }
        return new ImmutableAccountChannelsRequestParams(this.account, this.destinationAccount, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, newValue, this.marker);
    }

    public final ImmutableAccountChannelsRequestParams withLimit(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return new ImmutableAccountChannelsRequestParams(this.account, this.destinationAccount, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, value, this.marker);
    }

    public final ImmutableAccountChannelsRequestParams withMarker(Marker value) {
        Marker newValue = Objects.requireNonNull(value, "marker");
        if (this.marker == newValue) {
            return this;
        }
        return new ImmutableAccountChannelsRequestParams(this.account, this.destinationAccount, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.limit, newValue);
    }

    public final ImmutableAccountChannelsRequestParams withMarker(Optional<? extends Marker> optional) {
        Marker value = optional.orElse(null);
        if (this.marker == value) {
            return this;
        }
        return new ImmutableAccountChannelsRequestParams(this.account, this.destinationAccount, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.limit, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccountChannelsRequestParams && this.equalTo((ImmutableAccountChannelsRequestParams)another);
    }

    private boolean equalTo(ImmutableAccountChannelsRequestParams another) {
        return this.account.equals(another.account) && Objects.equals(this.destinationAccount, another.destinationAccount) && this.ledgerSpecifier.equals(another.ledgerSpecifier) && Objects.equals(this.limit, another.limit) && Objects.equals(this.marker, another.marker);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + Objects.hashCode(this.destinationAccount);
        h += (h << 5) + this.ledgerSpecifier.hashCode();
        h += (h << 5) + Objects.hashCode(this.limit);
        h += (h << 5) + Objects.hashCode(this.marker);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AccountChannelsRequestParams").omitNullValues().add("account", (Object)this.account).add("destinationAccount", (Object)this.destinationAccount).add("ledgerSpecifier", (Object)this.ledgerSpecifier).add("limit", (Object)this.limit).add("marker", (Object)this.marker).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAccountChannelsRequestParams fromJson(Json json) {
        Builder builder = ImmutableAccountChannelsRequestParams.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.destinationAccount != null) {
            builder.destinationAccount(json.destinationAccount);
        }
        if (json.ledgerHash != null) {
            builder.ledgerHash(json.ledgerHash);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.ledgerSpecifier != null) {
            builder.ledgerSpecifier(json.ledgerSpecifier);
        }
        if (json.limit != null) {
            builder.limit(json.limit);
        }
        if (json.marker != null) {
            builder.marker(json.marker);
        }
        return builder.build();
    }

    public static ImmutableAccountChannelsRequestParams copyOf(AccountChannelsRequestParams instance) {
        if (instance instanceof ImmutableAccountChannelsRequestParams) {
            return (ImmutableAccountChannelsRequestParams)instance;
        }
        return ImmutableAccountChannelsRequestParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AccountChannelsRequestParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private long initBits = 1L;
        @Nullable
        private Address account;
        @Nullable
        private Address destinationAccount;
        @Nullable
        private Hash256 ledgerHash;
        @Nullable
        private LedgerIndex ledgerIndex;
        @Nullable
        private LedgerSpecifier ledgerSpecifier;
        @Nullable
        private UnsignedInteger limit;
        @Nullable
        private Marker marker;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AccountChannelsRequestParams instance) {
            Optional<Marker> markerOptional;
            LedgerIndex ledgerIndexValue;
            Optional<Hash256> ledgerHashOptional;
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            Optional<Address> destinationAccountOptional = instance.destinationAccount();
            if (destinationAccountOptional.isPresent()) {
                this.destinationAccount(destinationAccountOptional);
            }
            if ((ledgerHashOptional = instance.ledgerHash()).isPresent()) {
                this.ledgerHash(ledgerHashOptional);
            }
            if ((ledgerIndexValue = instance.ledgerIndex()) != null) {
                this.ledgerIndex(ledgerIndexValue);
            }
            this.ledgerSpecifier(instance.ledgerSpecifier());
            Optional<UnsignedInteger> limitOptional = instance.limit();
            if (limitOptional.isPresent()) {
                this.limit(limitOptional);
            }
            if ((markerOptional = instance.marker()).isPresent()) {
                this.marker(markerOptional);
            }
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder destinationAccount(Address destinationAccount) {
            this.destinationAccount = Objects.requireNonNull(destinationAccount, "destinationAccount");
            return this;
        }

        @JsonProperty(value="destination_account")
        @CanIgnoreReturnValue
        public final Builder destinationAccount(Optional<? extends Address> destinationAccount) {
            this.destinationAccount = destinationAccount.orElse(null);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ledgerHash(Hash256 ledgerHash) {
            this.ledgerHash = Objects.requireNonNull(ledgerHash, "ledgerHash");
            return this;
        }

        @JsonProperty(value="ledgerHash")
        @JsonIgnore
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ledgerHash(Optional<? extends Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash.orElse(null);
            return this;
        }

        @JsonProperty(value="ledgerIndex")
        @JsonIgnore
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ledgerIndex(@Nullable LedgerIndex ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
            return this;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder ledgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = Objects.requireNonNull(ledgerSpecifier, "ledgerSpecifier");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder limit(UnsignedInteger limit) {
            this.limit = Objects.requireNonNull(limit, "limit");
            return this;
        }

        @JsonProperty(value="limit")
        @CanIgnoreReturnValue
        public final Builder limit(Optional<? extends UnsignedInteger> limit) {
            this.limit = limit.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder marker(Marker marker) {
            this.marker = Objects.requireNonNull(marker, "marker");
            return this;
        }

        @JsonProperty(value="marker")
        @CanIgnoreReturnValue
        public final Builder marker(Optional<? extends Marker> marker) {
            this.marker = marker.orElse(null);
            return this;
        }

        public ImmutableAccountChannelsRequestParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAccountChannelsRequestParams(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            return "Cannot build AccountChannelsRequestParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AccountChannelsRequestParams", generator="Immutables")
    static final class Json
    implements AccountChannelsRequestParams {
        @Nullable
        Address account;
        @Nullable
        Optional<Address> destinationAccount = Optional.empty();
        @Nullable
        Optional<Hash256> ledgerHash = Optional.empty();
        @Nullable
        LedgerIndex ledgerIndex;
        @Nullable
        LedgerSpecifier ledgerSpecifier;
        @Nullable
        Optional<UnsignedInteger> limit = Optional.empty();
        @Nullable
        Optional<Marker> marker = Optional.empty();

        Json() {
        }

        @JsonProperty(value="account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="destination_account")
        public void setDestinationAccount(Optional<Address> destinationAccount) {
            this.destinationAccount = destinationAccount;
        }

        @JsonProperty(value="ledgerHash")
        @JsonIgnore
        public void setLedgerHash(Optional<Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash;
        }

        @JsonProperty(value="ledgerIndex")
        @JsonIgnore
        public void setLedgerIndex(@Nullable LedgerIndex ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        public void setLedgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = ledgerSpecifier;
        }

        @JsonProperty(value="limit")
        public void setLimit(Optional<UnsignedInteger> limit) {
            this.limit = limit;
        }

        @JsonProperty(value="marker")
        public void setMarker(Optional<Marker> marker) {
            this.marker = marker;
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Address> destinationAccount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> ledgerHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerIndex ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerSpecifier ledgerSpecifier() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> limit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Marker> marker() {
            throw new UnsupportedOperationException();
        }
    }
}

