/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedInteger;
import java.util.Optional;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.LegacyLedgerSpecifierUtils;
import org.xrpl.xrpl4j.model.client.XrplRequestParams;
import org.xrpl.xrpl4j.model.client.accounts.ImmutableAccountTransactionsRequestParams;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.common.LedgerIndexBound;
import org.xrpl.xrpl4j.model.client.common.LedgerIndexShortcut;
import org.xrpl.xrpl4j.model.client.common.LedgerSpecifier;
import org.xrpl.xrpl4j.model.jackson.modules.AccountTransactionsRequestParamsDeserializer;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.Marker;

@JsonSerialize(as=ImmutableAccountTransactionsRequestParams.class)
@JsonDeserialize(as=ImmutableAccountTransactionsRequestParams.class, using=AccountTransactionsRequestParamsDeserializer.class)
@Value.Immutable
public interface AccountTransactionsRequestParams
extends XrplRequestParams {
    public static ImmutableAccountTransactionsRequestParams.Builder builder() {
        return ImmutableAccountTransactionsRequestParams.builder();
    }

    public Address account();

    @JsonIgnore
    @Deprecated
    @Value.Auxiliary
    public Optional<LedgerIndex> ledgerIndexMin();

    @JsonIgnore
    @Deprecated
    @Value.Auxiliary
    public Optional<LedgerIndex> ledgerIndexMax();

    @JsonProperty(value="ledger_index_min")
    @Nullable
    @Value.Default
    default public LedgerIndexBound ledgerIndexMinimum() {
        return this.ledgerIndexMin().map(LedgerIndex::unsignedIntegerValue).map(UnsignedInteger::intValue).map(x$0 -> LedgerIndexBound.of(x$0)).orElse(LedgerIndexBound.of(-1));
    }

    @JsonProperty(value="ledger_index_max")
    @Nullable
    @Value.Default
    default public LedgerIndexBound ledgerIndexMaximum() {
        return this.ledgerIndexMax().map(LedgerIndex::unsignedIntegerValue).map(UnsignedInteger::intValue).map(x$0 -> LedgerIndexBound.of(x$0)).orElse(LedgerIndexBound.of(-1));
    }

    @JsonIgnore
    @Deprecated
    @Value.Auxiliary
    public Optional<Hash256> ledgerHash();

    @JsonIgnore
    @Deprecated
    @Value.Auxiliary
    public Optional<LedgerIndex> ledgerIndex();

    @JsonUnwrapped
    @Value.Default
    default public Optional<LedgerSpecifier> ledgerSpecifier() {
        return this.ledgerHash().map(LedgerSpecifier::of).map(Optional::of).orElseGet(() -> this.ledgerIndex().map(LegacyLedgerSpecifierUtils::computeLedgerSpecifierFromLedgerIndex));
    }

    @Value.Derived
    default public boolean binary() {
        return false;
    }

    @Value.Default
    default public boolean forward() {
        return false;
    }

    public Optional<UnsignedInteger> limit();

    public Optional<Marker> marker();

    @Value.Check
    default public void validateSpecifierNotCurrentOrClosed() {
        this.ledgerSpecifier().ifPresent(ledgerSpecifier -> ledgerSpecifier.handle(ledgerHash -> {}, ledgerIndex -> {}, ledgerIndexShortcut -> Preconditions.checkArgument((boolean)ledgerIndexShortcut.equals(LedgerIndexShortcut.VALIDATED), (Object)"Invalid LedgerIndexShortcut. The account_tx API method only accepts 'validated' when specifying a shortcut.")));
    }

    @Value.Check
    default public AccountTransactionsRequestParams emptyBoundedParametersIfSpecifierPresent() {
        if (this.ledgerSpecifier().isPresent() && (this.ledgerIndexMinimum() != null || this.ledgerIndexMaximum() != null)) {
            return AccountTransactionsRequestParams.builder().from(this).ledgerIndexMinimum(null).ledgerIndexMaximum(null).build();
        }
        return this;
    }
}

