/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.primitives.UnsignedInteger;
import java.util.Optional;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.LegacyLedgerSpecifierUtils;
import org.xrpl.xrpl4j.model.client.XrplRequestParams;
import org.xrpl.xrpl4j.model.client.accounts.ImmutableAccountOffersRequestParams;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.common.LedgerSpecifier;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.Marker;

@JsonSerialize(as=ImmutableAccountOffersRequestParams.class)
@JsonDeserialize(as=ImmutableAccountOffersRequestParams.class)
@Value.Immutable
public interface AccountOffersRequestParams
extends XrplRequestParams {
    public static ImmutableAccountOffersRequestParams.Builder builder() {
        return ImmutableAccountOffersRequestParams.builder();
    }

    public Address account();

    @JsonIgnore
    @Deprecated
    @Value.Auxiliary
    public Optional<Hash256> ledgerHash();

    @JsonIgnore
    @Deprecated
    @Nullable
    @Value.Auxiliary
    public LedgerIndex ledgerIndex();

    @JsonUnwrapped
    @Value.Default
    default public LedgerSpecifier ledgerSpecifier() {
        return LegacyLedgerSpecifierUtils.computeLedgerSpecifier(this.ledgerHash(), this.ledgerIndex());
    }

    @Value.Derived
    default public boolean strict() {
        return true;
    }

    public Optional<UnsignedInteger> limit();

    public Optional<Marker> marker();
}

