/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Optional;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.LegacyLedgerSpecifierUtils;
import org.xrpl.xrpl4j.model.client.XrplRequestParams;
import org.xrpl.xrpl4j.model.client.accounts.ImmutableAccountInfoRequestParams;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.common.LedgerSpecifier;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@JsonSerialize(as=ImmutableAccountInfoRequestParams.class)
@JsonDeserialize(as=ImmutableAccountInfoRequestParams.class)
@Value.Immutable
public interface AccountInfoRequestParams
extends XrplRequestParams {
    public static ImmutableAccountInfoRequestParams.Builder builder() {
        return ImmutableAccountInfoRequestParams.builder();
    }

    public static AccountInfoRequestParams of(Address account) {
        return AccountInfoRequestParams.builder().account(account).build();
    }

    public Address account();

    @JsonIgnore
    @Deprecated
    @Value.Auxiliary
    public Optional<Hash256> ledgerHash();

    @JsonIgnore
    @Deprecated
    @Nullable
    @Value.Auxiliary
    public LedgerIndex ledgerIndex();

    @JsonUnwrapped
    @Value.Default
    default public LedgerSpecifier ledgerSpecifier() {
        return LegacyLedgerSpecifierUtils.computeLedgerSpecifier(this.ledgerHash(), this.ledgerIndex());
    }

    @Value.Derived
    default public boolean strict() {
        return true;
    }

    @Value.Default
    default public boolean queue() {
        return false;
    }

    @JsonProperty(value="signer_lists")
    @Value.Default
    default public boolean signerLists() {
        return true;
    }
}

