/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.wallet;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.XAddress;
import org.xrpl.xrpl4j.wallet.Wallet;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Wallet", generator="Immutables")
@Immutable
public final class ImmutableWallet
implements Wallet {
    @Nullable
    private final String privateKey;
    private final String publicKey;
    private final Address classicAddress;
    private final XAddress xAddress;
    private final boolean isTest;

    private ImmutableWallet(@Nullable String privateKey, String publicKey, Address classicAddress, XAddress xAddress, boolean isTest) {
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.classicAddress = classicAddress;
        this.xAddress = xAddress;
        this.isTest = isTest;
    }

    @Override
    @Deprecated
    public Optional<String> privateKey() {
        return Optional.ofNullable(this.privateKey);
    }

    @Override
    public String publicKey() {
        return this.publicKey;
    }

    @Override
    public Address classicAddress() {
        return this.classicAddress;
    }

    @Override
    public XAddress xAddress() {
        return this.xAddress;
    }

    @Override
    public boolean isTest() {
        return this.isTest;
    }

    @Deprecated
    public final ImmutableWallet withPrivateKey(String value) {
        String newValue = Objects.requireNonNull(value, "privateKey");
        if (Objects.equals(this.privateKey, newValue)) {
            return this;
        }
        return new ImmutableWallet(newValue, this.publicKey, this.classicAddress, this.xAddress, this.isTest);
    }

    @Deprecated
    public final ImmutableWallet withPrivateKey(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.privateKey, value)) {
            return this;
        }
        return new ImmutableWallet(value, this.publicKey, this.classicAddress, this.xAddress, this.isTest);
    }

    public final ImmutableWallet withPublicKey(String value) {
        String newValue = Objects.requireNonNull(value, "publicKey");
        if (this.publicKey.equals(newValue)) {
            return this;
        }
        return new ImmutableWallet(this.privateKey, newValue, this.classicAddress, this.xAddress, this.isTest);
    }

    public final ImmutableWallet withClassicAddress(Address value) {
        if (this.classicAddress == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "classicAddress");
        return new ImmutableWallet(this.privateKey, this.publicKey, newValue, this.xAddress, this.isTest);
    }

    public final ImmutableWallet withXAddress(XAddress value) {
        if (this.xAddress == value) {
            return this;
        }
        XAddress newValue = Objects.requireNonNull(value, "xAddress");
        return new ImmutableWallet(this.privateKey, this.publicKey, this.classicAddress, newValue, this.isTest);
    }

    public final ImmutableWallet withIsTest(boolean value) {
        if (this.isTest == value) {
            return this;
        }
        return new ImmutableWallet(this.privateKey, this.publicKey, this.classicAddress, this.xAddress, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWallet && this.equalTo((ImmutableWallet)another);
    }

    private boolean equalTo(ImmutableWallet another) {
        return Objects.equals(this.privateKey, another.privateKey) && this.publicKey.equals(another.publicKey) && this.classicAddress.equals((Object)another.classicAddress) && this.xAddress.equals((Object)another.xAddress) && this.isTest == another.isTest;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.privateKey);
        h += (h << 5) + this.publicKey.hashCode();
        h += (h << 5) + this.classicAddress.hashCode();
        h += (h << 5) + this.xAddress.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.isTest);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Wallet").omitNullValues().add("privateKey", (Object)this.privateKey).add("publicKey", (Object)this.publicKey).add("classicAddress", (Object)this.classicAddress).add("xAddress", (Object)this.xAddress).add("isTest", this.isTest).toString();
    }

    public static ImmutableWallet copyOf(Wallet instance) {
        if (instance instanceof ImmutableWallet) {
            return (ImmutableWallet)instance;
        }
        return ImmutableWallet.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Wallet", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PUBLIC_KEY = 1L;
        private static final long INIT_BIT_CLASSIC_ADDRESS = 2L;
        private static final long INIT_BIT_X_ADDRESS = 4L;
        private static final long INIT_BIT_IS_TEST = 8L;
        private long initBits = 15L;
        @Nullable
        private String privateKey;
        @Nullable
        private String publicKey;
        @Nullable
        private Address classicAddress;
        @Nullable
        private XAddress xAddress;
        private boolean isTest;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Wallet instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<String> privateKeyOptional = instance.privateKey();
            if (privateKeyOptional.isPresent()) {
                this.privateKey(privateKeyOptional);
            }
            this.publicKey(instance.publicKey());
            this.classicAddress(instance.classicAddress());
            this.xAddress(instance.xAddress());
            this.isTest(instance.isTest());
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder privateKey(String privateKey) {
            this.privateKey = Objects.requireNonNull(privateKey, "privateKey");
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder privateKey(Optional<String> privateKey) {
            this.privateKey = privateKey.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder publicKey(String publicKey) {
            this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder classicAddress(Address classicAddress) {
            this.classicAddress = Objects.requireNonNull(classicAddress, "classicAddress");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder xAddress(XAddress xAddress) {
            this.xAddress = Objects.requireNonNull(xAddress, "xAddress");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isTest(boolean isTest) {
            this.isTest = isTest;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableWallet build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWallet(this.privateKey, this.publicKey, this.classicAddress, this.xAddress, this.isTest);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("publicKey");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("classicAddress");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("xAddress");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("isTest");
            }
            return "Cannot build Wallet, some of required attributes are not set " + attributes;
        }
    }
}

