/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.wallet;

import org.xrpl.xrpl4j.codec.addresses.AddressCodec;
import org.xrpl.xrpl4j.keypairs.DefaultKeyPairService;
import org.xrpl.xrpl4j.keypairs.KeyPair;
import org.xrpl.xrpl4j.keypairs.KeyPairService;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.wallet.SeedWalletGenerationResult;
import org.xrpl.xrpl4j.wallet.Wallet;
import org.xrpl.xrpl4j.wallet.WalletFactory;

public class DefaultWalletFactory
implements WalletFactory {
    private static final WalletFactory INSTANCE = new DefaultWalletFactory(DefaultKeyPairService.getInstance(), AddressCodec.getInstance());
    private final KeyPairService keyPairService;
    private final AddressCodec addressCodec;

    public DefaultWalletFactory(KeyPairService keyPairService, AddressCodec addressCodec) {
        this.keyPairService = keyPairService;
        this.addressCodec = addressCodec;
    }

    public static WalletFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public SeedWalletGenerationResult randomWallet(boolean isTest) {
        String seed = this.keyPairService.generateSeed();
        Wallet wallet = this.fromSeed(seed, isTest);
        return SeedWalletGenerationResult.builder().seed(seed).wallet(wallet).build();
    }

    @Override
    public Wallet fromSeed(String seed, boolean isTest) {
        KeyPair keyPair = this.keyPairService.deriveKeyPair(seed);
        return this.fromKeyPair(keyPair, isTest);
    }

    @Override
    public Wallet fromKeyPair(KeyPair keyPair, boolean isTest) {
        Address classicAddress = this.keyPairService.deriveAddress(keyPair.publicKey());
        return Wallet.builder().privateKey(keyPair.privateKey()).publicKey(keyPair.publicKey()).isTest(isTest).classicAddress(classicAddress).xAddress(this.addressCodec.classicAddressToXAddress(classicAddress, isTest)).build();
    }
}

