/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.keypairs;

import com.google.common.io.BaseEncoding;
import java.math.BigInteger;
import java.util.Optional;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.math.ec.ECPoint;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.codec.addresses.VersionType;
import org.xrpl.xrpl4j.keypairs.AbstractKeyPairService;
import org.xrpl.xrpl4j.keypairs.EcDsaSignature;
import org.xrpl.xrpl4j.keypairs.HashUtils;
import org.xrpl.xrpl4j.keypairs.KeyPair;
import org.xrpl.xrpl4j.keypairs.Secp256k1;

public class Secp256k1KeyPairService
extends AbstractKeyPairService {
    private static final Secp256k1KeyPairService INSTANCE = new Secp256k1KeyPairService();

    public static Secp256k1KeyPairService getInstance() {
        return INSTANCE;
    }

    @Override
    public String generateSeed(UnsignedByteArray entropy) {
        return this.addressCodec.encodeSeed(entropy, VersionType.SECP256K1);
    }

    @Override
    public KeyPair deriveKeyPair(String seed) {
        return this.deriveKeyPair(this.addressCodec.decodeSeed(seed).bytes(), 0);
    }

    private KeyPair deriveKeyPair(UnsignedByteArray seed) {
        int accountNumber = 0;
        return this.deriveKeyPair(seed, accountNumber);
    }

    private KeyPair deriveKeyPair(UnsignedByteArray seed, int accountNumber) {
        BigInteger privateKey = this.derivePrivateKey(seed, accountNumber);
        UnsignedByteArray publicKey = this.derivePublicKey(privateKey);
        return KeyPair.builder().privateKey(UnsignedByteArray.of((byte[])privateKey.toByteArray()).hexValue()).publicKey(UnsignedByteArray.of((byte[])publicKey.toByteArray()).hexValue()).build();
    }

    private UnsignedByteArray derivePublicKey(BigInteger privateKey) {
        return UnsignedByteArray.of((byte[])Secp256k1.ecDomainParameters.getG().multiply(privateKey).getEncoded(true));
    }

    private BigInteger derivePrivateKey(UnsignedByteArray seed, int accountNumber) {
        BigInteger privateGen = this.deriveScalar(seed);
        if (accountNumber == -1) {
            return privateGen;
        }
        UnsignedByteArray publicGen = UnsignedByteArray.of((byte[])Secp256k1.ecDomainParameters.getG().multiply(privateGen).getEncoded(true));
        return this.deriveScalar(publicGen, accountNumber).add(privateGen).mod(Secp256k1.ecDomainParameters.getN());
    }

    private BigInteger deriveScalar(UnsignedByteArray seed) {
        return this.deriveScalar(seed, Optional.empty());
    }

    private BigInteger deriveScalar(UnsignedByteArray seed, Integer discriminator) {
        return this.deriveScalar(seed, Optional.of(discriminator));
    }

    private BigInteger deriveScalar(UnsignedByteArray seed, Optional<Integer> discriminator) {
        BigInteger key = null;
        UnsignedByteArray seedCopy = UnsignedByteArray.of((byte[])seed.toByteArray());
        for (long i = 0L; i <= 0xFFFFFFFFL; ++i) {
            discriminator.map(d -> HashUtils.addUInt32(seedCopy, d));
            HashUtils.addUInt32(seedCopy, (int)i);
            UnsignedByteArray hash = HashUtils.sha512Half(seedCopy);
            key = new BigInteger(1, hash.toByteArray());
            if (key.compareTo(BigInteger.ZERO) > 0 && key.compareTo(Secp256k1.ecDomainParameters.getN()) < 0) break;
        }
        return key;
    }

    @Override
    public String sign(UnsignedByteArray message, String privateKey) {
        UnsignedByteArray messageHash = HashUtils.sha512Half(message);
        EcDsaSignature signature = this.createEcdsaSignature(messageHash, new BigInteger(privateKey, 16));
        return signature.der().hexValue();
    }

    private EcDsaSignature createEcdsaSignature(UnsignedByteArray messageHash, BigInteger privateKey) {
        ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
        ECPrivateKeyParameters parameters = new ECPrivateKeyParameters(privateKey, Secp256k1.ecDomainParameters);
        signer.init(true, (CipherParameters)parameters);
        BigInteger[] signatures = signer.generateSignature(messageHash.toByteArray());
        BigInteger r = signatures[0];
        BigInteger s = signatures[1];
        BigInteger otherS = Secp256k1.ecDomainParameters.getN().subtract(s);
        if (s.compareTo(otherS) > 0) {
            s = otherS;
        }
        return EcDsaSignature.builder().r(r).s(s).build();
    }

    @Override
    public boolean verify(UnsignedByteArray message, String signature, String publicKey) {
        UnsignedByteArray messageHash = HashUtils.sha512Half(message);
        EcDsaSignature sig = EcDsaSignature.fromDer(BaseEncoding.base16().decode((CharSequence)signature));
        if (sig == null) {
            return false;
        }
        ECDSASigner signer = new ECDSASigner();
        ECPoint publicKeyPoint = Secp256k1.ecDomainParameters.getCurve().decodePoint(BaseEncoding.base16().decode((CharSequence)publicKey));
        ECPublicKeyParameters params = new ECPublicKeyParameters(publicKeyPoint, Secp256k1.ecDomainParameters);
        signer.init(false, (CipherParameters)params);
        return signer.verifySignature(messageHash.toByteArray(), sig.r(), sig.s());
    }
}

