/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.keypairs;

import com.google.common.io.BaseEncoding;
import java.util.Objects;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.xrpl.xrpl4j.codec.addresses.AddressCodec;
import org.xrpl.xrpl4j.codec.addresses.Decoded;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByte;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.codec.addresses.Version;
import org.xrpl.xrpl4j.codec.addresses.VersionType;
import org.xrpl.xrpl4j.codec.addresses.exceptions.DecodeException;
import org.xrpl.xrpl4j.keypairs.AbstractKeyPairService;
import org.xrpl.xrpl4j.keypairs.HashUtils;
import org.xrpl.xrpl4j.keypairs.KeyPair;
import org.xrpl.xrpl4j.keypairs.exceptions.SigningException;

public class Ed25519KeyPairService
extends AbstractKeyPairService {
    private static final Ed25519KeyPairService INSTANCE = new Ed25519KeyPairService(AddressCodec.getInstance());

    Ed25519KeyPairService(AddressCodec addressCodec) {
        Objects.requireNonNull(addressCodec);
        this.addressCodec = addressCodec;
        this.signer = new Ed25519Signer();
    }

    public static Ed25519KeyPairService getInstance() {
        return INSTANCE;
    }

    @Override
    public String generateSeed(UnsignedByteArray entropy) {
        return this.addressCodec.encodeSeed(entropy, VersionType.ED25519);
    }

    @Override
    public KeyPair deriveKeyPair(String seed) {
        Decoded decoded = this.addressCodec.decodeSeed(seed);
        if (!decoded.version().equals((Object)Version.ED25519_SEED)) {
            throw new DecodeException("Seed must use ED25519 algorithm. Algorithm was " + decoded.version());
        }
        return this.deriveKeyPair(decoded.bytes());
    }

    private KeyPair deriveKeyPair(UnsignedByteArray seed) {
        UnsignedByteArray rawPrivateKey = HashUtils.sha512Half(seed);
        Ed25519PrivateKeyParameters privateKey = new Ed25519PrivateKeyParameters(rawPrivateKey.toByteArray(), 0);
        Ed25519PublicKeyParameters publicKey = privateKey.generatePublicKey();
        UnsignedByte prefix = UnsignedByte.of((int)237);
        UnsignedByteArray prefixedPrivateKey = UnsignedByteArray.of((UnsignedByte)prefix, (UnsignedByte[])new UnsignedByte[0]).append(UnsignedByteArray.of((byte[])privateKey.getEncoded()));
        UnsignedByteArray prefixedPublicKey = UnsignedByteArray.of((UnsignedByte)prefix, (UnsignedByte[])new UnsignedByte[0]).append(UnsignedByteArray.of((byte[])publicKey.getEncoded()));
        return KeyPair.builder().privateKey(prefixedPrivateKey.hexValue()).publicKey(prefixedPublicKey.hexValue()).build();
    }

    @Override
    public String sign(UnsignedByteArray message, String privateKey) {
        Ed25519PrivateKeyParameters privateKeyParameters = new Ed25519PrivateKeyParameters(BaseEncoding.base16().decode((CharSequence)privateKey.substring(2)), 0);
        this.signer.reset();
        this.signer.init(true, (CipherParameters)privateKeyParameters);
        this.signer.update(message.toByteArray(), 0, message.getUnsignedBytes().size());
        try {
            byte[] signature = this.signer.generateSignature();
            return BaseEncoding.base16().encode(signature);
        }
        catch (CryptoException e) {
            throw new SigningException(e);
        }
    }

    @Override
    public boolean verify(UnsignedByteArray message, String signature, String publicKey) {
        Ed25519PublicKeyParameters publicKeyParameters = new Ed25519PublicKeyParameters(BaseEncoding.base16().decode((CharSequence)publicKey.substring(2)), 0);
        this.signer.reset();
        this.signer.init(false, (CipherParameters)publicKeyParameters);
        this.signer.update(message.toByteArray(), 0, message.getUnsignedBytes().size());
        return this.signer.verifySignature(BaseEncoding.base16().decode((CharSequence)signature));
    }
}

