/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.addresses;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.xrpl.xrpl4j.codec.addresses.ByteUtils;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByte;

public class UnsignedByteArray {
    private final List<UnsignedByte> unsignedBytes;

    public UnsignedByteArray(List<UnsignedByte> unsignedBytes) {
        Objects.requireNonNull(unsignedBytes);
        this.unsignedBytes = unsignedBytes;
    }

    public static UnsignedByteArray of(byte[] bytes) {
        Objects.requireNonNull(bytes);
        ArrayList<UnsignedByte> unsignedBytes = new ArrayList<UnsignedByte>(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            unsignedBytes.add(i, UnsignedByte.of(bytes[i]));
        }
        return new UnsignedByteArray(unsignedBytes);
    }

    public static UnsignedByteArray of(UnsignedByte first, UnsignedByte ... rest) {
        ArrayList<UnsignedByte> unsignedBytes = new ArrayList<UnsignedByte>();
        unsignedBytes.add(first);
        Collections.addAll(unsignedBytes, rest);
        return new UnsignedByteArray(unsignedBytes);
    }

    public static UnsignedByteArray empty() {
        return new UnsignedByteArray(new ArrayList<UnsignedByte>());
    }

    public static UnsignedByteArray ofSize(int size) {
        return new UnsignedByteArray(UnsignedByteArray.fill(size));
    }

    public static UnsignedByteArray fromHex(String hex) {
        Objects.requireNonNull(hex);
        List<UnsignedByte> unsignedBytes = ByteUtils.parse(hex.toUpperCase(Locale.ENGLISH));
        return new UnsignedByteArray(unsignedBytes);
    }

    private static List<UnsignedByte> fill(int amount) {
        ArrayList<UnsignedByte> unsignedBytes = new ArrayList<UnsignedByte>();
        for (int i = 0; i < amount; ++i) {
            unsignedBytes.add(i, UnsignedByte.of(0));
        }
        return unsignedBytes;
    }

    public List<UnsignedByte> getUnsignedBytes() {
        return this.unsignedBytes;
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[this.unsignedBytes.size()];
        for (int i = 0; i < this.unsignedBytes.size(); ++i) {
            bytes[i] = this.unsignedBytes.get(i).asByte();
        }
        return bytes;
    }

    public String hexValue() {
        return ByteUtils.toHex(this.unsignedBytes).toUpperCase(Locale.ENGLISH);
    }

    public int length() {
        return this.unsignedBytes.size();
    }

    public UnsignedByte get(int index) {
        return this.unsignedBytes.get(index);
    }

    public UnsignedByteArray append(UnsignedByte unsignedByte) {
        this.unsignedBytes.add(unsignedByte);
        return this;
    }

    public UnsignedByteArray append(UnsignedByteArray array) {
        this.unsignedBytes.addAll(array.getUnsignedBytes());
        return this;
    }

    public void set(int index, UnsignedByte value) {
        this.unsignedBytes.set(index, value);
    }

    public UnsignedByteArray slice(int startIndex, int endIndex) {
        return new UnsignedByteArray(this.unsignedBytes.subList(startIndex, endIndex));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UnsignedByteArray)) {
            return false;
        }
        UnsignedByteArray that = (UnsignedByteArray)object;
        return this.getUnsignedBytes().equals(that.getUnsignedBytes());
    }

    public int hashCode() {
        return Objects.hash(this.getUnsignedBytes());
    }

    public String toString() {
        return "UnsignedByteArray{unsignedBytes=List(size=" + this.unsignedBytes.size() + ")" + '}';
    }
}

