/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj;

import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.xpath.XPathFactory;
import org.assertj.core.api.AssertFactory;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.FactoryBasedNavigableIterableAssert;
import org.w3c.dom.Node;
import org.xmlunit.assertj.NodeAssertFactory;
import org.xmlunit.assertj.SingleNodeAssert;
import org.xmlunit.builder.Input;
import org.xmlunit.util.Convert;
import org.xmlunit.xpath.JAXPXPathEngine;

public class MultipleNodeAssert
extends FactoryBasedNavigableIterableAssert<MultipleNodeAssert, Iterable<Node>, Node, SingleNodeAssert> {
    private MultipleNodeAssert(Iterable<Node> nodes) {
        super(nodes, MultipleNodeAssert.class, (AssertFactory)new NodeAssertFactory());
    }

    static MultipleNodeAssert create(Object xmlSource, Map<String, String> prefix2Uri, DocumentBuilderFactory dbf, XPathFactory xpf, String xPath) {
        JAXPXPathEngine engine;
        Assertions.assertThat((String)xPath).isNotBlank();
        JAXPXPathEngine jAXPXPathEngine = engine = xpf == null ? new JAXPXPathEngine() : new JAXPXPathEngine(xpf);
        if (prefix2Uri != null) {
            engine.setNamespaceContext(prefix2Uri);
        }
        Source s = Input.from((Object)xmlSource).build();
        Node root = dbf != null ? Convert.toNode((Source)s, (DocumentBuilderFactory)dbf) : Convert.toNode((Source)s);
        Iterable nodes = engine.selectNodes(xPath, root);
        return (MultipleNodeAssert)new MultipleNodeAssert(nodes).describedAs("XPath \"%s\" evaluated to node set", new Object[]{xPath});
    }

    public MultipleNodeAssert exist() {
        return (MultipleNodeAssert)this.isNotEmpty();
    }

    public void doNotExist() {
        this.isEmpty();
    }

    public MultipleNodeAssert haveAttribute(final String attributeName) {
        this.isNotNull();
        this.allSatisfy(new SingleNodeAssertConsumer(){

            @Override
            public void accept(SingleNodeAssert singleNodeAssert) {
                singleNodeAssert.hasAttribute(attributeName);
            }
        });
        return this;
    }

    public MultipleNodeAssert haveAttribute(final String attributeName, final String attributeValue) {
        this.isNotNull();
        this.allSatisfy(new SingleNodeAssertConsumer(){

            @Override
            public void accept(SingleNodeAssert singleNodeAssert) {
                singleNodeAssert.hasAttribute(attributeName, attributeValue);
            }
        });
        return this;
    }

    public MultipleNodeAssert doNotHaveAttribute(final String attributeName) {
        this.isNotNull();
        this.allSatisfy(new SingleNodeAssertConsumer(){

            @Override
            public void accept(SingleNodeAssert singleNodeAssert) {
                singleNodeAssert.doesNotHaveAttribute(attributeName);
            }
        });
        return this;
    }

    public MultipleNodeAssert doNotHaveAttribute(final String attributeName, final String attributeValue) {
        this.isNotNull();
        this.allSatisfy(new SingleNodeAssertConsumer(){

            @Override
            public void accept(SingleNodeAssert singleNodeAssert) {
                singleNodeAssert.doesNotHaveAttribute(attributeName, attributeValue);
            }
        });
        return this;
    }

    private void allSatisfy(SingleNodeAssertConsumer consumer) {
        int index = 0;
        for (Node node : (Iterable)this.actual) {
            SingleNodeAssert singleNodeAssert = (SingleNodeAssert)this.toAssert(node, this.navigationDescription("check node at index " + index));
            consumer.accept(singleNodeAssert);
            ++index;
        }
    }

    static interface SingleNodeAssertConsumer {
        public void accept(SingleNodeAssert var1);
    }
}

