/*
 * Decompiled with CFR 0.152.
 */
package org.xmlmatchers.validation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xmlmatchers.transform.IdentityTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConformsToSchema
extends TypeSafeDiagnosingMatcher<Source> {
    private Schema schema;

    public ConformsToSchema(Schema schema) {
        this.schema = schema;
    }

    public void describeTo(Description description) {
        description.appendText("an XML document valid as per the given schema");
    }

    protected boolean matchesSafely(Source source, Description mismatchDescription) {
        boolean isValid = true;
        DOMSource domSource = this.convert(source);
        Validator validator = this.schema.newValidator();
        ValidationErrorHandler errorCollector = new ValidationErrorHandler();
        validator.setErrorHandler(errorCollector);
        try {
            validator.validate(domSource);
        }
        catch (SAXException e) {
            isValid = false;
        }
        catch (IOException e) {
            isValid = false;
        }
        if (errorCollector.hasErrors()) {
            errorCollector.updateDiscription(mismatchDescription);
            isValid = false;
        }
        return isValid;
    }

    protected DOMSource convert(Source source) {
        IdentityTransformer identity = new IdentityTransformer();
        DOMResult result = new DOMResult();
        identity.transform(source, result);
        return new DOMSource(result.getNode());
    }

    @Factory
    public static Matcher<Source> conformsTo(Schema schema) {
        return new ConformsToSchema(schema);
    }

    private static class ValidationErrorHandler
    implements ErrorHandler {
        private List<String> errorMessages = new ArrayList<String>();

        private ValidationErrorHandler() {
        }

        public void error(SAXParseException exception) throws SAXException {
            this.errorMessages.add(this.toMessage(exception));
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.errorMessages.add(this.toMessage(exception));
        }

        public void warning(SAXParseException exception) throws SAXException {
        }

        private String toMessage(SAXParseException exception) {
            StringBuilder message = new StringBuilder();
            message.append(exception.getMessage());
            message.append(" (line: ");
            message.append(exception.getLineNumber());
            message.append(" , column: ");
            message.append(exception.getColumnNumber());
            message.append(")");
            return message.toString();
        }

        public boolean hasErrors() {
            return !this.errorMessages.isEmpty();
        }

        public void updateDiscription(Description mismatchDescription) {
            if (!this.hasErrors()) {
                return;
            }
            mismatchDescription.appendText("has validation errors [");
            Iterator<String> messages = this.errorMessages.iterator();
            while (messages.hasNext()) {
                String message = messages.next();
                mismatchDescription.appendText(message);
                if (!messages.hasNext()) continue;
                mismatchDescription.appendText(", ");
            }
            mismatchDescription.appendText("]");
        }
    }
}

