/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import com.lowagie.text.pdf.BaseFont;
import org.xhtmlrenderer.css.constants.IdentValue;

public class FontDescription {
    private IdentValue _style;
    private int _weight;
    private BaseFont _font;
    private float _underlinePosition;
    private float _underlineThickness;
    private float _yStrikeoutSize;
    private float _yStrikeoutPosition;
    private boolean _isFromFontFace;

    public FontDescription() {
    }

    public FontDescription(BaseFont font) {
        this(font, IdentValue.NORMAL, 400);
    }

    public FontDescription(BaseFont font, IdentValue style, int weight) {
        this._font = font;
        this._style = style;
        this._weight = weight;
        this.setMetricDefaults();
    }

    public BaseFont getFont() {
        return this._font;
    }

    public void setFont(BaseFont font) {
        this._font = font;
    }

    public int getWeight() {
        return this._weight;
    }

    public void setWeight(int weight) {
        this._weight = weight;
    }

    public IdentValue getStyle() {
        return this._style;
    }

    public void setStyle(IdentValue style) {
        this._style = style;
    }

    public float getUnderlinePosition() {
        return this._underlinePosition;
    }

    public void setUnderlinePosition(float underlinePosition) {
        this._underlinePosition = underlinePosition;
    }

    public float getUnderlineThickness() {
        return this._underlineThickness;
    }

    public void setUnderlineThickness(float underlineThickness) {
        this._underlineThickness = underlineThickness;
    }

    public float getYStrikeoutPosition() {
        return this._yStrikeoutPosition;
    }

    public void setYStrikeoutPosition(float strikeoutPosition) {
        this._yStrikeoutPosition = strikeoutPosition;
    }

    public float getYStrikeoutSize() {
        return this._yStrikeoutSize;
    }

    public void setYStrikeoutSize(float strikeoutSize) {
        this._yStrikeoutSize = strikeoutSize;
    }

    private void setMetricDefaults() {
        this._underlinePosition = -50.0f;
        this._underlineThickness = 50.0f;
        int[] box = this._font.getCharBBox(120);
        if (box != null) {
            this._yStrikeoutPosition = box[3] / 2 + 50;
            this._yStrikeoutSize = 100.0f;
        } else {
            this._yStrikeoutPosition = this._font.getFontDescriptor(8, 1000.0f) / 3.0f;
        }
    }

    public boolean isFromFontFace() {
        return this._isFromFontFace;
    }

    public void setFromFontFace(boolean isFromFontFace) {
        this._isFromFontFace = isFromFontFace;
    }

    public String toString() {
        return String.format("Font %s:%s", this._font.getPostscriptFontName(), this._weight);
    }
}

