/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import java.io.IOException;
import org.openpdf.text.DocumentException;
import org.openpdf.text.Rectangle;
import org.openpdf.text.pdf.PdfAnnotation;
import org.openpdf.text.pdf.PdfAppearance;
import org.openpdf.text.pdf.PdfContentByte;
import org.openpdf.text.pdf.PdfFormField;
import org.openpdf.text.pdf.PdfTemplate;
import org.openpdf.text.pdf.PdfWriter;
import org.openpdf.text.pdf.TextField;
import org.w3c.dom.Element;
import org.xhtmlrenderer.css.parser.FSColor;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.pdf.AbstractFormField;
import org.xhtmlrenderer.pdf.ITextFSFont;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.util.Util;
import org.xhtmlrenderer.util.XRRuntimeException;

public class TextFormField
extends AbstractFormField {
    private static final String FIELD_TYPE = "Text";
    private static final int DEFAULT_SIZE = 15;
    private final int _baseline;
    private boolean multiline = false;

    public TextFormField(LayoutContext c, BlockBox box, int cssWidth, int cssHeight) {
        this.initDimensions(c, box, cssWidth, cssHeight);
        float fontSize = box.getStyle().getFSFont((CssContext)c).getSize2D();
        this._baseline = (int)((float)this.getHeight() / 2.0f + fontSize * 0.3f);
    }

    @Override
    protected void initDimensions(LayoutContext c, BlockBox box, int cssWidth, int cssHeight) {
        if (cssWidth != -1) {
            this.setWidth(cssWidth);
        } else {
            this.setWidth(c.getTextRenderer().getWidth(c.getFontContext(), box.getStyle().getFSFont((CssContext)c), this.spaces(this.getSize(box.getElement()))));
        }
        if (cssHeight != -1) {
            this.setHeight(cssHeight);
            this.multiline = true;
        } else {
            this.setHeight((int)box.getStyle().getLineHeight((CssContext)c));
        }
    }

    @Override
    protected String getFieldType() {
        return FIELD_TYPE;
    }

    @Override
    public void paint(RenderingContext c, ITextOutputDevice outputDevice, BlockBox box) {
        PdfWriter writer = outputDevice.getWriter();
        Element elem = box.getElement();
        Rectangle targetArea = outputDevice.createLocalTargetArea(c, (Box)box);
        String fieldName = this.getFieldName(outputDevice, elem);
        TextField field = new TextField(writer, targetArea, fieldName);
        String value = this.getValue(elem);
        field.setText(value);
        field.setMaxCharacterLength(this.getMaxLength(elem));
        try {
            PdfFormField formField = field.getTextField();
            if (this.multiline) {
                formField.setFieldFlags(4096);
            }
            this.createAppearance(c, outputDevice, box, formField, value);
            if (this.isReadOnly(elem)) {
                formField.setFieldFlags(1);
            }
            writer.addAnnotation((PdfAnnotation)formField);
        }
        catch (IOException | DocumentException ioe) {
            throw new XRRuntimeException("Failed to paint field %s".formatted(fieldName), ioe);
        }
    }

    private void createAppearance(RenderingContext c, ITextOutputDevice outputDevice, BlockBox box, PdfFormField field, String value) {
        PdfWriter writer = outputDevice.getWriter();
        ITextFSFont font = (ITextFSFont)box.getStyle().getFSFont((CssContext)c);
        PdfContentByte cb = writer.getDirectContent();
        float width = outputDevice.getDeviceLength(this.getWidth());
        float height = outputDevice.getDeviceLength(this.getHeight());
        float fontSize = outputDevice.getDeviceLength(font.getSize2D());
        PdfAppearance tp = cb.createAppearance(width, height);
        PdfAppearance tp2 = (PdfAppearance)tp.getDuplicate();
        tp2.setFontAndSize(font.getFontDescription().getFont(), fontSize);
        FSColor color = box.getStyle().getColor();
        this.setFillColor((PdfTemplate)tp2, color);
        field.setDefaultAppearanceString((PdfContentByte)tp2);
        tp.beginVariableText();
        tp.saveState();
        tp.beginText();
        tp.setFontAndSize(font.getFontDescription().getFont(), fontSize);
        this.setFillColor((PdfTemplate)tp, color);
        tp.setTextMatrix(0.0f, height / 2.0f - fontSize * 0.3f);
        tp.showText(value);
        tp.endText();
        tp.restoreState();
        tp.endVariableText();
        field.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, (PdfTemplate)tp);
    }

    private int getSize(Element elem) {
        String sSize = elem.getAttribute("size");
        if (Util.isNullOrEmpty((String)sSize)) {
            return 15;
        }
        try {
            return Integer.parseInt(sSize.trim());
        }
        catch (NumberFormatException e) {
            return 15;
        }
    }

    private int getMaxLength(Element elem) {
        String sMaxLen = elem.getAttribute("maxlength");
        if (Util.isNullOrEmpty((String)sMaxLen)) {
            return 0;
        }
        try {
            return Integer.parseInt(sMaxLen.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    protected String getValue(Element e) {
        return e.getAttribute("value");
    }

    public int getBaseline() {
        return this._baseline;
    }

    public boolean hasBaseline() {
        return true;
    }
}

