/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.openpdf.text.DocumentException;
import org.openpdf.text.pdf.BaseFont;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.sheet.FontFaceRule;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.FSDerivedValue;
import org.xhtmlrenderer.css.value.FontSpecification;
import org.xhtmlrenderer.extend.FontResolver;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.pdf.FontDescription;
import org.xhtmlrenderer.pdf.FontFamily;
import org.xhtmlrenderer.pdf.ITextFSFont;
import org.xhtmlrenderer.pdf.TrueTypeUtil;
import org.xhtmlrenderer.render.FSFont;
import org.xhtmlrenderer.util.FontUtil;
import org.xhtmlrenderer.util.IOUtil;
import org.xhtmlrenderer.util.SupportedEmbeddedFontTypes;
import org.xhtmlrenderer.util.XRLog;

public class ITextFontResolver
implements FontResolver {
    private static final Logger log = LoggerFactory.getLogger(ITextFontResolver.class);
    private static final String OTF = ".otf";
    private static final String TTF = ".ttf";
    private static final String AFM = ".afm";
    private static final String PFM = ".pfm";
    private static final String PFB = ".pfb";
    private static final String PFA = ".pfa";
    private static final String TTC = ".ttc";
    private static final String TTC_COMMA = ".ttc,";
    private final Map<String, FontFamily> _fontFamilies = new HashMap<String, FontFamily>();
    private final Map<String, FontDescription> _fontCache = new ConcurrentHashMap<String, FontDescription>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, FontFamily> getFonts() {
        if (this._fontFamilies.isEmpty()) {
            Map<String, FontFamily> map = this._fontFamilies;
            synchronized (map) {
                if (this._fontFamilies.isEmpty()) {
                    this._fontFamilies.putAll(this.loadFonts());
                }
            }
        }
        return this._fontFamilies;
    }

    public static Set<String> getDistinctFontFamilyNames(String path, String encoding, boolean embedded) {
        try {
            BaseFont font = BaseFont.createFont((String)path, (String)encoding, (boolean)embedded);
            Collection<String> fontFamilyNames = TrueTypeUtil.getFamilyNames(font);
            return new HashSet<String>(fontFamilyNames);
        }
        catch (IOException | DocumentException e) {
            throw new RuntimeException("Failed to read font family names from %s (encoding: %s, embedded: %s)".formatted(path, encoding, embedded), e);
        }
    }

    public @Nullable FSFont resolveFont(SharedContext renderingContext, FontSpecification spec) {
        return this.resolveFont(spec.families, spec.size, spec.fontWeight, spec.fontStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCache() {
        Map<String, FontFamily> map = this._fontFamilies;
        synchronized (map) {
            this._fontFamilies.clear();
        }
        this._fontCache.clear();
    }

    public void flushFontFaceFonts() {
        this._fontCache.clear();
        Iterator<FontFamily> i = this.getFonts().values().iterator();
        while (i.hasNext()) {
            FontFamily family = i.next();
            family.getFontDescriptions().removeIf(FontDescription::isFromFontFace);
            if (!family.getFontDescriptions().isEmpty()) continue;
            i.remove();
        }
    }

    public void importFontFaces(List<FontFaceRule> fontFaces, UserAgentCallback userAgentCallback) {
        for (FontFaceRule rule : fontFaces) {
            this.importFontFace(rule, userAgentCallback);
        }
    }

    private void importFontFace(FontFaceRule rule, UserAgentCallback userAgentCallback) {
        CalculatedStyle style = rule.getCalculatedStyle();
        FSDerivedValue src = style.valueByName(CSSName.SRC);
        if (src == IdentValue.NONE) {
            return;
        }
        byte[] font1 = userAgentCallback.getBinaryResource(src.asString());
        if (font1 == null) {
            XRLog.exception((String)("Could not load font " + src.asString()));
            return;
        }
        byte[] font2 = null;
        FSDerivedValue metricsSrc = style.valueByName(CSSName.FS_FONT_METRIC_SRC);
        if (metricsSrc != IdentValue.NONE && (font2 = userAgentCallback.getBinaryResource(metricsSrc.asString())) == null) {
            XRLog.exception((String)("Could not load font metric data " + src.asString()));
            return;
        }
        if (font2 != null) {
            byte[] t = font1;
            font1 = font2;
            font2 = t;
        }
        boolean embedded = style.isIdent(CSSName.FS_PDF_FONT_EMBED, IdentValue.EMBED);
        String encoding = style.getStringProperty(CSSName.FS_PDF_FONT_ENCODING);
        String fontFamily = rule.hasFontFamily() ? style.valueByName(CSSName.FONT_FAMILY).asString() : null;
        IdentValue fontWeight = rule.hasFontWeight() ? style.getIdent(CSSName.FONT_WEIGHT) : null;
        IdentValue fontStyle = rule.hasFontStyle() ? style.getIdent(CSSName.FONT_STYLE) : null;
        try {
            this.addFontFaceFont(fontFamily, fontWeight, fontStyle, src.asString(), encoding, embedded, font1, font2);
        }
        catch (IOException | DocumentException e) {
            XRLog.exception((String)("Could not load font " + src.asString()), (Throwable)e);
        }
    }

    public void addFontDirectory(String dir, boolean embedded) throws DocumentException, IOException {
        this.addFontDirectory(dir, "Cp1252", embedded);
    }

    public void addFontDirectory(String dir, String encoding, boolean embedded) throws DocumentException, IOException {
        File f = new File(dir);
        if (!f.isDirectory()) {
            throw new IllegalArgumentException("%s is not a directory".formatted(dir));
        }
        for (File file : this.filesWithExtensions(f, OTF, TTF)) {
            this.addFont(file.getAbsolutePath(), encoding, embedded);
        }
    }

    private File[] filesWithExtensions(File f, String ... extensions) {
        return Objects.requireNonNull(f.listFiles((d, name) -> {
            String lower = name.toLowerCase(Locale.ROOT);
            return Stream.of(extensions).anyMatch(extension -> lower.endsWith((String)extension));
        }));
    }

    public void addFont(String path, boolean embedded) throws DocumentException, IOException {
        this.addFont(path, "Cp1252", embedded);
    }

    public void addFont(String path, String encoding, boolean embedded) throws DocumentException, IOException {
        this.addFont(path, encoding, embedded, null);
    }

    public void addFont(String path, String encoding, boolean embedded, @Nullable String pathToPFB) throws DocumentException, IOException {
        this.addFont(path, null, encoding, embedded, pathToPFB);
    }

    public void addFont(String path, @Nullable String fontFamilyNameOverride, String encoding, boolean embedded, @Nullable String pathToPFB) throws DocumentException, IOException {
        String lower = path.toLowerCase(Locale.ROOT);
        if (lower.endsWith(OTF) || lower.endsWith(TTF) || lower.contains(TTC_COMMA)) {
            BaseFont font = BaseFont.createFont((String)path, (String)encoding, (boolean)embedded);
            this.addFont(font, path, fontFamilyNameOverride);
        } else if (lower.endsWith(TTC)) {
            String[] names = BaseFont.enumerateTTCNames((String)path);
            for (int i = 0; i < names.length; ++i) {
                this.addFont(path + "," + i, fontFamilyNameOverride, encoding, embedded, null);
            }
        } else if (lower.endsWith(AFM) || lower.endsWith(PFM)) {
            if (embedded && pathToPFB == null) {
                throw new IOException("When embedding a font, path to PFB/PFA file must be specified (path: %s)".formatted(path));
            }
            BaseFont font = BaseFont.createFont((String)path, (String)encoding, (boolean)embedded, (boolean)false, null, (byte[])this.readFile(pathToPFB));
            String fontFamilyName = Objects.requireNonNullElseGet(fontFamilyNameOverride, () -> font.getFamilyFontName()[0][3]);
            FontFamily fontFamily = this.getFontFamily(fontFamilyName);
            FontDescription description = new FontDescription(font);
            fontFamily.addFontDescription(description);
        } else {
            throw new IOException("Unsupported font type: %s".formatted(path));
        }
    }

    public void addFont(BaseFont font, String path, @Nullable String fontFamilyNameOverride) {
        Collection<String> fontFamilyNames = ITextFontResolver.getFontFamilyNames(font, fontFamilyNameOverride);
        for (String fontFamilyName : fontFamilyNames) {
            this.getFontFamily(fontFamilyName).addFontDescription(TrueTypeUtil.extractDescription(path, font, null));
        }
    }

    private static Collection<String> getFontFamilyNames(BaseFont font, @Nullable String fontFamilyNameOverride) {
        if (fontFamilyNameOverride != null) {
            return Collections.singletonList(fontFamilyNameOverride);
        }
        return TrueTypeUtil.getFamilyNames(font);
    }

    private boolean fontSupported(String uri) {
        String lower = uri.toLowerCase(Locale.ROOT);
        if (FontUtil.isEmbeddedBase64Font((String)uri)) {
            return SupportedEmbeddedFontTypes.isSupported((String)uri);
        }
        return lower.endsWith(OTF) || lower.endsWith(TTF) || lower.contains(TTC_COMMA);
    }

    private void addFontFaceFont(@Nullable String fontFamilyNameOverride, @Nullable IdentValue fontWeightOverride, @Nullable IdentValue fontStyleOverride, String uri, String encoding, boolean embedded, byte[] ttfAfm, byte @Nullable [] pfb) throws DocumentException, IOException {
        String lower = uri.toLowerCase(Locale.ROOT);
        if (this.fontSupported(lower)) {
            String fontName = FontUtil.isEmbeddedBase64Font((String)uri) ? fontFamilyNameOverride + SupportedEmbeddedFontTypes.getExtension((String)uri) : uri;
            BaseFont font = BaseFont.createFont((String)fontName, (String)encoding, (boolean)embedded, (boolean)false, (byte[])ttfAfm, (byte[])pfb);
            Collection<String> fontFamilyNames = ITextFontResolver.getFontFamilyNames(font, fontFamilyNameOverride);
            for (String fontFamilyName : fontFamilyNames) {
                FontFamily fontFamily = this.getFontFamily(fontFamilyName);
                fontFamily.addFontDescription(ITextFontResolver.fontDescription(fontWeightOverride, fontStyleOverride, uri, ttfAfm, font));
            }
        } else if (lower.endsWith(AFM) || lower.endsWith(PFM) || lower.endsWith(PFB) || lower.endsWith(PFA)) {
            if (embedded && pfb == null) {
                throw new IOException("When embedding a font, path to PFB/PFA file must be specified (uri: %s)".formatted(uri));
            }
            String name = uri.substring(0, uri.length() - 4) + AFM;
            BaseFont font = BaseFont.createFont((String)name, (String)encoding, (boolean)embedded, (boolean)false, (byte[])ttfAfm, (byte[])pfb);
            String fontFamilyName = font.getFamilyFontName()[0][3];
            FontFamily fontFamily = this.getFontFamily(fontFamilyName);
            FontDescription description = new FontDescription(font, true);
            fontFamily.addFontDescription(description);
        } else {
            throw new IOException("Unsupported font type: %s".formatted(uri));
        }
    }

    private static FontDescription fontDescription(@Nullable IdentValue fontWeightOverride, @Nullable IdentValue fontStyleOverride, String uri, byte[] ttfAfm, BaseFont font) {
        return TrueTypeUtil.extractDescription(uri, ttfAfm, font, true, fontWeightOverride, fontStyleOverride);
    }

    private byte[] readFile(String path) throws IOException {
        return IOUtil.readBytes((Path)Paths.get(path, new String[0]));
    }

    private FontFamily getFontFamily(String fontFamilyName) {
        FontFamily fontFamily = this.getFonts().get(fontFamilyName);
        if (fontFamily == null) {
            fontFamily = new FontFamily(fontFamilyName);
            this.getFonts().put(fontFamilyName, fontFamily);
        }
        return fontFamily;
    }

    private @Nullable FSFont resolveFont(String @Nullable [] families, float size, IdentValue weight, IdentValue style) {
        if (style != IdentValue.NORMAL && style != IdentValue.OBLIQUE && style != IdentValue.ITALIC) {
            style = IdentValue.NORMAL;
        }
        if (families != null) {
            for (String family : families) {
                FSFont font = this.resolveFont(family, size, weight, style);
                if (font == null) continue;
                return font;
            }
        }
        log.debug("Could not resolve font {}:{}:{} - fallback to Serif", new Object[]{Arrays.toString(families), weight, style});
        return this.resolveFont("Serif", size, weight, style);
    }

    String normalizeFontFamily(String fontFamily) {
        String result = this.stripQuotes(fontFamily);
        if (result.equalsIgnoreCase("serif")) {
            return "Serif";
        }
        if (result.equalsIgnoreCase("sans-serif")) {
            return "SansSerif";
        }
        if (result.equalsIgnoreCase("monospace")) {
            return "Monospaced";
        }
        return result;
    }

    private String stripQuotes(String text) {
        String result = text;
        if (result.startsWith("\"")) {
            result = result.substring(1);
        }
        if (result.endsWith("\"")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private @Nullable FSFont resolveFont(String fontFamily, float size, IdentValue weight, IdentValue style) {
        int desiredWeight;
        String normalizedFontFamily = this.normalizeFontFamily(fontFamily);
        String cacheKey = String.format("%s-%s-%s", normalizedFontFamily, weight, style);
        FontDescription result = this._fontCache.get(cacheKey);
        if (result != null) {
            log.debug("Resolved font (from cache) {}:{}:{} -> {}", new Object[]{fontFamily, weight, style, result});
            return new ITextFSFont(result, size);
        }
        FontFamily family = this.getFonts().get(normalizedFontFamily);
        if (family != null && (result = family.match(desiredWeight = ITextFontResolver.convertWeightToInt(weight), style)) != null) {
            log.debug("Resolved font {}:{}({}):{} -> {}", new Object[]{fontFamily, weight, desiredWeight, style, result});
            this._fontCache.put(cacheKey, result);
            return new ITextFSFont(result, size);
        }
        return null;
    }

    public static int convertWeightToInt(IdentValue weight) {
        if (weight == IdentValue.NORMAL) {
            return 400;
        }
        if (weight == IdentValue.BOLD) {
            return 700;
        }
        if (weight == IdentValue.FONT_WEIGHT_100) {
            return 100;
        }
        if (weight == IdentValue.FONT_WEIGHT_200) {
            return 200;
        }
        if (weight == IdentValue.FONT_WEIGHT_300) {
            return 300;
        }
        if (weight == IdentValue.FONT_WEIGHT_400) {
            return 400;
        }
        if (weight == IdentValue.FONT_WEIGHT_500) {
            return 500;
        }
        if (weight == IdentValue.FONT_WEIGHT_600) {
            return 600;
        }
        if (weight == IdentValue.FONT_WEIGHT_700) {
            return 700;
        }
        if (weight == IdentValue.FONT_WEIGHT_800) {
            return 800;
        }
        if (weight == IdentValue.FONT_WEIGHT_900) {
            return 900;
        }
        if (weight == IdentValue.LIGHTER) {
            return 400;
        }
        if (weight == IdentValue.BOLDER) {
            return 700;
        }
        throw new IllegalArgumentException("Cannot convert weight to integer: " + String.valueOf(weight));
    }

    protected Map<String, FontFamily> loadFonts() {
        HashMap<String, FontFamily> result = new HashMap<String, FontFamily>();
        this.addCourier(result);
        this.addTimes(result);
        this.addHelvetica(result);
        this.addSymbol(result);
        this.addZapfDingbats(result);
        return result;
    }

    private BaseFont createFont(String name) {
        return this.createFont(name, "winansi", true);
    }

    private BaseFont createFont(String name, String encoding, boolean embedded) {
        try {
            return BaseFont.createFont((String)name, (String)encoding, (boolean)embedded);
        }
        catch (IOException | DocumentException e) {
            throw new RuntimeException("Failed to load font %s (encoding: %s, embedded: %s)".formatted(name, encoding, embedded), e);
        }
    }

    private void addCourier(Map<String, FontFamily> result) {
        FontFamily courier = new FontFamily("Courier");
        courier.addFontDescription(new FontDescription(this.createFont("Courier-BoldOblique"), IdentValue.OBLIQUE, 700));
        courier.addFontDescription(new FontDescription(this.createFont("Courier-Oblique"), IdentValue.OBLIQUE, 400));
        courier.addFontDescription(new FontDescription(this.createFont("Courier-Bold"), IdentValue.NORMAL, 700));
        courier.addFontDescription(new FontDescription(this.createFont("Courier"), IdentValue.NORMAL, 400));
        result.put("DialogInput", courier);
        result.put("Monospaced", courier);
        result.put("Courier", courier);
    }

    private void addTimes(Map<String, FontFamily> result) {
        FontFamily times = new FontFamily("Times");
        times.addFontDescription(new FontDescription(this.createFont("Times-BoldItalic"), IdentValue.ITALIC, 700));
        times.addFontDescription(new FontDescription(this.createFont("Times-Italic"), IdentValue.ITALIC, 400));
        times.addFontDescription(new FontDescription(this.createFont("Times-Bold"), IdentValue.NORMAL, 700));
        times.addFontDescription(new FontDescription(this.createFont("Times-Roman"), IdentValue.NORMAL, 400));
        result.put("Serif", times);
        result.put("TimesRoman", times);
    }

    private void addHelvetica(Map<String, FontFamily> result) {
        FontFamily helvetica = new FontFamily("Helvetica");
        helvetica.addFontDescription(new FontDescription(this.createFont("Helvetica-BoldOblique"), IdentValue.OBLIQUE, 700));
        helvetica.addFontDescription(new FontDescription(this.createFont("Helvetica-Oblique"), IdentValue.OBLIQUE, 400));
        helvetica.addFontDescription(new FontDescription(this.createFont("Helvetica-Bold"), IdentValue.NORMAL, 700));
        helvetica.addFontDescription(new FontDescription(this.createFont("Helvetica"), IdentValue.NORMAL, 400));
        result.put("Dialog", helvetica);
        result.put("SansSerif", helvetica);
        result.put("Helvetica", helvetica);
    }

    private void addSymbol(Map<String, FontFamily> result) {
        FontFamily fontFamily = new FontFamily("Symbol");
        fontFamily.addFontDescription(new FontDescription(this.createFont("Symbol", "Cp1252", false), IdentValue.NORMAL, 400));
        result.put("Symbol", fontFamily);
    }

    private void addZapfDingbats(Map<String, FontFamily> result) {
        FontFamily fontFamily = new FontFamily("ZapfDingbats");
        fontFamily.addFontDescription(new FontDescription(this.createFont("ZapfDingbats", "Cp1252", false), IdentValue.NORMAL, 400));
        result.put("ZapfDingbats", fontFamily);
    }
}

