/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.interlibrary.action.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorCompletionService;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.xbib.content.settings.Settings;
import org.xbib.interlibrary.action.config.ConfigRequest;
import org.xbib.interlibrary.action.config.ConfigResponse;
import org.xbib.interlibrary.action.config.ConfigServiceProvider;
import org.xbib.interlibrary.api.action.AbstractResponse;
import org.xbib.interlibrary.api.action.Action;
import org.xbib.interlibrary.api.action.ActionContext;
import org.xbib.interlibrary.api.action.ActionExecutor;
import org.xbib.interlibrary.api.action.Request;
import org.xbib.interlibrary.api.action.Response;
import org.xbib.interlibrary.api.service.Service;
import org.xbib.interlibrary.api.service.ServiceArguments;

public class ConfigAction
implements Action<ConfigRequest, ConfigResponse> {
    public static final ConfigAction INSTANCE = new ConfigAction();
    private static final Logger logger = Logger.getLogger(ConfigAction.class.getName());
    private List<Service<ConfigRequest, ConfigResponse>> services = new ArrayList<Service<ConfigRequest, ConfigResponse>>();

    public Action<ConfigRequest, ConfigResponse> getInstance() {
        return INSTANCE;
    }

    public void init(Settings settings, ServiceArguments arguments, ClassLoader classLoader) {
        this.services = this.createServices(settings, arguments, classLoader);
    }

    public Service<ConfigRequest, ConfigResponse> getService(String name) {
        Optional<Service> optional = this.services.stream().filter(s -> s.getName().equalsIgnoreCase(name)).findFirst();
        return optional.orElse(null);
    }

    public List<Service<ConfigRequest, ConfigResponse>> getServices() {
        return this.services;
    }

    public ConfigResponse newErrorResponse(ConfigRequest request, String domain, Throwable throwable) {
        return new ConfigResponse(request, Response.Status.ERROR, throwable.getMessage());
    }

    public void execute(ActionContext<ConfigRequest, ConfigResponse> context) {
        block2: {
            try {
                ConfigResponse configResponse = (ConfigResponse)this.createActionExecutor(context).execute((Request)((ConfigRequest)context.getRequest()));
                context.setResponse((Response)configResponse);
            }
            catch (Throwable t) {
                if (context.getListener() == null) break block2;
                context.getListener().onFailure(t);
            }
        }
    }

    public void submit(ActionContext<ConfigRequest, ConfigResponse> context) {
        block2: {
            try {
                Stream futureResponses = this.createActionExecutor(context).submitToAllProviders((Request)((ConfigRequest)context.getRequest()));
                context.setFutureResponses(futureResponses);
            }
            catch (Throwable t) {
                if (context.getListener() == null) break block2;
                context.getListener().onFailure(t);
            }
        }
    }

    public void close() {
        this.services.forEach(s -> {
            try {
                s.close();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        });
    }

    private ActionExecutor<ConfigRequest, ConfigResponse> createActionExecutor(final ActionContext<ConfigRequest, ConfigResponse> context) {
        return new ActionExecutor<ConfigRequest, ConfigResponse>(){

            protected Stream<Service<ConfigRequest, ConfigResponse>> getServices() {
                return ConfigAction.this.services.stream();
            }

            protected ExecutorCompletionService<ConfigResponse> getExecutorCompletionService() {
                return context.getExecutorCompletionService();
            }

            protected ConfigResponse getFinalResponse(ConfigRequest request, List<ConfigResponse> list) {
                String messageList = list.stream().map(AbstractResponse::getMessage).collect(Collectors.joining());
                return new ConfigResponse(request, Response.Status.EMPTY, messageList);
            }
        };
    }

    private List<Service<ConfigRequest, ConfigResponse>> createServices(Settings settings, ServiceArguments arguments, ClassLoader classLoader) {
        ArrayList<ConfigServiceProvider> providers = new ArrayList<ConfigServiceProvider>();
        for (ConfigServiceProvider provider : ServiceLoader.load(ConfigServiceProvider.class, classLoader)) {
            providers.add(provider);
        }
        ArrayList<Service<ConfigRequest, ConfigResponse>> services = new ArrayList<Service<ConfigRequest, ConfigResponse>>();
        Map providerDefs = settings.getGroups("service.config");
        for (Map.Entry providerDef : providerDefs.entrySet()) {
            String providerName = (String)providerDef.getKey();
            Settings providerSettings = (Settings)providerDef.getValue();
            if (providerSettings.getAsBoolean("enabled", Boolean.valueOf(true)).booleanValue()) {
                try {
                    String className = providerSettings.get("class");
                    Class<?> clazz = Class.forName(className, false, classLoader);
                    providers.stream().filter(clazz::isInstance).forEach(configServiceProvider -> {
                        try {
                            Service<ConfigRequest, ConfigResponse> service = configServiceProvider.createService(settings, providerName, providerSettings, arguments);
                            services.add(service);
                        }
                        catch (IOException e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                        }
                    });
                    if (!services.isEmpty()) continue;
                    logger.log(Level.WARNING, "no provider found for instance of " + clazz);
                }
                catch (ClassNotFoundException e) {
                    if (!logger.isLoggable(Level.WARNING)) continue;
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
                continue;
            }
            if (!logger.isLoggable(Level.WARNING)) continue;
            logger.log(Level.WARNING, "provider is disabled: " + providerName);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "services: " + services.size() + " " + services);
        }
        return services;
    }
}

