package org.xbib.interlibrary.action.config;

import org.xbib.interlibrary.api.action.AbstractResponse;
import org.xbib.interlibrary.common.util.LinkedHashSetMultiMap;
import org.xbib.interlibrary.common.util.MultiMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ConfigResponse extends AbstractResponse<ConfigRequest> {

    private final MultiMap<String, Object> response;

    public ConfigResponse(ConfigRequest configRequest,
                          ConfigResponse.Status status,
                          String message) {
        super(configRequest, status, message);
        this.response = new LinkedHashSetMultiMap<>();
    }

    public MultiMap<String, Object> getResponse() {
        return response;
    }

    @Override
    public Map<String, Object> asMap() {
        Map<String, Object> map = new LinkedHashMap<>();
        getMeta().put("status", getStatus().name());
        map.put("meta", getMeta());
        if (getMessage() != null) {
            map.put("message", getMessage());
        }
        map.put("response", response.asMap());
        return map;
    }

    @Override
    public String toString() {
        return asMap().toString();
    }
}
