/*
 * Decompiled with CFR 0.152.
 */
package org.wowtools.giscat.vector.pojo.converter;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.wowtools.giscat.vector.pojo.Feature;
import org.wowtools.giscat.vector.pojo.FeatureCollection;
import org.wowtools.giscat.vector.pojo.proto.ProtoFeature;

public class ProtoFeatureConverter {
    private static final Descriptors.FieldDescriptor FieldDescriptor_Point_z = ProtoFeature.Point.getDescriptor().findFieldByNumber(3);
    private static final Map<Class, PropertiesSetter> propertiesSetterMap;

    public static byte[] geometry2Proto(Geometry geometry) {
        return ProtoFeatureConverter.geometry2ProtoBuilder(geometry).build().toByteArray();
    }

    private static ProtoFeature.Geometry.Builder geometry2ProtoBuilder(Geometry geometry) {
        ProtoFeature.Geometry.Builder geometryBuilder = ProtoFeature.Geometry.newBuilder();
        if (geometry instanceof Point) {
            geometryBuilder.setPoint(ProtoFeatureConverter.point2Proto((Point)geometry));
        } else if (geometry instanceof LineString) {
            geometryBuilder.setLineString(ProtoFeatureConverter.lineString2Proto((LineString)geometry));
        } else if (geometry instanceof Polygon) {
            geometryBuilder.setPolygon(ProtoFeatureConverter.polygon2Proto((Polygon)geometry));
        } else if (geometry instanceof MultiPoint) {
            geometryBuilder.setMultiPoint(ProtoFeatureConverter.multiPoint2Proto((MultiPoint)geometry));
        } else if (geometry instanceof MultiLineString) {
            geometryBuilder.setMultiLineString(ProtoFeatureConverter.multiLineString2Proto((MultiLineString)geometry));
        } else if (geometry instanceof MultiPolygon) {
            geometryBuilder.setMultiPolygon(ProtoFeatureConverter.multiPolygon2Proto((MultiPolygon)geometry));
        } else if (geometry instanceof GeometryCollection) {
            geometryBuilder.setGeometryCollection(ProtoFeatureConverter.geometryCollection2Proto((GeometryCollection)geometry));
        } else {
            throw new RuntimeException("\u672a\u5b9e\u73b0\u7684geometry\u7c7b\u578b " + geometry.getClass());
        }
        return geometryBuilder;
    }

    private static ProtoFeature.Point.Builder point2Proto(Point point) {
        Coordinate coordinate = point.getCoordinate();
        ProtoFeature.Point.Builder builder = ProtoFeature.Point.newBuilder();
        builder.setX(coordinate.getX());
        builder.setY(coordinate.getY());
        if (!Double.isNaN(coordinate.getZ())) {
            builder.setZ(coordinate.getZ());
        }
        return builder;
    }

    private static ProtoFeature.LineString.Builder lineString2Proto(LineString lineString) {
        ProtoFeature.LineString.Builder builder = ProtoFeature.LineString.newBuilder();
        Coordinate[] coordinates = lineString.getCoordinates();
        ProtoCoordinateCell protoCoordinateCell = new ProtoCoordinateCell(coordinates);
        builder.addAllXs(protoCoordinateCell.xs);
        builder.addAllYs(protoCoordinateCell.ys);
        if (null != protoCoordinateCell.zs) {
            builder.addAllZs(protoCoordinateCell.zs);
        }
        return builder;
    }

    private static ProtoFeature.Polygon.Builder polygon2Proto(Polygon polygon) {
        ProtoFeature.Polygon.Builder builder = ProtoFeature.Polygon.newBuilder();
        LinkedList<Integer> separators = new LinkedList<Integer>();
        int holeNum = polygon.getNumInteriorRing();
        Coordinate[] coordinates = new Coordinate[polygon.getNumPoints() - 1 - holeNum];
        int k = -1;
        Coordinate[] shellCoordinates = polygon.getExteriorRing().getCoordinates();
        for (int x = 0; x < shellCoordinates.length - 1; ++x) {
            coordinates[++k] = shellCoordinates[x];
        }
        if (holeNum > 0) {
            separators.add(k);
            for (int i = 0; i < holeNum; ++i) {
                Coordinate[] childCoordinates = polygon.getInteriorRingN(i).getCoordinates();
                for (int j = 0; j < childCoordinates.length - 1; ++j) {
                    coordinates[++k] = childCoordinates[j];
                }
                if (i >= holeNum - 1) continue;
                separators.add(k);
            }
        }
        ProtoCoordinateCell protoCoordinateCell = new ProtoCoordinateCell(coordinates);
        builder.addAllXs(protoCoordinateCell.xs);
        builder.addAllYs(protoCoordinateCell.ys);
        if (null != protoCoordinateCell.zs) {
            builder.addAllZs(protoCoordinateCell.zs);
        }
        builder.addAllSeparators(separators);
        return builder;
    }

    private static ProtoFeature.MultiPoint.Builder multiPoint2Proto(MultiPoint multiPoint) {
        ProtoFeature.MultiPoint.Builder builder = ProtoFeature.MultiPoint.newBuilder();
        Coordinate[] coordinates = multiPoint.getCoordinates();
        ProtoCoordinateCell protoCoordinateCell = new ProtoCoordinateCell(coordinates);
        builder.addAllXs(protoCoordinateCell.xs);
        builder.addAllYs(protoCoordinateCell.ys);
        if (null != protoCoordinateCell.zs) {
            builder.addAllZs(protoCoordinateCell.zs);
        }
        return builder;
    }

    private static ProtoFeature.MultiLineString.Builder multiLineString2Proto(MultiLineString multiLineString) {
        ProtoFeature.MultiLineString.Builder builder = ProtoFeature.MultiLineString.newBuilder();
        LinkedList<Integer> separators = new LinkedList<Integer>();
        int lineNum = multiLineString.getNumGeometries();
        Coordinate[] coordinates = new Coordinate[multiLineString.getNumPoints()];
        int k = -1;
        for (int i = 0; i < lineNum; ++i) {
            Coordinate[] childCoordinates;
            for (Coordinate childCoordinate : childCoordinates = multiLineString.getGeometryN(i).getCoordinates()) {
                coordinates[++k] = childCoordinate;
            }
            if (i >= lineNum - 1) continue;
            separators.add(k);
        }
        if (separators.size() > 0) {
            builder.addAllSeparators(separators);
        }
        ProtoCoordinateCell protoCoordinateCell = new ProtoCoordinateCell(coordinates);
        builder.addAllXs(protoCoordinateCell.xs);
        builder.addAllYs(protoCoordinateCell.ys);
        if (null != protoCoordinateCell.zs) {
            builder.addAllZs(protoCoordinateCell.zs);
        }
        return builder;
    }

    private static ProtoFeature.MultiPolygon.Builder multiPolygon2Proto(MultiPolygon multiPolygon) {
        ProtoFeature.MultiPolygon.Builder builder = ProtoFeature.MultiPolygon.newBuilder();
        int polygonNum = multiPolygon.getNumGeometries();
        LinkedList<Integer> coordSeparators = new LinkedList<Integer>();
        LinkedList<Integer> polygonSeparators = new LinkedList<Integer>();
        LinkedList<Coordinate> coordinateList = new LinkedList<Coordinate>();
        int k = -1;
        int beforePolygonSeparator = 0;
        for (int gi = 0; gi < polygonNum; ++gi) {
            Polygon polygon = (Polygon)multiPolygon.getGeometryN(gi);
            int holeNum = polygon.getNumInteriorRing();
            Coordinate[] shellCoordinates = polygon.getExteriorRing().getCoordinates();
            for (int x = 0; x < shellCoordinates.length - 1; ++x) {
                ++k;
                coordinateList.add(shellCoordinates[x]);
            }
            coordSeparators.add(k);
            if (holeNum > 0) {
                for (int i = 0; i < holeNum; ++i) {
                    Coordinate[] childCoordinates = polygon.getInteriorRingN(i).getCoordinates();
                    for (int j = 0; j < childCoordinates.length - 1; ++j) {
                        ++k;
                        coordinateList.add(childCoordinates[j]);
                    }
                    coordSeparators.add(k);
                }
            }
            int currentPolygonSeparator = beforePolygonSeparator + 1 + holeNum;
            polygonSeparators.add(currentPolygonSeparator);
            beforePolygonSeparator = currentPolygonSeparator;
        }
        coordSeparators.removeLast();
        polygonSeparators.removeLast();
        if (coordSeparators.size() > 0) {
            builder.addAllCoordSeparators(coordSeparators);
        }
        if (polygonSeparators.size() > 0) {
            builder.addAllPolygonSeparators(polygonSeparators);
        }
        Coordinate[] coordinates = new Coordinate[coordinateList.size()];
        coordinateList.toArray(coordinates);
        ProtoCoordinateCell protoCoordinateCell = new ProtoCoordinateCell(coordinates);
        builder.addAllXs(protoCoordinateCell.xs);
        builder.addAllYs(protoCoordinateCell.ys);
        if (null != protoCoordinateCell.zs) {
            builder.addAllZs(protoCoordinateCell.zs);
        }
        return builder;
    }

    private static ProtoFeature.GeometryCollection.Builder geometryCollection2Proto(GeometryCollection geometryCollection) {
        ProtoFeature.GeometryCollection.Builder builder = ProtoFeature.GeometryCollection.newBuilder();
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            Geometry geometry = geometryCollection.getGeometryN(i);
            if (geometry instanceof Point) {
                builder.addPoints(ProtoFeatureConverter.point2Proto((Point)geometry));
                continue;
            }
            if (geometry instanceof LineString) {
                builder.addLineStrings(ProtoFeatureConverter.lineString2Proto((LineString)geometry));
                continue;
            }
            if (geometry instanceof Polygon) {
                builder.addPolygons(ProtoFeatureConverter.polygon2Proto((Polygon)geometry));
                continue;
            }
            if (geometry instanceof MultiPoint) {
                builder.addMultiPoints(ProtoFeatureConverter.multiPoint2Proto((MultiPoint)geometry));
                continue;
            }
            if (geometry instanceof MultiLineString) {
                builder.addMultiLineStrings(ProtoFeatureConverter.multiLineString2Proto((MultiLineString)geometry));
                continue;
            }
            if (geometry instanceof MultiPolygon) {
                builder.addMultiPolygons(ProtoFeatureConverter.multiPolygon2Proto((MultiPolygon)geometry));
                continue;
            }
            if (geometry instanceof GeometryCollection) {
                builder.addGeometryCollections(ProtoFeatureConverter.geometryCollection2Proto((GeometryCollection)geometry));
                continue;
            }
            throw new RuntimeException("\u672a\u5b9e\u73b0\u7684geometry\u7c7b\u578b " + geometry.getClass());
        }
        return builder;
    }

    public static Geometry proto2Geometry(byte[] bytes, GeometryFactory geometryFactory) {
        ProtoFeature.Geometry pGeometry;
        if (null == bytes || bytes.length == 0) {
            return null;
        }
        try {
            pGeometry = ProtoFeature.Geometry.parseFrom(bytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        return ProtoFeatureConverter.proto2Geometry(pGeometry, geometryFactory);
    }

    private static Geometry proto2Geometry(ProtoFeature.Geometry pGeometry, GeometryFactory geometryFactory) {
        if (pGeometry.hasPoint()) {
            ProtoFeature.Point pPoint = pGeometry.getPoint();
            return ProtoFeatureConverter.proto2Point(pPoint, geometryFactory);
        }
        if (pGeometry.hasLineString()) {
            ProtoFeature.LineString pLineString = pGeometry.getLineString();
            return ProtoFeatureConverter.proto2LineString(pLineString, geometryFactory);
        }
        if (pGeometry.hasPolygon()) {
            ProtoFeature.Polygon pPolygon = pGeometry.getPolygon();
            return ProtoFeatureConverter.proto2Polygon(pPolygon, geometryFactory);
        }
        if (pGeometry.hasMultiPoint()) {
            ProtoFeature.MultiPoint pMultiPoint = pGeometry.getMultiPoint();
            return ProtoFeatureConverter.proto2MultiPoint(pMultiPoint, geometryFactory);
        }
        if (pGeometry.hasMultiLineString()) {
            ProtoFeature.MultiLineString pMultiLineString = pGeometry.getMultiLineString();
            return ProtoFeatureConverter.proto2MultiLineString(pMultiLineString, geometryFactory);
        }
        if (pGeometry.hasMultiPolygon()) {
            ProtoFeature.MultiPolygon pMultiPolygon = pGeometry.getMultiPolygon();
            return ProtoFeatureConverter.proto2MultiPolygon(pMultiPolygon, geometryFactory);
        }
        if (pGeometry.hasGeometryCollection()) {
            ProtoFeature.GeometryCollection pGeometryCollection = pGeometry.getGeometryCollection();
            return ProtoFeatureConverter.proto2GeometryCollection(pGeometryCollection, geometryFactory);
        }
        throw new RuntimeException("\u89e3\u6790pGeometry\u903b\u8f91\u9519\u8bef");
    }

    private static Coordinate[] proto2Coordinates(List<Double> xs, List<Double> ys, List<Double> zs) {
        int n = xs.size();
        Coordinate[] coordinates = new Coordinate[n];
        if (zs.size() != xs.size()) {
            for (int i = 0; i < n; ++i) {
                coordinates[i] = new Coordinate(xs.get(i).doubleValue(), ys.get(i).doubleValue());
            }
        } else {
            for (int i = 0; i < n; ++i) {
                coordinates[i] = new Coordinate(xs.get(i).doubleValue(), ys.get(i).doubleValue(), zs.get(i).doubleValue());
            }
        }
        return coordinates;
    }

    private static Coordinate[][] separatorCoordinates(Coordinate[] coordinates, List<Integer> separators) {
        Coordinate[][] separatorCoordinates = new Coordinate[separators.size() + 1][];
        int idx = 0;
        int i = 0;
        int beforeSeparator = 0;
        for (int separator : separators) {
            int k = 0;
            Coordinate[] subCoordinate = new Coordinate[++separator - beforeSeparator];
            while (i < separator) {
                subCoordinate[k] = coordinates[i];
                ++k;
                ++i;
            }
            separatorCoordinates[idx] = subCoordinate;
            beforeSeparator = separator;
            ++idx;
        }
        int k = 0;
        Coordinate[] subCoordinate = new Coordinate[coordinates.length - i];
        while (i < coordinates.length) {
            subCoordinate[k] = coordinates[i];
            ++k;
            ++i;
        }
        separatorCoordinates[idx] = subCoordinate;
        return separatorCoordinates;
    }

    private static Point proto2Point(ProtoFeature.Point pPoint, GeometryFactory geometryFactory) {
        double x = pPoint.getX();
        double y = pPoint.getY();
        Coordinate coordinate = new Coordinate(x, y);
        if (pPoint.hasField(FieldDescriptor_Point_z)) {
            coordinate.setZ(pPoint.getZ());
        }
        return geometryFactory.createPoint(coordinate);
    }

    private static LineString proto2LineString(ProtoFeature.LineString pLineString, GeometryFactory geometryFactory) {
        Coordinate[] coordinates = ProtoFeatureConverter.proto2Coordinates(pLineString.getXsList(), pLineString.getYsList(), pLineString.getZsList());
        return geometryFactory.createLineString(coordinates);
    }

    private static LinearRing coordinates2LinearRing(Coordinate[] coordinates, GeometryFactory geometryFactory) {
        Coordinate[] ringCoordinates = new Coordinate[coordinates.length + 1];
        System.arraycopy(coordinates, 0, ringCoordinates, 0, coordinates.length);
        ringCoordinates[coordinates.length] = coordinates[0].copy();
        return geometryFactory.createLinearRing(ringCoordinates);
    }

    private static Polygon proto2Polygon(Coordinate[][] separatorCoordinates, GeometryFactory geometryFactory) {
        LinearRing shell = ProtoFeatureConverter.coordinates2LinearRing(separatorCoordinates[0], geometryFactory);
        LinearRing[] holes = new LinearRing[separatorCoordinates.length - 1];
        for (int i = 1; i < separatorCoordinates.length; ++i) {
            holes[i - 1] = ProtoFeatureConverter.coordinates2LinearRing(separatorCoordinates[i], geometryFactory);
        }
        return geometryFactory.createPolygon(shell, holes);
    }

    private static Polygon proto2Polygon(ProtoFeature.Polygon pPolygon, GeometryFactory geometryFactory) {
        Coordinate[] coordinates = ProtoFeatureConverter.proto2Coordinates(pPolygon.getXsList(), pPolygon.getYsList(), pPolygon.getZsList());
        List<Integer> separators = pPolygon.getSeparatorsList();
        if (separators.size() == 0) {
            return geometryFactory.createPolygon(ProtoFeatureConverter.coordinates2LinearRing(coordinates, geometryFactory));
        }
        return ProtoFeatureConverter.proto2Polygon(ProtoFeatureConverter.separatorCoordinates(coordinates, separators), geometryFactory);
    }

    private static MultiPoint proto2MultiPoint(ProtoFeature.MultiPoint pMultiPoint, GeometryFactory geometryFactory) {
        Coordinate[] coordinates = ProtoFeatureConverter.proto2Coordinates(pMultiPoint.getXsList(), pMultiPoint.getYsList(), pMultiPoint.getZsList());
        return geometryFactory.createMultiPointFromCoords(coordinates);
    }

    private static MultiLineString proto2MultiLineString(ProtoFeature.MultiLineString pMultiLineString, GeometryFactory geometryFactory) {
        Coordinate[] coordinates = ProtoFeatureConverter.proto2Coordinates(pMultiLineString.getXsList(), pMultiLineString.getYsList(), pMultiLineString.getZsList());
        List<Integer> separators = pMultiLineString.getSeparatorsList();
        if (separators.size() == 0) {
            return geometryFactory.createMultiLineString(new LineString[]{geometryFactory.createLineString(coordinates)});
        }
        Coordinate[][] separatorCoordinates = ProtoFeatureConverter.separatorCoordinates(coordinates, separators);
        LineString[] lineStrings = new LineString[separatorCoordinates.length];
        for (int i = 0; i < lineStrings.length; ++i) {
            lineStrings[i] = geometryFactory.createLineString(separatorCoordinates[i]);
        }
        return geometryFactory.createMultiLineString(lineStrings);
    }

    private static MultiPolygon proto2MultiPolygon(ProtoFeature.MultiPolygon pMultiPolygon, GeometryFactory geometryFactory) {
        Coordinate[] coordinates = ProtoFeatureConverter.proto2Coordinates(pMultiPolygon.getXsList(), pMultiPolygon.getYsList(), pMultiPolygon.getZsList());
        List<Integer> list = pMultiPolygon.getPolygonSeparatorsList();
        ArrayList<Integer> polygonSeparators = new ArrayList<Integer>(list.size() + 1);
        polygonSeparators.addAll(list);
        List<Integer> coordSeparators = pMultiPolygon.getCoordSeparatorsList();
        if (polygonSeparators.size() == 0) {
            Polygon polygon = geometryFactory.createPolygon(ProtoFeatureConverter.coordinates2LinearRing(coordinates, geometryFactory));
            return geometryFactory.createMultiPolygon(new Polygon[]{polygon});
        }
        Polygon[] polygons = new Polygon[polygonSeparators.size() + 1];
        int idx = 0;
        int beforePolygonSeparator = 0;
        Coordinate[][] separatorCoordinates = ProtoFeatureConverter.separatorCoordinates(coordinates, coordSeparators);
        polygonSeparators.add(separatorCoordinates.length);
        Iterator iterator = polygonSeparators.iterator();
        while (iterator.hasNext()) {
            Polygon polygon;
            int polygonSeparator = (Integer)iterator.next();
            Coordinate[][] subSeparatorCoordinates = new Coordinate[polygonSeparator - beforePolygonSeparator][];
            int i1 = 0;
            for (int i = beforePolygonSeparator; i < polygonSeparator; ++i) {
                subSeparatorCoordinates[i1] = separatorCoordinates[i];
                ++i1;
            }
            polygons[idx] = polygon = ProtoFeatureConverter.proto2Polygon(subSeparatorCoordinates, geometryFactory);
            ++idx;
            beforePolygonSeparator = polygonSeparator;
        }
        return geometryFactory.createMultiPolygon(polygons);
    }

    private static GeometryCollection proto2GeometryCollection(ProtoFeature.GeometryCollection pGeometryCollection, GeometryFactory geometryFactory) {
        LinkedList<Object> geometryList = new LinkedList<Object>();
        for (ProtoFeature.Point point : pGeometryCollection.getPointsList()) {
            geometryList.add(ProtoFeatureConverter.proto2Point(point, geometryFactory));
        }
        for (ProtoFeature.LineString lineString : pGeometryCollection.getLineStringsList()) {
            geometryList.add(ProtoFeatureConverter.proto2LineString(lineString, geometryFactory));
        }
        for (ProtoFeature.Polygon polygon : pGeometryCollection.getPolygonsList()) {
            geometryList.add(ProtoFeatureConverter.proto2Polygon(polygon, geometryFactory));
        }
        for (ProtoFeature.MultiPoint multiPoint : pGeometryCollection.getMultiPointsList()) {
            geometryList.add(ProtoFeatureConverter.proto2MultiPoint(multiPoint, geometryFactory));
        }
        for (ProtoFeature.MultiLineString multiLineString : pGeometryCollection.getMultiLineStringsList()) {
            geometryList.add(ProtoFeatureConverter.proto2MultiLineString(multiLineString, geometryFactory));
        }
        for (ProtoFeature.MultiPolygon multiPolygon : pGeometryCollection.getMultiPolygonsList()) {
            geometryList.add(ProtoFeatureConverter.proto2MultiPolygon(multiPolygon, geometryFactory));
        }
        for (ProtoFeature.GeometryCollection geometryCollection : pGeometryCollection.getGeometryCollectionsList()) {
            geometryList.add(ProtoFeatureConverter.proto2GeometryCollection(geometryCollection, geometryFactory));
        }
        Geometry[] geometries = new Geometry[geometryList.size()];
        geometryList.toArray(geometries);
        return geometryFactory.createGeometryCollection(geometries);
    }

    public static byte[] featureCollection2Proto(FeatureCollection featureCollection) {
        ToProtoKeyValueCell keyValueCell = new ToProtoKeyValueCell();
        ProtoFeature.FeatureCollection.Builder builder = ProtoFeature.FeatureCollection.newBuilder();
        for (Feature feature : featureCollection.getFeatures()) {
            ProtoFeature.Map.Builder propertiesBuilder;
            Map<String, Object> properties = feature.getProperties();
            if (null != properties) {
                propertiesBuilder = ProtoFeature.Map.newBuilder();
                ProtoFeatureConverter.properties2ProtoBuilder(properties, propertiesBuilder, keyValueCell);
                builder.addPropertiess(propertiesBuilder);
            } else {
                propertiesBuilder = ProtoFeature.Map.newBuilder();
                builder.addPropertiess(propertiesBuilder);
            }
            Geometry geometry = feature.getGeometry();
            if (null == geometry) {
                throw new RuntimeException("geometry\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ProtoFeature.Geometry.Builder geometryBuilder = ProtoFeatureConverter.geometry2ProtoBuilder(geometry);
            builder.addGeometries(geometryBuilder);
        }
        keyValueCell.toProto(builder);
        return builder.build().toByteArray();
    }

    private static void properties2ProtoBuilder(Map<String, Object> properties, ProtoFeature.Map.Builder propertiesBuilder, ToProtoKeyValueCell keyValueCell) {
        properties.forEach((key, value) -> {
            if (null == value) {
                return;
            }
            PropertiesSetter propertiesSetter = propertiesSetterMap.get(value.getClass());
            if (propertiesSetter != null) {
                propertiesSetter.set(propertiesBuilder, keyValueCell, (String)key, value);
            } else {
                if (!(value instanceof Map)) {
                    throw new UnsupportedOperationException("\u672a\u5b9e\u73b0\u7684 value \u7c7b\u578b:" + value.getClass());
                }
                Map subProperties = (Map)value;
                ProtoFeature.Map.Builder subMap = ProtoFeature.Map.newBuilder();
                ProtoFeatureConverter.properties2ProtoBuilder(subProperties, subMap, keyValueCell);
                propertiesBuilder.addSubKeyIds(keyValueCell.keys.getId((String)key));
                propertiesBuilder.addSubMaps(subMap);
            }
        });
    }

    public static FeatureCollection proto2featureCollection(byte[] bytes, GeometryFactory geometryFactory) {
        ProtoFeature.FeatureCollection pFeatureCollection;
        try {
            pFeatureCollection = ProtoFeature.FeatureCollection.parseFrom(bytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        FromProtoKeyValueCell keyValueCell = new FromProtoKeyValueCell(pFeatureCollection);
        int featureNum = pFeatureCollection.getGeometriesCount();
        ArrayList<Feature> features = new ArrayList<Feature>(featureNum);
        for (int i = 0; i < featureNum; ++i) {
            Feature feature = new Feature();
            ProtoFeature.Geometry pGeometry = pFeatureCollection.getGeometries(i);
            Geometry geometry = ProtoFeatureConverter.proto2Geometry(pGeometry, geometryFactory);
            feature.setGeometry(geometry);
            ProtoFeature.Map pProperties = pFeatureCollection.getPropertiess(i);
            feature.setProperties(keyValueCell.parseProperties(pProperties));
            features.add(feature);
        }
        FeatureCollection featureCollection = new FeatureCollection();
        featureCollection.setFeatures(features);
        return featureCollection;
    }

    static {
        PropertiesSetter doublePropertiesSetter = (propertiesBuilder, keyValueCell, key, value) -> {
            propertiesBuilder.addDoubleKeyIds(keyValueCell.keys.getId(key));
            propertiesBuilder.addDoubleValueIds(keyValueCell.doubleValues.getId((Double)value));
        };
        PropertiesSetter floatPropertiesSetter = (propertiesBuilder, keyValueCell, key, value) -> {
            propertiesBuilder.addFloatKeyIds(keyValueCell.keys.getId(key));
            propertiesBuilder.addFloatValueIds(keyValueCell.floatValues.getId((Float)value));
        };
        PropertiesSetter sint32PropertiesSetter = (propertiesBuilder, keyValueCell, key, value) -> {
            propertiesBuilder.addSint32KeyIds(keyValueCell.keys.getId(key));
            propertiesBuilder.addSint32ValueIds(keyValueCell.sint32Values.getId((Integer)value));
        };
        PropertiesSetter sint64PropertiesSetter = (propertiesBuilder, keyValueCell, key, value) -> {
            propertiesBuilder.addSint64KeyIds(keyValueCell.keys.getId(key));
            propertiesBuilder.addSint64ValueIds(keyValueCell.sint64Values.getId((Long)value));
        };
        PropertiesSetter boolPropertiesSetter = (propertiesBuilder, keyValueCell, key, value) -> {
            propertiesBuilder.addBoolKeyIds(keyValueCell.keys.getId(key));
            propertiesBuilder.addBoolValues((Boolean)value);
        };
        PropertiesSetter stringPropertiesSetter = (propertiesBuilder, keyValueCell, key, value) -> {
            propertiesBuilder.addStringKeyIds(keyValueCell.keys.getId(key));
            propertiesBuilder.addStringValueIds(keyValueCell.stringValues.getId((String)value));
        };
        PropertiesSetter bytesPropertiesSetter = (propertiesBuilder, keyValueCell, key, value) -> {
            propertiesBuilder.addBytesKeyIds(keyValueCell.keys.getId(key));
            propertiesBuilder.addBytesValueIds(keyValueCell.bytesValues.getId((byte[])value));
        };
        Map.Entry[] entries = new Map.Entry[]{new AbstractMap.SimpleEntry<Class<Double>, PropertiesSetter>(Double.TYPE, doublePropertiesSetter), new AbstractMap.SimpleEntry<Class<Double>, PropertiesSetter>(Double.class, doublePropertiesSetter), new AbstractMap.SimpleEntry<Class<Float>, PropertiesSetter>(Float.TYPE, floatPropertiesSetter), new AbstractMap.SimpleEntry<Class<Float>, PropertiesSetter>(Float.class, floatPropertiesSetter), new AbstractMap.SimpleEntry<Class<Integer>, PropertiesSetter>(Integer.TYPE, sint32PropertiesSetter), new AbstractMap.SimpleEntry<Class<Integer>, PropertiesSetter>(Integer.class, sint32PropertiesSetter), new AbstractMap.SimpleEntry<Class<Long>, PropertiesSetter>(Long.TYPE, sint64PropertiesSetter), new AbstractMap.SimpleEntry<Class<Long>, PropertiesSetter>(Long.class, sint64PropertiesSetter), new AbstractMap.SimpleEntry<Class<Boolean>, PropertiesSetter>(Boolean.TYPE, boolPropertiesSetter), new AbstractMap.SimpleEntry<Class<Boolean>, PropertiesSetter>(Boolean.class, boolPropertiesSetter), new AbstractMap.SimpleEntry<Class<String>, PropertiesSetter>(String.class, stringPropertiesSetter), new AbstractMap.SimpleEntry<Class<byte[]>, PropertiesSetter>(byte[].class, bytesPropertiesSetter)};
        propertiesSetterMap = Map.ofEntries(entries);
    }

    private static final class FromProtoKeyValueCell {
        private final HashMap<Integer, String> keyMap;
        private final HashMap<Integer, Double> doubleValueMap;
        private final HashMap<Integer, Float> floatValueMap;
        private final HashMap<Integer, Integer> sint32ValueMap;
        private final HashMap<Integer, Long> sint64ValueMap;
        private final HashMap<Integer, String> stringValueMap;
        private final HashMap<Integer, byte[]> bytesMap;

        public FromProtoKeyValueCell(ProtoFeature.FeatureCollection pFeatureCollection) {
            int i;
            int n = pFeatureCollection.getKeysCount();
            this.keyMap = new HashMap(n);
            for (i = 0; i < n; ++i) {
                this.keyMap.put(i, pFeatureCollection.getKeys(i));
            }
            n = pFeatureCollection.getDoubleValuesCount();
            this.doubleValueMap = new HashMap(n);
            for (i = 0; i < n; ++i) {
                this.doubleValueMap.put(i, pFeatureCollection.getDoubleValues(i));
            }
            n = pFeatureCollection.getFloatValuesCount();
            this.floatValueMap = new HashMap(n);
            for (i = 0; i < n; ++i) {
                this.floatValueMap.put(i, Float.valueOf(pFeatureCollection.getFloatValues(i)));
            }
            n = pFeatureCollection.getSint32ValuesCount();
            this.sint32ValueMap = new HashMap(n);
            for (i = 0; i < n; ++i) {
                this.sint32ValueMap.put(i, pFeatureCollection.getSint32Values(i));
            }
            n = pFeatureCollection.getSint64ValuesCount();
            this.sint64ValueMap = new HashMap(n);
            for (i = 0; i < n; ++i) {
                this.sint64ValueMap.put(i, pFeatureCollection.getSint64Values(i));
            }
            n = pFeatureCollection.getStringValuesCount();
            this.stringValueMap = new HashMap(n);
            for (i = 0; i < n; ++i) {
                this.stringValueMap.put(i, pFeatureCollection.getStringValues(i));
            }
            n = pFeatureCollection.getBytesValuesCount();
            this.bytesMap = new HashMap(n);
            for (i = 0; i < n; ++i) {
                this.bytesMap.put(i, pFeatureCollection.getBytesValues(i).toByteArray());
            }
        }

        public Map<String, Object> parseProperties(ProtoFeature.Map pProperties) {
            Object value;
            String key;
            int i;
            int subKeyNum;
            int bytesKeyNum;
            int stringKeyNum;
            int boolKeyNum;
            int sint64KeyNum;
            int sint32KeyNum;
            int floatKeyNum;
            int doubleKeyNum = pProperties.getDoubleKeyIdsCount();
            int keyNum = doubleKeyNum + (floatKeyNum = pProperties.getFloatKeyIdsCount()) + (sint32KeyNum = pProperties.getSint32KeyIdsCount()) + (sint64KeyNum = pProperties.getSint64KeyIdsCount()) + (boolKeyNum = pProperties.getBoolKeyIdsCount()) + (stringKeyNum = pProperties.getStringKeyIdsCount()) + (bytesKeyNum = pProperties.getBytesKeyIdsCount()) + (subKeyNum = pProperties.getSubKeyIdsCount());
            if (keyNum == 0) {
                return null;
            }
            HashMap<String, Object> properties = new HashMap<String, Object>(keyNum);
            for (i = 0; i < doubleKeyNum; ++i) {
                key = this.keyMap.get(pProperties.getDoubleKeyIds(i));
                value = this.doubleValueMap.get(pProperties.getDoubleValueIds(i));
                properties.put(key, value);
            }
            for (i = 0; i < floatKeyNum; ++i) {
                key = this.keyMap.get(pProperties.getFloatKeyIds(i));
                value = this.floatValueMap.get(pProperties.getFloatValueIds(i));
                properties.put(key, value);
            }
            for (i = 0; i < sint32KeyNum; ++i) {
                key = this.keyMap.get(pProperties.getSint32KeyIds(i));
                value = this.sint32ValueMap.get(pProperties.getSint32ValueIds(i));
                properties.put(key, value);
            }
            for (i = 0; i < sint64KeyNum; ++i) {
                key = this.keyMap.get(pProperties.getSint64KeyIds(i));
                value = this.sint64ValueMap.get(pProperties.getSint64ValueIds(i));
                properties.put(key, value);
            }
            for (i = 0; i < stringKeyNum; ++i) {
                key = this.keyMap.get(pProperties.getStringKeyIds(i));
                value = this.stringValueMap.get(pProperties.getStringValueIds(i));
                properties.put(key, value);
            }
            for (i = 0; i < bytesKeyNum; ++i) {
                key = this.keyMap.get(pProperties.getBytesKeyIds(i));
                value = this.bytesMap.get(pProperties.getBytesValueIds(i));
                properties.put(key, value);
            }
            for (i = 0; i < boolKeyNum; ++i) {
                key = this.keyMap.get(pProperties.getBoolKeyIds(i));
                boolean value2 = pProperties.getBoolValues(i);
                properties.put(key, value2);
            }
            for (i = 0; i < subKeyNum; ++i) {
                ProtoFeature.Map subMap = pProperties.getSubMaps(i);
                Map<String, Object> sub = this.parseProperties(subMap);
                String key2 = this.keyMap.get(pProperties.getSubKeyIds(i));
                properties.put(key2, sub);
            }
            return properties;
        }
    }

    private static final class ToProtoKeyValueCell {
        private final Index<String> keys = new Index();
        private final Index<Double> doubleValues = new Index();
        private final Index<Float> floatValues = new Index();
        private final Index<Integer> sint32Values = new Index();
        private final Index<Long> sint64Values = new Index();
        private final Index<String> stringValues = new Index();
        private final Index<byte[]> bytesValues = new Index();

        private ToProtoKeyValueCell() {
        }

        public void toProto(ProtoFeature.FeatureCollection.Builder builder) {
            builder.addAllKeys(this.keys.toList());
            builder.addAllDoubleValues(this.doubleValues.toList());
            builder.addAllFloatValues(this.floatValues.toList());
            builder.addAllSint32Values(this.sint32Values.toList());
            builder.addAllSint64Values(this.sint64Values.toList());
            builder.addAllStringValues(this.stringValues.toList());
            ArrayList<SortT> sortList = new ArrayList<SortT>(this.bytesValues.indexMap.size());
            this.bytesValues.indexMap.forEach((t, id) -> sortList.add(new SortT<byte[]>((byte[])t, (int)id)));
            sortList.sort(Comparator.comparingInt(c -> c.id));
            ArrayList<ByteString> res = new ArrayList<ByteString>(this.bytesValues.indexMap.size());
            for (SortT sortT : sortList) {
                res.add(ByteString.copyFrom((byte[])((byte[])sortT.t)));
            }
            builder.addAllBytesValues(res);
        }

        private static final class SortT<T> {
            private final T t;
            private final int id;

            public SortT(T t, int id) {
                this.t = t;
                this.id = id;
            }
        }

        private static final class Index<T> {
            private int index = 0;
            private final HashMap<T, Integer> indexMap = new HashMap();

            private Index() {
            }

            public Integer getId(T t) {
                if (this.index < 0) {
                    throw new RuntimeException("\u503c\u6570\u91cf\u8d85\u8fc7\u4e0a\u9650 2147483647");
                }
                Integer id = this.indexMap.get(t);
                if (id != null) {
                    return id;
                }
                id = this.index;
                this.indexMap.put(t, id);
                ++this.index;
                return id;
            }

            public ArrayList<T> toList() {
                ArrayList<SortT> sortList = new ArrayList<SortT>(this.indexMap.size());
                this.indexMap.forEach((t, id) -> sortList.add(new SortT<Object>(t, (int)id)));
                sortList.sort(Comparator.comparingInt(c -> c.id));
                ArrayList res = new ArrayList(this.indexMap.size());
                for (SortT sortT : sortList) {
                    res.add(sortT.t);
                }
                return res;
            }
        }
    }

    @FunctionalInterface
    private static interface PropertiesSetter {
        public void set(ProtoFeature.Map.Builder var1, ToProtoKeyValueCell var2, String var3, Object var4);
    }

    private static final class ProtoCoordinateCell {
        private final ArrayList<Double> xs;
        private final ArrayList<Double> ys;
        private final ArrayList<Double> zs;

        public ProtoCoordinateCell(Coordinate[] coordinates) {
            if (Double.isNaN(coordinates[0].getZ())) {
                this.xs = new ArrayList();
                this.ys = new ArrayList();
                this.zs = null;
                for (Coordinate coordinate : coordinates) {
                    this.xs.add(coordinate.getX());
                    this.ys.add(coordinate.getY());
                }
            } else {
                this.xs = new ArrayList();
                this.ys = new ArrayList();
                this.zs = new ArrayList();
                for (Coordinate coordinate : coordinates) {
                    this.xs.add(coordinate.getX());
                    this.ys.add(coordinate.getY());
                    this.zs.add(coordinate.getZ());
                }
            }
        }
    }
}

