/*
 * Decompiled with CFR 0.152.
 */
package org.wowtools.giscat.vector.pojo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Map;
import org.locationtech.jts.geom.Coordinate;
import org.wowtools.giscat.vector.pojo.converter.GeoJsonFeatureConverter;

public class GeoJsonObject {
    private static double[][] jtsCoordinates2Coords(Coordinate[] coordinates) {
        double[][] coords = new double[coordinates.length][];
        for (int i = 0; i < coords.length; ++i) {
            Coordinate coordinate = coordinates[i];
            coords[i] = new double[]{coordinate.x, coordinate.y};
        }
        return coords;
    }

    private static double[][][] jtsPolygon2Coords(org.locationtech.jts.geom.Polygon jtsPolygon) {
        double[][][] coordinates;
        int numInteriorRing = jtsPolygon.getNumInteriorRing();
        if (numInteriorRing == 0) {
            coordinates = new double[][][]{GeoJsonObject.jtsCoordinates2Coords(jtsPolygon.getCoordinates())};
        } else {
            coordinates = new double[numInteriorRing + 1][][];
            coordinates[0] = GeoJsonObject.jtsCoordinates2Coords(jtsPolygon.getExteriorRing().getCoordinates());
            for (int i = 1; i < coordinates.length; ++i) {
                coordinates[i] = GeoJsonObject.jtsCoordinates2Coords(jtsPolygon.getInteriorRingN(i - 1).getCoordinates());
            }
        }
        return coordinates;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class FeatureCollection {
        private final String type = "FeatureCollection";
        private Feature[] features;

        @JsonIgnore
        public String toGeoJsonString() {
            String geoJson;
            try {
                geoJson = GeoJsonFeatureConverter.mapper.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("\u8f6cgeojson\u5b57\u7b26\u4e32\u5f02\u5e38", e);
            }
            return geoJson;
        }

        public void setFeatures(Feature[] features) {
            this.features = features;
        }

        public String getType() {
            return this.type;
        }

        public Feature[] getFeatures() {
            return this.features;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static final class Feature {
        private final String type = "Feature";
        private Geometry geometry;
        private Map<String, Object> properties;

        @JsonIgnore
        public String toGeoJsonString() {
            String geoJson;
            try {
                geoJson = GeoJsonFeatureConverter.mapper.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("\u8f6cgeojson\u5b57\u7b26\u4e32\u5f02\u5e38", e);
            }
            return geoJson;
        }

        public void setGeometry(Geometry geometry) {
            this.geometry = geometry;
        }

        public void setProperties(Map<String, Object> properties) {
            this.properties = properties;
        }

        public String getType() {
            return this.type;
        }

        public Geometry getGeometry() {
            return this.geometry;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }
    }

    public static final class GeometryCollection
    implements Geometry {
        private Geometry[] geometries;

        public GeometryCollection() {
        }

        public GeometryCollection(org.locationtech.jts.geom.GeometryCollection jtsGeometryCollection) {
            this.geometries = new Geometry[jtsGeometryCollection.getNumGeometries()];
            for (int i = 0; i < this.geometries.length; ++i) {
                org.locationtech.jts.geom.Geometry geometry = jtsGeometryCollection.getGeometryN(i);
                this.geometries[i] = GeoJsonFeatureConverter.geometry2GeoJson(geometry);
            }
        }

        @Override
        public String getType() {
            return "GeometryCollection";
        }

        public void setGeometries(Geometry[] geometries) {
            this.geometries = geometries;
        }

        public Geometry[] getGeometries() {
            return this.geometries;
        }
    }

    public static final class MultiPolygon
    implements Geometry {
        private double[][][][] coordinates;

        public MultiPolygon() {
        }

        public MultiPolygon(org.locationtech.jts.geom.MultiPolygon jtsMultiPolygon) {
            this.coordinates = new double[jtsMultiPolygon.getNumGeometries()][][][];
            for (int i = 0; i < this.coordinates.length; ++i) {
                this.coordinates[i] = GeoJsonObject.jtsPolygon2Coords((org.locationtech.jts.geom.Polygon)jtsMultiPolygon.getGeometryN(i));
            }
        }

        @Override
        public String getType() {
            return "MultiPolygon";
        }

        public void setCoordinates(double[][][][] coordinates) {
            this.coordinates = coordinates;
        }

        public double[][][][] getCoordinates() {
            return this.coordinates;
        }
    }

    public static final class MultiLineString
    implements Geometry {
        private double[][][] coordinates;

        public MultiLineString() {
        }

        public MultiLineString(org.locationtech.jts.geom.MultiLineString jtsMultiLineString) {
            this.coordinates = new double[jtsMultiLineString.getNumGeometries()][][];
            for (int i = 0; i < this.coordinates.length; ++i) {
                this.coordinates[i] = GeoJsonObject.jtsCoordinates2Coords(jtsMultiLineString.getGeometryN(i).getCoordinates());
            }
        }

        @Override
        public String getType() {
            return "MultiLineString";
        }

        public void setCoordinates(double[][][] coordinates) {
            this.coordinates = coordinates;
        }

        public double[][][] getCoordinates() {
            return this.coordinates;
        }
    }

    public static final class MultiPoint
    implements Geometry {
        private double[][] coordinates;

        public MultiPoint() {
        }

        public MultiPoint(org.locationtech.jts.geom.MultiPoint jtsMultiPoint) {
            this.coordinates = GeoJsonObject.jtsCoordinates2Coords(jtsMultiPoint.getCoordinates());
        }

        @Override
        public String getType() {
            return "MultiPoint";
        }

        public void setCoordinates(double[][] coordinates) {
            this.coordinates = coordinates;
        }

        public double[][] getCoordinates() {
            return this.coordinates;
        }
    }

    public static final class Polygon
    implements Geometry {
        private double[][][] coordinates;

        public Polygon() {
        }

        public Polygon(org.locationtech.jts.geom.Polygon jtsPolygon) {
            this.coordinates = GeoJsonObject.jtsPolygon2Coords(jtsPolygon);
        }

        @Override
        public String getType() {
            return "Polygon";
        }

        public void setCoordinates(double[][][] coordinates) {
            this.coordinates = coordinates;
        }

        public double[][][] getCoordinates() {
            return this.coordinates;
        }
    }

    public static final class LineString
    implements Geometry {
        private double[][] coordinates;

        @Override
        public String getType() {
            return "LineString";
        }

        public LineString() {
        }

        public LineString(org.locationtech.jts.geom.LineString jtsLineString) {
            this.coordinates = GeoJsonObject.jtsCoordinates2Coords(jtsLineString.getCoordinates());
        }

        public void setCoordinates(double[][] coordinates) {
            this.coordinates = coordinates;
        }

        public double[][] getCoordinates() {
            return this.coordinates;
        }
    }

    public static final class Point
    implements Geometry {
        private double[] coordinates;

        @Override
        public String getType() {
            return "Point";
        }

        public Point() {
        }

        public Point(org.locationtech.jts.geom.Point jtsPoint) {
            this.coordinates = new double[]{jtsPoint.getX(), jtsPoint.getY()};
        }

        public void setCoordinates(double[] coordinates) {
            this.coordinates = coordinates;
        }

        public double[] getCoordinates() {
            return this.coordinates;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=Point.class, name="Point"), @JsonSubTypes.Type(value=LineString.class, name="LineString"), @JsonSubTypes.Type(value=Polygon.class, name="Polygon"), @JsonSubTypes.Type(value=MultiPoint.class, name="MultiPoint"), @JsonSubTypes.Type(value=MultiLineString.class, name="MultiLineString"), @JsonSubTypes.Type(value=MultiPolygon.class, name="MultiPolygon"), @JsonSubTypes.Type(value=GeometryCollection.class, name="GeometryCollection")})
    public static interface Geometry {
        @JsonIgnore
        public String getType();

        @JsonIgnore
        default public String toGeoJsonString() {
            String geoJson;
            try {
                geoJson = GeoJsonFeatureConverter.mapper.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("\u8f6cgeojson\u5b57\u7b26\u4e32\u5f02\u5e38", e);
            }
            return geoJson;
        }
    }
}

