/*
 * Decompiled with CFR 0.152.
 */
package org.wowtools.giscat.vector.mvt;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;
import org.wowtools.giscat.util.analyse.Bbox;
import org.wowtools.giscat.vector.mvt.MvtBuilder;
import org.wowtools.giscat.vector.mvt.MvtFeature;
import org.wowtools.giscat.vector.pojo.Feature;

public final class MvtLayer {
    protected final List<MvtFeature> features = new ArrayList<MvtFeature>();
    private final Map<String, Integer> keys = new LinkedHashMap<String, Integer>();
    private final Map<Object, Integer> values = new LinkedHashMap<Object, Integer>();
    private final MvtBuilder mvtBuilder;
    private final double wgs84SimplifyDistance;

    protected MvtLayer(MvtBuilder mvtBuilder, int simplifyDistance) {
        this.mvtBuilder = mvtBuilder;
        if (simplifyDistance > 0) {
            Bbox bbox = mvtBuilder.getBbox();
            double d = Math.sqrt(Math.pow(bbox.xmax - bbox.xmin, 2.0) + Math.pow(bbox.ymax - bbox.ymin, 2.0)) / (double)mvtBuilder.extent;
            this.wgs84SimplifyDistance = (double)simplifyDistance * d;
        } else {
            this.wgs84SimplifyDistance = 0.0;
        }
    }

    public void addFeatures(Iterable<Feature> features) {
        for (Feature feature : features) {
            this.addFeature(feature);
        }
    }

    public void addClipedFeatures(Iterable<Feature> features) {
        for (Feature feature : features) {
            this.addClipedFeature(feature);
        }
    }

    public void addFeature(Feature feature) {
        Geometry clipedGeometry = this.clipGeometry(feature.getGeometry());
        this.addCipedGeometryAndAttributes(feature.getProperties(), clipedGeometry);
    }

    public void addClipedFeature(Feature feature) {
        this.addCipedGeometryAndAttributes(feature.getProperties(), feature.getGeometry());
    }

    public void addCipedGeometryAndAttributes(Map<String, ?> attributes, Geometry clipedGeometry) {
        if (null == clipedGeometry || clipedGeometry.isEmpty()) {
            return;
        }
        if (this.wgs84SimplifyDistance > 0.0) {
            clipedGeometry = TopologyPreservingSimplifier.simplify((Geometry)clipedGeometry, (double)this.wgs84SimplifyDistance);
        }
        ArrayList<Integer> tags = this.tags(attributes);
        LinkedList<Geometry> resolveGeometries = new LinkedList<Geometry>();
        this.resolveGeometryCollection(clipedGeometry, resolveGeometries);
        for (Geometry resolveGeometry : resolveGeometries) {
            this.addSampleGeometryFeature(tags, resolveGeometry);
        }
    }

    private void resolveGeometryCollection(Geometry geometry, List<Geometry> resolveGeometries) {
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            Geometry subGeometry = geometry.getGeometryN(i);
            if (subGeometry.getClass().equals(GeometryCollection.class)) {
                this.resolveGeometryCollection(subGeometry, resolveGeometries);
                continue;
            }
            resolveGeometries.add(subGeometry);
        }
    }

    private void addSampleGeometryFeature(ArrayList<Integer> tags, Geometry geometry) {
        MvtFeature feature = new MvtFeature();
        feature.geometry = geometry;
        feature.tags = tags;
        this.features.add(feature);
    }

    private ArrayList<Integer> tags(Map<String, ?> attributes) {
        if (null == attributes) {
            return null;
        }
        ArrayList<Integer> tags = new ArrayList<Integer>(attributes.size() * 2);
        for (Map.Entry<String, ?> e : attributes.entrySet()) {
            if (e.getValue() == null) continue;
            tags.add(this.key(e.getKey()));
            tags.add(this.value(e.getValue()));
        }
        return tags;
    }

    private Integer key(String key) {
        Integer i = this.keys.get(key);
        if (i == null) {
            i = this.keys.size();
            this.keys.put(key, i);
        }
        return i;
    }

    protected List<String> keys() {
        return new ArrayList<String>(this.keys.keySet());
    }

    private Integer value(Object value) {
        Integer i = this.values.get(value);
        if (i == null) {
            i = this.values.size();
            this.values.put(value, i);
        }
        return i;
    }

    protected List<Object> values() {
        return List.copyOf(this.values.keySet());
    }

    private Geometry clipGeometry(Geometry geometry) {
        try {
            return this.mvtBuilder.tileClip.intersection(geometry);
        }
        catch (TopologyException e) {
            geometry = geometry.buffer(0.0);
            return this.mvtBuilder.tileClip.intersection(geometry);
        }
    }
}

