/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.util.thread;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import wiremock.org.eclipse.jetty.util.MemoryUtils;
import wiremock.org.eclipse.jetty.util.ProcessorUtils;
import wiremock.org.eclipse.jetty.util.TypeUtil;
import wiremock.org.eclipse.jetty.util.component.Dumpable;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class ThreadIdPool<E>
implements Dumpable {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadIdPool.class);
    private static final int SPREAD_FACTOR = MemoryUtils.getReferencesPerCacheLine();
    private final int _capacity;
    private final AtomicReferenceArray<E> _items;

    public ThreadIdPool() {
        this(-1);
    }

    public ThreadIdPool(int capacity) {
        this._capacity = ThreadIdPool.calcCapacity(capacity);
        this._items = new AtomicReferenceArray((this._capacity + 1) * SPREAD_FACTOR);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}", (Object)this);
        }
    }

    private static int calcCapacity(int capacity) {
        if (capacity >= 0) {
            return capacity;
        }
        return 2 * TypeUtil.ceilToNextPowerOfTwo(ProcessorUtils.availableProcessors());
    }

    private static int toSlot(int index) {
        return (index + 1) * SPREAD_FACTOR;
    }

    public int capacity() {
        return this._capacity;
    }

    public int size() {
        int available = 0;
        for (int i = 0; i < this.capacity(); ++i) {
            if (this._items.getPlain(ThreadIdPool.toSlot(i)) == null) continue;
            ++available;
        }
        return available;
    }

    public int offer(E e) {
        int capacity = this.capacity();
        if (capacity > 0) {
            int index = (int)(Thread.currentThread().getId() % (long)capacity);
            for (int i = 0; i < capacity; ++i) {
                if (this._items.compareAndSet(ThreadIdPool.toSlot(index), null, e)) {
                    return index;
                }
                if (++index != capacity) continue;
                index = 0;
            }
        }
        return -1;
    }

    public E take() {
        int capacity = this.capacity();
        if (capacity == 0) {
            return null;
        }
        int index = (int)(Thread.currentThread().getId() % (long)capacity);
        for (int i = 0; i < capacity; ++i) {
            E e = this._items.getAndSet(ThreadIdPool.toSlot(index), null);
            if (e != null) {
                return e;
            }
            if (++index != capacity) continue;
            index = 0;
        }
        return null;
    }

    public boolean remove(E e, int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this._items.compareAndSet(ThreadIdPool.toSlot(index), e, null);
    }

    public List<E> removeAll() {
        int capacity = this.capacity();
        ArrayList<Object> all = new ArrayList<Object>(capacity);
        for (int i = 0; i < capacity; ++i) {
            Object e = this._items.getAndSet(ThreadIdPool.toSlot(i), null);
            if (e == null) continue;
            all.add(e);
        }
        return all;
    }

    public E takeOrElse(Supplier<E> supplier) {
        E e = this.take();
        return e == null ? supplier.get() : e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R apply(Supplier<E> supplier, Function<E, R> function) {
        E e = this.takeOrElse(supplier);
        try {
            R r = function.apply(e);
            return r;
        }
        finally {
            this.offer(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A, R> R apply(Supplier<E> supplier, BiFunction<E, A, R> function, A argument) {
        E e = this.takeOrElse(supplier);
        try {
            R r = function.apply(e, argument);
            return r;
        }
        finally {
            this.offer(e);
        }
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        int capacity = this.capacity();
        ArrayList<Dumpable> slots = new ArrayList<Dumpable>(capacity);
        for (int i = 0; i < capacity; ++i) {
            E slot = this._items.get(ThreadIdPool.toSlot(i));
            if (slot == null) continue;
            slots.add(Dumpable.named(Integer.toString(i), slot));
        }
        Dumpable.dumpObjects(out, indent, this, slots.toArray());
    }

    public String toString() {
        return String.format("%s@%x{capacity=%d}", this.getClass().getSimpleName(), this.hashCode(), this.capacity());
    }
}

