/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.util.resource;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import wiremock.org.eclipse.jetty.util.IO;
import wiremock.org.eclipse.jetty.util.Index;
import wiremock.org.eclipse.jetty.util.StringUtil;
import wiremock.org.eclipse.jetty.util.URIUtil;
import wiremock.org.eclipse.jetty.util.component.AbstractLifeCycle;
import wiremock.org.eclipse.jetty.util.component.Dumpable;
import wiremock.org.eclipse.jetty.util.component.DumpableCollection;
import wiremock.org.eclipse.jetty.util.resource.FileSystemPool;
import wiremock.org.eclipse.jetty.util.resource.GraalIssue5720PathResource;
import wiremock.org.eclipse.jetty.util.resource.GraalIssue5720PathResourceFactory;
import wiremock.org.eclipse.jetty.util.resource.MountedPathResourceFactory;
import wiremock.org.eclipse.jetty.util.resource.PathResourceFactory;
import wiremock.org.eclipse.jetty.util.resource.Resource;
import wiremock.org.eclipse.jetty.util.resource.ResourceFactory;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

class ResourceFactoryInternals {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceFactoryInternals.class);
    private static final Path CURRENT_WORKING_DIR;
    static final Index.Mutable<ResourceFactory> RESOURCE_FACTORIES;
    static ResourceFactory ROOT;

    ResourceFactoryInternals() {
    }

    static boolean isSupported(URI uri) {
        if (uri == null || uri.getScheme() == null) {
            return false;
        }
        return RESOURCE_FACTORIES.get(uri.getScheme()) != null;
    }

    static boolean isSupported(String str) {
        if (StringUtil.isBlank(str)) {
            return false;
        }
        return RESOURCE_FACTORIES.getBest(str) != null;
    }

    static {
        RESOURCE_FACTORIES = new Index.Builder().caseSensitive(false).mutable().build();
        CURRENT_WORKING_DIR = Path.of(System.getProperty("user.dir"), new String[0]);
        MountedPathResourceFactory mountedPathResourceFactory = new MountedPathResourceFactory();
        RESOURCE_FACTORIES.put("jar", mountedPathResourceFactory);
        PathResourceFactory pathResourceFactory = new PathResourceFactory();
        RESOURCE_FACTORIES.put("file", pathResourceFactory);
        RESOURCE_FACTORIES.put("jrt", pathResourceFactory);
        URL url = ResourceFactoryInternals.class.getResource("/wiremock/org/eclipse/jetty/version/build.properties");
        if (url != null && !RESOURCE_FACTORIES.contains(url.getProtocol())) {
            ResourceFactory resourceFactory = GraalIssue5720PathResource.isAffectedURL(url) ? new GraalIssue5720PathResourceFactory() : (url.toString().contains("!/") ? mountedPathResourceFactory : pathResourceFactory);
            RESOURCE_FACTORIES.put(url.getProtocol(), resourceFactory);
        }
        ROOT = new CompositeResourceFactory(){

            @Override
            protected void onMounted(FileSystemPool.Mount mount, URI uri) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Leaked {} for {}", mount, uri, new Throwable());
                } else {
                    LOG.warn("Leaked {} for {}", (Object)mount, (Object)uri);
                }
            }
        };
    }

    static class CompositeResourceFactory
    implements ResourceFactory {
        private final List<FileSystemPool.Mount> _mounts = new CopyOnWriteArrayList<FileSystemPool.Mount>();

        CompositeResourceFactory() {
        }

        @Override
        public Resource newResource(URI uri) {
            if (uri == null) {
                return null;
            }
            try {
                FileSystemPool.Mount mount;
                ResourceFactory resourceFactory;
                if (!uri.isAbsolute()) {
                    uri = uri.toString().startsWith("/") ? new URI("file", uri.toString(), null) : CURRENT_WORKING_DIR.toUri().resolve(uri);
                    uri = URIUtil.correctURI(uri);
                }
                if ((resourceFactory = (ResourceFactory)RESOURCE_FACTORIES.get(uri.getScheme())) == null) {
                    throw new IllegalArgumentException("URI scheme not registered: " + uri.getScheme());
                }
                if (resourceFactory instanceof MountedPathResourceFactory && (mount = this.mountIfNeeded(uri)) != null) {
                    this._mounts.add(mount);
                    this.onMounted(mount, uri);
                }
                return resourceFactory.newResource(uri);
            }
            catch (URISyntaxException | ProviderNotFoundException ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Unable to create resource from: {}", (Object)uri, (Object)ex);
                }
                throw new IllegalArgumentException("Unable to create resource", ex);
            }
        }

        private FileSystemPool.Mount mountIfNeeded(URI uri) {
            String scheme = uri.getScheme();
            if (!"jar".equalsIgnoreCase(scheme)) {
                return null;
            }
            String uriString = uri.toASCIIString();
            for (FileSystemPool.Mount mount : this._mounts) {
                if (!uriString.startsWith(mount.root().toString())) continue;
                return null;
            }
            try {
                return FileSystemPool.INSTANCE.mount(uri);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Unable to mount: " + String.valueOf(uri), ioe);
            }
        }

        protected void onMounted(FileSystemPool.Mount mount, URI uri) {
        }

        public List<FileSystemPool.Mount> getMounts() {
            return this._mounts;
        }

        public void clearMounts() {
            this._mounts.clear();
        }
    }

    static class LifeCycle
    extends AbstractLifeCycle
    implements ResourceFactory.LifeCycle {
        private final CompositeResourceFactory _compositeResourceFactory = new CompositeResourceFactory();

        LifeCycle() {
        }

        @Override
        public Resource newResource(URI uri) {
            return this._compositeResourceFactory.newResource(uri);
        }

        @Override
        protected void doStop() throws Exception {
            for (FileSystemPool.Mount mount : this._compositeResourceFactory.getMounts()) {
                IO.close(mount);
            }
            this._compositeResourceFactory.clearMounts();
            super.doStop();
        }

        @Override
        public void dump(Appendable out, String indent) throws IOException {
            List<URI> referencedUris = this._compositeResourceFactory.getMounts().stream().map(mount -> mount.root().getURI()).toList();
            Dumpable.dumpObjects(out, indent, this, new DumpableCollection("newResourceReferences", referencedUris));
        }
    }

    static class Closeable
    implements ResourceFactory.Closeable,
    Tracking {
        private boolean closed = false;
        private final CompositeResourceFactory _compositeResourceFactory = new CompositeResourceFactory();

        Closeable() {
        }

        @Override
        public Resource newResource(URI uri) {
            if (this.closed) {
                throw new IllegalStateException("Unable to create new Resource on closed ResourceFactory");
            }
            return this._compositeResourceFactory.newResource(uri);
        }

        @Override
        public void close() {
            this.closed = true;
            for (FileSystemPool.Mount mount : this._compositeResourceFactory.getMounts()) {
                IO.close(mount);
            }
            this._compositeResourceFactory.clearMounts();
        }

        @Override
        public int getTrackingCount() {
            return this._compositeResourceFactory.getMounts().size();
        }
    }

    static interface Tracking {
        public int getTrackingCount();
    }
}

