/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.util;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import wiremock.org.eclipse.jetty.util.thread.Invocable;
import wiremock.org.slf4j.LoggerFactory;

public interface Promise<C> {
    public static final Promise<Object> NOOP = new Promise<Object>(){};

    public static <T> Promise<T> noop() {
        return NOOP;
    }

    default public void succeeded(C result) {
    }

    default public void failed(Throwable x) {
    }

    default public void completeWith(CompletableFuture<C> completable) {
        completable.whenComplete((o, x) -> {
            if (x == null) {
                this.succeeded(o);
            } else {
                this.failed((Throwable)x);
            }
        });
    }

    public static <T> Promise<T> from(final Consumer<T> success, final Consumer<Throwable> failure) {
        return new Promise<T>(){

            @Override
            public void succeeded(T result) {
                success.accept(result);
            }

            @Override
            public void failed(Throwable x) {
                failure.accept(x);
            }
        };
    }

    public static <T> Promise<T> from(final CompletableFuture<? super T> completable) {
        if (completable instanceof Promise) {
            return (Promise)((Object)completable);
        }
        return new Promise<T>(){

            @Override
            public void succeeded(T result) {
                completable.complete(result);
            }

            @Override
            public void failed(Throwable x) {
                completable.completeExceptionally(x);
            }
        };
    }

    public static <C> Invocable<C> from(final Invocable.InvocationType invocationType, final Promise<C> promise) {
        return new Invocable<C>(){

            @Override
            public Invocable.InvocationType getInvocationType() {
                return invocationType;
            }

            @Override
            public void succeeded(C result) {
                promise.succeeded(result);
            }

            @Override
            public void failed(Throwable x) {
                promise.failed(x);
            }
        };
    }

    public static <C> Invocable<C> from(final Executor executor, final Promise<C> promise) {
        Objects.requireNonNull(executor);
        return new Invocable<C>(){

            @Override
            public Invocable.InvocationType getInvocationType() {
                return Invocable.InvocationType.NON_BLOCKING;
            }

            @Override
            public void succeeded(C result) {
                executor.execute(() -> promise.succeeded(result));
            }

            @Override
            public void failed(Throwable x) {
                executor.execute(() -> promise.failed(x));
            }
        };
    }

    public static abstract class Task<T>
    implements Promise<T>,
    Runnable {
        private final Runnable onSuccess;
        private final Consumer<Throwable> onFailure;

        public Task() {
            this.onSuccess = null;
            this.onFailure = null;
        }

        public Task(Runnable onSuccess, Consumer<Throwable> onFailure) {
            this.onSuccess = Objects.requireNonNull(onSuccess);
            this.onFailure = Objects.requireNonNull(onFailure);
        }

        @Override
        public void succeeded(T result) {
            if (this.onSuccess != null) {
                this.onSuccess.run();
            }
        }

        @Override
        public void failed(Throwable x) {
            if (this.onFailure != null) {
                this.onFailure.accept(x);
            }
        }
    }

    public static interface Invocable<R>
    extends wiremock.org.eclipse.jetty.util.thread.Invocable,
    Promise<R>,
    BiConsumer<R, Throwable> {
        @Override
        default public void accept(R result, Throwable error) {
            if (error != null) {
                this.failed(error);
            } else {
                this.succeeded(result);
            }
        }
    }

    public static class Wrapper<W>
    implements Promise<W> {
        private final Promise<W> promise;

        public Wrapper(Promise<W> promise) {
            this.promise = Objects.requireNonNull(promise);
        }

        @Override
        public void succeeded(W result) {
            this.promise.succeeded(result);
        }

        @Override
        public void failed(Throwable x) {
            this.promise.failed(x);
        }

        public Promise<W> getPromise() {
            return this.promise;
        }

        public Promise<W> unwrap() {
            Promise<W> result = this.promise;
            while (result instanceof Wrapper) {
                result = ((Wrapper)result).unwrap();
            }
            return result;
        }
    }

    public static class Completable<S>
    extends CompletableFuture<S>
    implements Promise<S> {
        public static <R> Completable<R> with(Consumer<Promise<R>> consumer) {
            Completable completable = new Completable();
            consumer.accept(completable);
            return completable;
        }

        @Override
        public void succeeded(S result) {
            this.complete(result);
        }

        @Override
        public void failed(Throwable x) {
            this.completeExceptionally(x);
        }
    }

    public static class Adapter<U>
    implements Promise<U> {
        @Override
        public void failed(Throwable x) {
            LoggerFactory.getLogger(this.getClass()).warn("Failed", x);
        }
    }
}

