/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.util;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Stream;
import wiremock.org.eclipse.jetty.util.annotation.ManagedAttribute;
import wiremock.org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject
public interface Pool<P> {
    public Entry<P> reserve();

    public Entry<P> acquire();

    default public Entry<P> acquire(Function<Entry<P>, P> creator) {
        P value;
        Entry<P> entry = this.acquire();
        if (entry != null) {
            return entry;
        }
        entry = this.reserve();
        if (entry == null) {
            return null;
        }
        try {
            value = creator.apply(entry);
        }
        catch (Throwable th) {
            entry.remove();
            throw th;
        }
        if (value == null) {
            entry.remove();
            return null;
        }
        return entry.enable(value, true) ? entry : null;
    }

    public boolean isTerminated();

    public Collection<Entry<P>> terminate();

    @ManagedAttribute(value="The number of entries")
    public int size();

    @ManagedAttribute(value="The maximum number of entries")
    public int getMaxSize();

    public Stream<Entry<P>> stream();

    @ManagedAttribute(value="The number of reserved entries")
    default public int getReservedCount() {
        return (int)this.stream().filter(Entry::isReserved).count();
    }

    @ManagedAttribute(value="The number of idle entries")
    default public int getIdleCount() {
        return (int)this.stream().filter(Entry::isIdle).count();
    }

    @ManagedAttribute(value="The number of in-use entries")
    default public int getInUseCount() {
        return (int)this.stream().filter(Entry::isInUse).count();
    }

    @ManagedAttribute(value="The number of terminated entries")
    default public int getTerminatedCount() {
        return (int)this.stream().filter(Entry::isTerminated).count();
    }

    public static interface Entry<E> {
        public boolean enable(E var1, boolean var2);

        public E getPooled();

        public boolean release();

        public boolean remove();

        public boolean isReserved();

        public boolean isIdle();

        public boolean isInUse();

        public boolean isTerminated();

        public static class Wrapper<W>
        implements Entry<W> {
            private final Entry<W> wrapped;

            public Wrapper(Entry<W> wrapped) {
                this.wrapped = wrapped;
            }

            public Entry<W> getWrapped() {
                return this.wrapped;
            }

            @Override
            public boolean enable(W pooled, boolean acquire) {
                return this.getWrapped().enable(pooled, acquire);
            }

            @Override
            public W getPooled() {
                return this.getWrapped().getPooled();
            }

            @Override
            public boolean release() {
                return this.getWrapped().release();
            }

            @Override
            public boolean remove() {
                return this.getWrapped().remove();
            }

            @Override
            public boolean isReserved() {
                return this.getWrapped().isReserved();
            }

            @Override
            public boolean isIdle() {
                return this.getWrapped().isIdle();
            }

            @Override
            public boolean isInUse() {
                return this.getWrapped().isInUse();
            }

            @Override
            public boolean isTerminated() {
                return this.getWrapped().isTerminated();
            }
        }
    }

    public static interface Factory<F> {
        public Pool<F> newPool();

        default public Pool<F> wrap(Pool<F> pool) {
            return pool;
        }
    }

    public static class Wrapper<W>
    implements Pool<W> {
        private final Pool<W> wrapped;

        public Wrapper(Pool<W> wrapped) {
            this.wrapped = wrapped;
        }

        public Pool<W> getWrapped() {
            return this.wrapped;
        }

        @Override
        public Entry<W> reserve() {
            return this.getWrapped().reserve();
        }

        @Override
        public Entry<W> acquire() {
            return this.getWrapped().acquire();
        }

        @Override
        public Entry<W> acquire(Function<Entry<W>, W> creator) {
            return this.getWrapped().acquire(creator);
        }

        @Override
        public boolean isTerminated() {
            return this.getWrapped().isTerminated();
        }

        @Override
        public Collection<Entry<W>> terminate() {
            return this.getWrapped().terminate();
        }

        @Override
        public int size() {
            return this.getWrapped().size();
        }

        @Override
        public int getMaxSize() {
            return this.getWrapped().getMaxSize();
        }

        @Override
        public Stream<Entry<W>> stream() {
            return this.getWrapped().stream();
        }

        @Override
        public int getReservedCount() {
            return this.getWrapped().getReservedCount();
        }

        @Override
        public int getIdleCount() {
            return this.getWrapped().getIdleCount();
        }

        @Override
        public int getInUseCount() {
            return this.getWrapped().getInUseCount();
        }

        @Override
        public int getTerminatedCount() {
            return this.getWrapped().getTerminatedCount();
        }
    }
}

