/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.session;

import java.util.function.Function;
import wiremock.org.eclipse.jetty.server.Session;
import wiremock.org.eclipse.jetty.session.AbstractSessionCache;
import wiremock.org.eclipse.jetty.session.ManagedSession;
import wiremock.org.eclipse.jetty.session.SessionData;
import wiremock.org.eclipse.jetty.session.SessionManager;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class NullSessionCache
extends AbstractSessionCache {
    private static final Logger LOG = LoggerFactory.getLogger(NullSessionCache.class);

    public NullSessionCache(SessionManager manager) {
        super(manager);
        super.setEvictionPolicy(0);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public ManagedSession newSession(SessionData data) {
        return new ManagedSession(this.getSessionManager(), data);
    }

    @Override
    public ManagedSession doGet(String id) {
        return null;
    }

    @Override
    public Session doPutIfAbsent(String id, ManagedSession session) {
        return null;
    }

    @Override
    public boolean doReplace(String id, ManagedSession oldValue, ManagedSession newValue) {
        return true;
    }

    @Override
    public ManagedSession doDelete(String id) {
        return null;
    }

    @Override
    public void setEvictionPolicy(int evictionTimeout) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring eviction setting: {}", (Object)evictionTimeout);
        }
    }

    @Override
    protected ManagedSession doComputeIfAbsent(String id, Function<String, ManagedSession> mappingFunction) {
        return mappingFunction.apply(id);
    }
}

