/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.server.handler.gzip;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritePendingException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import wiremock.org.eclipse.jetty.http.CompressedContentFormat;
import wiremock.org.eclipse.jetty.http.HttpField;
import wiremock.org.eclipse.jetty.http.HttpFields;
import wiremock.org.eclipse.jetty.http.HttpHeader;
import wiremock.org.eclipse.jetty.io.RetainableByteBuffer;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.Response;
import wiremock.org.eclipse.jetty.server.handler.gzip.GzipFactory;
import wiremock.org.eclipse.jetty.server.handler.gzip.GzipHandler;
import wiremock.org.eclipse.jetty.server.handler.gzip.GzipRequest;
import wiremock.org.eclipse.jetty.util.BufferUtil;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.IteratingCallback;
import wiremock.org.eclipse.jetty.util.IteratingNestedCallback;
import wiremock.org.eclipse.jetty.util.compression.CompressionPool;
import wiremock.org.eclipse.jetty.util.thread.Invocable;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class GzipResponseAndCallback
extends Response.Wrapper
implements Callback,
Invocable {
    private static final Logger LOG = LoggerFactory.getLogger(GzipResponseAndCallback.class);
    private static final byte OS_UNKNOWN = -1;
    private static final byte[] GZIP_HEADER = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, -1};
    private static final int GZIP_TRAILER_SIZE = 8;
    private final AtomicReference<GZState> _state = new AtomicReference<GZState>(GZState.MIGHT_COMPRESS);
    private final CRC32 _crc = new CRC32();
    private final Callback _callback;
    private final GzipFactory _factory;
    private final int _bufferSize;
    private final boolean _syncFlush;
    private CompressionPool.Entry _deflaterEntry;
    private RetainableByteBuffer _buffer;
    private boolean _last;

    public GzipResponseAndCallback(GzipHandler handler, Request request, Response response, Callback callback) {
        super(request, response);
        this._callback = callback;
        this._factory = handler;
        this._bufferSize = Math.max(GZIP_HEADER.length + 8, request.getConnectionMetaData().getHttpConfiguration().getOutputBufferSize());
        this._syncFlush = handler.isSyncFlush();
    }

    @Override
    public void succeeded() {
        try {
            if (this._last) {
                this._callback.succeeded();
            } else {
                this.write(true, null, this._callback);
            }
        }
        finally {
            Request request = this.getRequest();
            if (request instanceof GzipRequest) {
                GzipRequest gzipRequest = (GzipRequest)request;
                gzipRequest.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(Throwable x) {
        try {
            this._callback.failed(x);
        }
        finally {
            Request request = this.getRequest();
            if (request instanceof GzipRequest) {
                GzipRequest gzipRequest = (GzipRequest)request;
                gzipRequest.destroy();
            }
        }
    }

    @Override
    public Invocable.InvocationType getInvocationType() {
        return this._callback.getInvocationType();
    }

    @Override
    public void write(boolean last, ByteBuffer content, Callback callback) {
        this._last = last;
        switch (this._state.get().ordinal()) {
            case 0: {
                this.commit(last, callback, content);
                break;
            }
            case 1: {
                super.write(last, content, callback);
                break;
            }
            case 2: {
                callback.failed(new WritePendingException());
                break;
            }
            case 3: {
                this.gzip(last, callback, content);
                break;
            }
            default: {
                if (BufferUtil.isEmpty(content)) {
                    callback.succeeded();
                    break;
                }
                callback.failed(new IllegalStateException("state=" + String.valueOf((Object)this._state.get())));
            }
        }
    }

    private void addTrailer(ByteBuffer outputBuffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("addTrailer: _crc={}, _totalIn={})", (Object)this._crc.getValue(), (Object)((Deflater)this._deflaterEntry.get()).getTotalIn());
        }
        outputBuffer.putInt((int)this._crc.getValue());
        outputBuffer.putInt(((Deflater)this._deflaterEntry.get()).getTotalIn());
    }

    private void gzip(boolean complete, Callback callback, ByteBuffer content) {
        if (content != null || complete) {
            new GzipBufferCB(complete, callback, content).iterate();
        } else {
            callback.succeeded();
        }
    }

    protected void commit(boolean last, Callback callback, ByteBuffer content) {
        String baseType;
        if (LOG.isDebugEnabled()) {
            LOG.debug("commit(last={}, callback={}, content={})", last, callback, BufferUtil.toDetailString(content));
        }
        Request request = this.getRequest();
        GzipResponseAndCallback response = this;
        HttpFields.Mutable fields = response.getHeaders();
        int sc = response.getStatus();
        if (sc > 0 && (sc < 200 || sc == 204 || sc == 205 || sc >= 300)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} exclude by status {}", (Object)this, (Object)sc);
            }
            this.noCompression();
            if (sc == 304) {
                String responseEtagGzip;
                String requestEtags = (String)request.getAttribute("o.e.j.s.h.gzip.GzipHandler.etag");
                String responseEtag = fields.get(HttpHeader.ETAG);
                if (requestEtags != null && responseEtag != null && requestEtags.contains(responseEtagGzip = this.etagGzip(responseEtag))) {
                    fields.put(HttpHeader.ETAG, responseEtagGzip);
                }
            }
            super.write(last, content, callback);
            return;
        }
        String ct = fields.get(HttpHeader.CONTENT_TYPE);
        if (ct != null && !this._factory.isMimeTypeDeflatable(baseType = HttpField.getValueParameters(ct, null))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} exclude by mimeType {}", (Object)this, (Object)ct);
            }
            this.noCompression();
            super.write(last, content, callback);
            return;
        }
        String ce = fields.get(HttpHeader.CONTENT_ENCODING);
        if (ce != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} exclude by content-encoding {}", (Object)this, (Object)ce);
            }
            this.noCompression();
            super.write(last, content, callback);
            return;
        }
        if (last && BufferUtil.isEmpty(content)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} exclude by nothing to write", (Object)this);
            }
            this.noCompression();
            super.write(true, content, callback);
            return;
        }
        if (this._state.compareAndSet(GZState.MIGHT_COMPRESS, GZState.COMMITTING)) {
            long contentLength = fields.getLongField(HttpHeader.CONTENT_LENGTH);
            if (contentLength < 0L && last) {
                contentLength = BufferUtil.length(content);
            }
            this._deflaterEntry = this._factory.getDeflaterEntry(request, contentLength);
            if (this._deflaterEntry == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} exclude no deflater", (Object)this);
                }
                this._state.set(GZState.NOT_COMPRESSING);
                super.write(last, content, callback);
                return;
            }
            fields.put(CompressedContentFormat.GZIP.getContentEncoding());
            this._crc.reset();
            fields.remove(HttpHeader.CONTENT_LENGTH);
            String etag = fields.get(HttpHeader.ETAG);
            if (etag != null) {
                fields.put(HttpHeader.ETAG, this.etagGzip(etag));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} compressing {}", (Object)this, (Object)this._deflaterEntry);
            }
            this._state.set(GZState.COMPRESSING);
            if (BufferUtil.isEmpty(content)) {
                super.write(last, content, callback);
            } else {
                this.gzip(last, callback, content);
            }
        } else {
            callback.failed(new WritePendingException());
        }
    }

    private String etagGzip(String etag) {
        return CompressedContentFormat.GZIP.etag(etag);
    }

    public void noCompression() {
        block4: while (true) {
            switch (this._state.get().ordinal()) {
                case 1: {
                    return;
                }
                case 0: {
                    if (!this._state.compareAndSet(GZState.MIGHT_COMPRESS, GZState.NOT_COMPRESSING)) continue block4;
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException(this._state.get().toString());
    }

    private static enum GZState {
        MIGHT_COMPRESS,
        NOT_COMPRESSING,
        COMMITTING,
        COMPRESSING,
        FINISHING,
        FINISHED;

    }

    private class GzipBufferCB
    extends IteratingNestedCallback {
        private final ByteBuffer _content;
        private final boolean _last;

        public GzipBufferCB(boolean complete, Callback callback, ByteBuffer content) {
            super(callback);
            this._content = content;
            this._last = complete;
            if (this._content != null) {
                GzipResponseAndCallback.this._crc.update(this._content.slice());
                Deflater deflater = (Deflater)GzipResponseAndCallback.this._deflaterEntry.get();
                deflater.setInput(this._content);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("GzipBufferCB(complete={}, callback={}, content={})", complete, callback, BufferUtil.toDetailString(content));
            }
        }

        @Override
        protected void onCompleteFailure(Throwable x) {
            this.cleanup();
            super.onCompleteFailure(x);
        }

        @Override
        protected IteratingCallback.Action process() throws Exception {
            GZState gzstate;
            if (LOG.isDebugEnabled()) {
                LOG.debug("GzipBufferCB.process(): _last={}, _buffer={}, _content={}", this._last, GzipResponseAndCallback.this._buffer, BufferUtil.toDetailString(this._content));
            }
            if ((gzstate = GzipResponseAndCallback.this._state.get()) == GZState.FINISHED) {
                this.cleanup();
                return IteratingCallback.Action.SUCCEEDED;
            }
            if (GzipResponseAndCallback.this._buffer == null) {
                GzipResponseAndCallback.this._buffer = GzipResponseAndCallback.this.getRequest().getComponents().getByteBufferPool().acquire(GzipResponseAndCallback.this._bufferSize, false);
                ByteBuffer byteBuffer = GzipResponseAndCallback.this._buffer.getByteBuffer();
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                BufferUtil.flipToFill(byteBuffer);
                byteBuffer.put(GZIP_HEADER, 0, GZIP_HEADER.length);
            } else {
                BufferUtil.clearToFill(GzipResponseAndCallback.this._buffer.getByteBuffer());
            }
            Deflater deflater = (Deflater)GzipResponseAndCallback.this._deflaterEntry.get();
            return switch (gzstate.ordinal()) {
                case 3 -> this.compressing(deflater, GzipResponseAndCallback.this._buffer.getByteBuffer());
                case 4 -> this.finishing(deflater, GzipResponseAndCallback.this._buffer.getByteBuffer());
                default -> throw new IllegalStateException("Unexpected state [" + String.valueOf((Object)GzipResponseAndCallback.this._state.get()) + "]");
            };
        }

        private void cleanup() {
            if (GzipResponseAndCallback.this._deflaterEntry != null) {
                GzipResponseAndCallback.this._state.set(GZState.FINISHED);
                GzipResponseAndCallback.this._deflaterEntry.release();
                GzipResponseAndCallback.this._deflaterEntry = null;
            }
            if (GzipResponseAndCallback.this._buffer != null) {
                GzipResponseAndCallback.this._buffer.release();
                GzipResponseAndCallback.this._buffer = null;
            }
        }

        private int getFlushMode() {
            return GzipResponseAndCallback.this._syncFlush ? 2 : 0;
        }

        private IteratingCallback.Action compressing(Deflater deflater, ByteBuffer outputBuffer) {
            int len;
            if (LOG.isDebugEnabled()) {
                LOG.debug("compressing() deflater={}, outputBuffer={}", (Object)deflater, (Object)BufferUtil.toDetailString(outputBuffer));
            }
            if (!deflater.finished() && !deflater.needsInput() && (len = deflater.deflate(outputBuffer, this.getFlushMode())) > 0) {
                BufferUtil.flipToFlush(outputBuffer, 0);
                this.write(false, outputBuffer);
                return IteratingCallback.Action.SCHEDULED;
            }
            if (this._last) {
                GzipResponseAndCallback.this._state.set(GZState.FINISHING);
                deflater.finish();
                return this.finishing(deflater, outputBuffer);
            }
            BufferUtil.flipToFlush(outputBuffer, 0);
            if (outputBuffer.hasRemaining()) {
                this.write(false, outputBuffer);
                return IteratingCallback.Action.SCHEDULED;
            }
            if (BufferUtil.isEmpty(this._content)) {
                return IteratingCallback.Action.SUCCEEDED;
            }
            throw new AssertionError((Object)("No progress on deflate made for " + String.valueOf(this)));
        }

        private IteratingCallback.Action finishing(Deflater deflater, ByteBuffer outputBuffer) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("finishing() deflater={}, outputBuffer={}", (Object)deflater, (Object)BufferUtil.toDetailString(outputBuffer));
            }
            if (!deflater.finished()) {
                int len = deflater.deflate(outputBuffer, this.getFlushMode());
                if (deflater.finished() && outputBuffer.remaining() >= 8) {
                    GzipResponseAndCallback.this._state.set(GZState.FINISHED);
                    GzipResponseAndCallback.this.addTrailer(outputBuffer);
                    BufferUtil.flipToFlush(outputBuffer, 0);
                    this.write(true, outputBuffer);
                    return IteratingCallback.Action.SCHEDULED;
                }
                if (len > 0) {
                    BufferUtil.flipToFlush(outputBuffer, 0);
                    this.write(false, outputBuffer);
                    return IteratingCallback.Action.SCHEDULED;
                }
                throw new AssertionError((Object)("No progress on deflate made for " + String.valueOf(this)));
            }
            GzipResponseAndCallback.this._state.set(GZState.FINISHED);
            GzipResponseAndCallback.this.addTrailer(outputBuffer);
            BufferUtil.flipToFlush(outputBuffer, 0);
            this.write(true, outputBuffer);
            return IteratingCallback.Action.SCHEDULED;
        }

        private void write(boolean last, ByteBuffer outputBuffer) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("write() last={}, outputBuffer={}", (Object)last, (Object)BufferUtil.toDetailString(outputBuffer));
            }
            GzipResponseAndCallback.super.write(last, outputBuffer, this);
        }

        @Override
        public String toString() {
            return String.format("%s[content=%s last=%b buffer=%s deflate=%s %s]", new Object[]{super.toString(), BufferUtil.toDetailString(this._content), this._last, GzipResponseAndCallback.this._buffer, GzipResponseAndCallback.this._deflaterEntry, GzipResponseAndCallback.this._state.get()});
        }
    }
}

