/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.server;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnixDomainSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ReadPendingException;
import java.nio.channels.WritePendingException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import wiremock.org.eclipse.jetty.io.AbstractConnection;
import wiremock.org.eclipse.jetty.io.Connection;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.io.RetainableByteBuffer;
import wiremock.org.eclipse.jetty.server.AbstractConnectionFactory;
import wiremock.org.eclipse.jetty.server.ConnectionFactory;
import wiremock.org.eclipse.jetty.server.Connector;
import wiremock.org.eclipse.jetty.server.DetectorConnectionFactory;
import wiremock.org.eclipse.jetty.util.BufferUtil;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.StringUtil;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class ProxyConnectionFactory
extends DetectorConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyConnectionFactory.class);

    public ProxyConnectionFactory() {
        this((String)null);
    }

    public ProxyConnectionFactory(String nextProtocol) {
        super(new ProxyV1ConnectionFactory(nextProtocol), new ProxyV2ConnectionFactory(nextProtocol));
    }

    private static ConnectionFactory findNextConnectionFactory(String nextProtocol, Connector connector, String currentProtocol, EndPoint endp) {
        currentProtocol = "[" + (String)currentProtocol + "]";
        if (LOG.isDebugEnabled()) {
            LOG.debug("finding connection factory following {} for protocol {}", currentProtocol, (Object)nextProtocol);
        }
        String nextProtocolToFind = nextProtocol;
        if (nextProtocol == null) {
            nextProtocolToFind = AbstractConnectionFactory.findNextProtocol(connector, (String)currentProtocol);
        }
        if (nextProtocolToFind == null) {
            throw new IllegalStateException("Cannot find protocol following '" + (String)currentProtocol + "' in connector's protocol list " + String.valueOf(connector.getProtocols()) + " for " + String.valueOf(endp));
        }
        ConnectionFactory connectionFactory = connector.getConnectionFactory(nextProtocolToFind);
        if (connectionFactory == null) {
            throw new IllegalStateException("Cannot find protocol '" + nextProtocol + "' in connector's protocol list " + String.valueOf(connector.getProtocols()) + " for " + String.valueOf(endp));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("found next connection factory {} for protocol {}", (Object)connectionFactory, (Object)nextProtocol);
        }
        return connectionFactory;
    }

    public int getMaxProxyHeader() {
        ProxyV2ConnectionFactory v2 = this.getBean(ProxyV2ConnectionFactory.class);
        return v2.getMaxProxyHeader();
    }

    public void setMaxProxyHeader(int maxProxyHeader) {
        ProxyV2ConnectionFactory v2 = this.getBean(ProxyV2ConnectionFactory.class);
        v2.setMaxProxyHeader(maxProxyHeader);
    }

    private static class ProxyV1ConnectionFactory
    extends AbstractConnectionFactory
    implements ConnectionFactory.Detecting {
        private static final byte[] SIGNATURE = "PROXY".getBytes(StandardCharsets.US_ASCII);
        private final String _nextProtocol;

        private ProxyV1ConnectionFactory(String nextProtocol) {
            super("proxy");
            this._nextProtocol = nextProtocol;
        }

        @Override
        public ConnectionFactory.Detecting.Detection detect(ByteBuffer buffer) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Proxy v1 attempting detection with {} bytes", (Object)buffer.remaining());
            }
            if (buffer.remaining() < SIGNATURE.length) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v1 detection requires more bytes");
                }
                return ConnectionFactory.Detecting.Detection.NEED_MORE_BYTES;
            }
            for (int i = 0; i < SIGNATURE.length; ++i) {
                byte signatureByte = SIGNATURE[i];
                byte byteInBuffer = buffer.get(i);
                if (byteInBuffer == signatureByte) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v1 detection unsuccessful");
                }
                return ConnectionFactory.Detecting.Detection.NOT_RECOGNIZED;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Proxy v1 detection succeeded");
            }
            return ConnectionFactory.Detecting.Detection.RECOGNIZED;
        }

        @Override
        public Connection newConnection(Connector connector, EndPoint endp) {
            ConnectionFactory nextConnectionFactory = ProxyConnectionFactory.findNextConnectionFactory(this._nextProtocol, connector, this.getProtocol(), endp);
            return this.configure(new ProxyProtocolV1Connection(endp, connector, nextConnectionFactory), connector, endp);
        }

        private static class ProxyProtocolV1Connection
        extends AbstractConnection
        implements Connection.UpgradeFrom,
        Connection.UpgradeTo {
            private static final int CR_INDEX = 6;
            private static final int LF_INDEX = 7;
            private final Connector _connector;
            private final ConnectionFactory _next;
            private final RetainableByteBuffer _buffer;
            private final StringBuilder _builder = new StringBuilder();
            private final String[] _fields = new String[6];
            private int _index;
            private int _length;

            private ProxyProtocolV1Connection(EndPoint endp, Connector connector, ConnectionFactory next) {
                super(endp, connector.getExecutor());
                this._connector = connector;
                this._next = next;
                this._buffer = this._connector.getByteBufferPool().acquire(this.getInputBufferSize(), true);
            }

            @Override
            public void onFillable() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v1 onFillable current index = {}", (Object)this._index);
                }
                try {
                    while (this._index < 7) {
                        int fill = this.getEndPoint().fill(this._buffer.getByteBuffer());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Proxy v1 filled buffer with {} bytes", (Object)fill);
                        }
                        if (fill < 0) {
                            this._buffer.release();
                            this.getEndPoint().shutdownOutput();
                            return;
                        }
                        if (fill == 0) {
                            this.fillInterested();
                            return;
                        }
                        if (!this.parse()) continue;
                        break;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Proxy v1 onFillable parsing done, now upgrading");
                    }
                    this.upgrade();
                }
                catch (Throwable x) {
                    LOG.warn("Proxy v1 error for {} {}", (Object)this.getEndPoint(), (Object)x.toString());
                    if (LOG.isDebugEnabled()) {
                        LOG.warn("Proxy v1 error", x);
                    }
                    this.releaseAndClose();
                }
            }

            @Override
            public void onOpen() {
                super.onOpen();
                try {
                    while (this._index < 7) {
                        if (this.parse()) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Proxy v1 onOpen parsing ran out of bytes, marking as fillInterested");
                        }
                        this.fillInterested();
                        return;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Proxy v1 onOpen parsing done, now upgrading");
                    }
                    this.upgrade();
                }
                catch (Throwable x) {
                    LOG.warn("Proxy v1 error for {} {}", (Object)this.getEndPoint(), (Object)x.toString());
                    if (LOG.isDebugEnabled()) {
                        LOG.warn("Proxy v1 error", x);
                    }
                    this.releaseAndClose();
                }
            }

            @Override
            public ByteBuffer onUpgradeFrom() {
                if (this._buffer.hasRemaining()) {
                    ByteBuffer unconsumed = ByteBuffer.allocateDirect(this._buffer.remaining());
                    unconsumed.put(this._buffer.getByteBuffer());
                    unconsumed.flip();
                    this._buffer.release();
                    return unconsumed;
                }
                this._buffer.release();
                return null;
            }

            @Override
            public void onUpgradeTo(ByteBuffer buffer) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v1 copying unconsumed buffer {}", (Object)BufferUtil.toDetailString(buffer));
                }
                BufferUtil.append(this._buffer.getByteBuffer(), buffer);
            }

            private boolean parse() throws IOException {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v1 parsing {}", (Object)this._buffer);
                }
                this._length += this._buffer.remaining();
                while (this._buffer.hasRemaining()) {
                    byte b = this._buffer.getByteBuffer().get();
                    if (this._index < 6) {
                        if (b == 32 || b == 13) {
                            this._fields[this._index++] = this._builder.toString();
                            this._builder.setLength(0);
                            if (b != 13) continue;
                            this._index = 6;
                            continue;
                        }
                        if (b < 32) {
                            throw new IOException("Proxy v1 bad character " + (b & 0xFF));
                        }
                        this._builder.append((char)b);
                        continue;
                    }
                    if (b == 10) {
                        this._index = 7;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Proxy v1 parsing is done");
                        }
                        return true;
                    }
                    throw new IOException("Proxy v1 bad CRLF " + (b & 0xFF));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v1 parsing requires more bytes");
                }
                return false;
            }

            private void releaseAndClose() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v1 releasing buffer and closing");
                }
                this._buffer.release();
                this.close();
            }

            private void upgrade() {
                ProxyEndPoint proxyEndPoint;
                int proxyLineLength = this._length - this._buffer.remaining();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v1 pre-upgrade packet length (including CRLF) is {}", (Object)proxyLineLength);
                }
                if (proxyLineLength >= 110) {
                    LOG.warn("Proxy v1 PROXY line too long {} for {}", (Object)proxyLineLength, (Object)this.getEndPoint());
                    this.releaseAndClose();
                    return;
                }
                if (!"PROXY".equals(this._fields[0])) {
                    LOG.warn("Proxy v1 not PROXY protocol for {}", (Object)this.getEndPoint());
                    this.releaseAndClose();
                    return;
                }
                String srcIP = this._fields[2];
                String srcPort = this._fields[4];
                String dstIP = this._fields[3];
                String dstPort = this._fields[5];
                boolean unknown = "UNKNOWN".equalsIgnoreCase(this._fields[1]);
                if (unknown) {
                    EndPoint endPoint = this.getEndPoint();
                    proxyEndPoint = new ProxyEndPoint(endPoint, endPoint.getLocalSocketAddress(), endPoint.getRemoteSocketAddress());
                } else {
                    InetSocketAddress remote = new InetSocketAddress(srcIP, Integer.parseInt(srcPort));
                    InetSocketAddress local = new InetSocketAddress(dstIP, Integer.parseInt(dstPort));
                    proxyEndPoint = new ProxyEndPoint(this.getEndPoint(), local, remote);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v1 next protocol '{}' for {} -> {}", this._next, this.getEndPoint(), proxyEndPoint);
                }
                DetectorConnectionFactory.upgradeToConnectionFactory(this._next, this._connector, proxyEndPoint);
            }
        }
    }

    private static class ProxyV2ConnectionFactory
    extends AbstractConnectionFactory
    implements ConnectionFactory.Detecting {
        private static final byte[] SIGNATURE = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10};
        private static final int PP2_TYPE_ALPN = 1;
        private static final int PP2_TYPE_AUTHORITY = 2;
        private static final int PP2_TYPE_CRC32C = 3;
        private static final int PP2_TYPE_NOOP = 4;
        private static final int PP2_TYPE_UNIQUE_ID = 5;
        private static final int PP2_TYPE_SSL = 32;
        private static final int PP2_SUBTYPE_SSL_VERSION = 33;
        private static final int PP2_SUBTYPE_SSL_CN = 34;
        private static final int PP2_SUBTYPE_SSL_CIPHER = 35;
        private static final int PP2_SUBTYPE_SSL_SIG_ALG = 36;
        private static final int PP2_SUBTYPE_SSL_KEY_ALG = 37;
        private static final int PP2_TYPE_NETNS = 48;
        private static final int PP2_CLIENT_SSL = 1;
        private static final int PP2_CLIENT_CERT_CONN = 2;
        private static final int PP2_CLIENT_CERT_SESS = 4;
        private final String _nextProtocol;
        private int _maxProxyHeader = 1024;

        private ProxyV2ConnectionFactory(String nextProtocol) {
            super("proxy");
            this._nextProtocol = nextProtocol;
        }

        @Override
        public ConnectionFactory.Detecting.Detection detect(ByteBuffer buffer) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Proxy v2 attempting detection with {} bytes", (Object)buffer.remaining());
            }
            if (buffer.remaining() < SIGNATURE.length) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v2 detection requires more bytes");
                }
                return ConnectionFactory.Detecting.Detection.NEED_MORE_BYTES;
            }
            for (int i = 0; i < SIGNATURE.length; ++i) {
                byte signatureByte = SIGNATURE[i];
                byte byteInBuffer = buffer.get(i);
                if (byteInBuffer == signatureByte) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v2 detection unsuccessful");
                }
                return ConnectionFactory.Detecting.Detection.NOT_RECOGNIZED;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Proxy v2 detection succeeded");
            }
            return ConnectionFactory.Detecting.Detection.RECOGNIZED;
        }

        public int getMaxProxyHeader() {
            return this._maxProxyHeader;
        }

        public void setMaxProxyHeader(int maxProxyHeader) {
            this._maxProxyHeader = maxProxyHeader;
        }

        @Override
        public Connection newConnection(Connector connector, EndPoint endp) {
            ConnectionFactory nextConnectionFactory = ProxyConnectionFactory.findNextConnectionFactory(this._nextProtocol, connector, this.getProtocol(), endp);
            return this.configure(new ProxyProtocolV2Connection(endp, connector, nextConnectionFactory), connector, endp);
        }

        private class ProxyProtocolV2Connection
        extends AbstractConnection
        implements Connection.UpgradeFrom,
        Connection.UpgradeTo {
            private static final int HEADER_LENGTH = 16;
            private final Connector _connector;
            private final ConnectionFactory _next;
            private final RetainableByteBuffer _buffer;
            private boolean _local;
            private Family _family;
            private int _length;
            private boolean _headerParsed;

            protected ProxyProtocolV2Connection(EndPoint endp, Connector connector, ConnectionFactory next) {
                super(endp, connector.getExecutor());
                this._connector = connector;
                this._next = next;
                this._buffer = this._connector.getByteBufferPool().acquire(this.getInputBufferSize(), true);
            }

            @Override
            public void onUpgradeTo(ByteBuffer buffer) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v2 copying unconsumed buffer {}", (Object)BufferUtil.toDetailString(buffer));
                }
                BufferUtil.append(this._buffer.getByteBuffer(), buffer);
            }

            @Override
            public void onOpen() {
                super.onOpen();
                try {
                    this.parseHeader();
                    if (this._headerParsed && this._buffer.remaining() >= this._length) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Proxy v2 onOpen parsing fixed length packet part done, now upgrading");
                        }
                        this.parseBodyAndUpgrade();
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Proxy v2 onOpen parsing fixed length packet ran out of bytes, marking as fillInterested");
                        }
                        this.fillInterested();
                    }
                }
                catch (Exception x) {
                    LOG.warn("Proxy v2 error for {} {}", (Object)this.getEndPoint(), (Object)x.toString());
                    if (LOG.isDebugEnabled()) {
                        LOG.warn("Proxy v2 error", x);
                    }
                    this.releaseAndClose();
                }
            }

            @Override
            public void onFillable() {
                try {
                    int fill;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Proxy v2 onFillable header parsed? {}", (Object)this._headerParsed);
                    }
                    while (!this._headerParsed) {
                        fill = this.getEndPoint().fill(this._buffer.getByteBuffer());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Proxy v2 filled buffer with {} bytes", (Object)fill);
                        }
                        if (fill < 0) {
                            this._buffer.release();
                            this.getEndPoint().shutdownOutput();
                            return;
                        }
                        if (fill == 0) {
                            this.fillInterested();
                            return;
                        }
                        this.parseHeader();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Proxy v2 onFillable header parsed, length = {}, buffer = {}", (Object)this._length, (Object)this._buffer);
                    }
                    while (this._buffer.remaining() < this._length) {
                        fill = this.getEndPoint().fill(this._buffer.getByteBuffer());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Proxy v2 filled buffer with {} bytes", (Object)fill);
                        }
                        if (fill < 0) {
                            this._buffer.release();
                            this.getEndPoint().shutdownOutput();
                            return;
                        }
                        if (fill != 0) continue;
                        this.fillInterested();
                        return;
                    }
                    this.parseBodyAndUpgrade();
                }
                catch (Throwable x) {
                    LOG.warn("Proxy v2 error for {} {}", (Object)this.getEndPoint(), (Object)x.toString());
                    if (LOG.isDebugEnabled()) {
                        LOG.warn("Proxy v2 error", x);
                    }
                    this.releaseAndClose();
                }
            }

            @Override
            public ByteBuffer onUpgradeFrom() {
                if (this._buffer.hasRemaining()) {
                    ByteBuffer unconsumed = ByteBuffer.allocateDirect(this._buffer.remaining());
                    unconsumed.put(this._buffer.getByteBuffer());
                    unconsumed.flip();
                    this._buffer.release();
                    return unconsumed;
                }
                this._buffer.release();
                return null;
            }

            private void parseBodyAndUpgrade() throws IOException {
                ProxyEndPoint proxyEndPoint;
                int nonProxyRemaining = this._buffer.remaining() - this._length;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v2 parsing body, length = {}, buffer = {}", (Object)this._length, (Object)this._buffer);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v2 body {} from {} for {}", this._next, this._buffer, this);
                }
                ByteBuffer byteBuffer = this._buffer.getByteBuffer();
                EndPoint endPoint = this.getEndPoint();
                if (this._local) {
                    byteBuffer.position(byteBuffer.position() + this._length);
                    proxyEndPoint = new ProxyEndPoint(endPoint, endPoint.getLocalSocketAddress(), endPoint.getRemoteSocketAddress());
                } else {
                    SocketAddress local;
                    SocketAddress remote = switch (this._family.ordinal()) {
                        case 1 -> {
                            byte[] addr = new byte[4];
                            byteBuffer.get(addr);
                            InetAddress srcAddr = Inet4Address.getByAddress(addr);
                            byteBuffer.get(addr);
                            InetAddress dstAddr = Inet4Address.getByAddress(addr);
                            char srcPort = byteBuffer.getChar();
                            char dstPort = byteBuffer.getChar();
                            local = new InetSocketAddress(dstAddr, (int)dstPort);
                            yield new InetSocketAddress(srcAddr, (int)srcPort);
                        }
                        case 2 -> {
                            byte[] addr = new byte[16];
                            byteBuffer.get(addr);
                            InetAddress srcAddr = Inet6Address.getByAddress(addr);
                            byteBuffer.get(addr);
                            InetAddress dstAddr = Inet6Address.getByAddress(addr);
                            char srcPort = byteBuffer.getChar();
                            char dstPort = byteBuffer.getChar();
                            local = new InetSocketAddress(dstAddr, (int)dstPort);
                            yield new InetSocketAddress(srcAddr, (int)srcPort);
                        }
                        case 3 -> {
                            byte[] addr = new byte[108];
                            byteBuffer.get(addr);
                            String src = ProxyProtocolV2Connection.toUnixDomainPath(addr);
                            byteBuffer.get(addr);
                            String dst = ProxyProtocolV2Connection.toUnixDomainPath(addr);
                            local = UnixDomainSocketAddress.of(dst);
                            yield UnixDomainSocketAddress.of(src);
                        }
                        default -> throw new IllegalStateException("Unsupported family " + String.valueOf((Object)this._family));
                    };
                    int client = 0;
                    String sslCipher = null;
                    HashMap<Integer, byte[]> tlvs = null;
                    while (byteBuffer.remaining() > nonProxyRemaining) {
                        int subLength;
                        int type = 0xFF & byteBuffer.get();
                        int length = byteBuffer.getChar();
                        byte[] value = new byte[length];
                        byteBuffer.get(value);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug(String.format("Proxy v2 T=%x L=%d V=%s for %s", type, length, StringUtil.toHexString(value), this));
                        }
                        if (type != 4) {
                            if (tlvs == null) {
                                tlvs = new HashMap<Integer, byte[]>();
                            }
                            tlvs.put(type, value);
                        }
                        if (type != 32) continue;
                        client = value[0] & 0xFF;
                        sslCipher = null;
                        for (int i = 5; i < length; i += subLength) {
                            int subType = value[i++] & 0xFF;
                            subLength = (value[i++] & 0xFF) * 256 + (value[i++] & 0xFF);
                            byte[] subValue = new byte[subLength];
                            System.arraycopy(value, i, subValue, 0, subLength);
                            tlvs.put(subType, subValue);
                            if (subType != 35) continue;
                            sslCipher = new String(subValue, StandardCharsets.US_ASCII);
                        }
                    }
                    proxyEndPoint = new ProxyEndPoint(endPoint, local, remote, tlvs, client == 0 ? null : EndPoint.SslSessionData.from(null, null, sslCipher, null));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Proxy v2 {} {}", (Object)endPoint, (Object)proxyEndPoint);
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v2 parsing dynamic packet part is now done, upgrading to {}", (Object)ProxyV2ConnectionFactory.this._nextProtocol);
                }
                DetectorConnectionFactory.upgradeToConnectionFactory(this._next, this._connector, proxyEndPoint);
            }

            private void parseHeader() throws IOException {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v2 parsing fixed length packet part, buffer = {}", (Object)this._buffer);
                }
                if (this._buffer.remaining() < 16) {
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v2 header {} for {}", (Object)this._buffer, (Object)this);
                }
                ByteBuffer byteBuffer = this._buffer.getByteBuffer();
                for (byte signatureByte : SIGNATURE) {
                    if (byteBuffer.get() == signatureByte) continue;
                    throw new IOException("Proxy v2 bad PROXY signature");
                }
                int versionAndCommand = 0xFF & byteBuffer.get();
                if ((versionAndCommand & 0xF0) != 32) {
                    throw new IOException("Proxy v2 bad PROXY version");
                }
                this._local = (versionAndCommand & 0xF) == 0;
                int transportAndFamily = 0xFF & byteBuffer.get();
                switch (transportAndFamily >> 4) {
                    case 0: {
                        this._family = Family.UNSPEC;
                        break;
                    }
                    case 1: {
                        this._family = Family.INET;
                        break;
                    }
                    case 2: {
                        this._family = Family.INET6;
                        break;
                    }
                    case 3: {
                        this._family = Family.UNIX;
                        break;
                    }
                    default: {
                        throw new IOException("Proxy v2 bad PROXY family");
                    }
                }
                Transport transport = switch (transportAndFamily & 0xF) {
                    case 0 -> Transport.UNSPEC;
                    case 1 -> Transport.STREAM;
                    case 2 -> Transport.DGRAM;
                    default -> throw new IOException("Proxy v2 bad PROXY family");
                };
                this._length = byteBuffer.getChar();
                if (!(this._local || this._family != Family.UNSPEC && transport == Transport.STREAM)) {
                    throw new IOException(String.format("Proxy v2 unsupported PROXY mode 0x%x,0x%x", versionAndCommand, transportAndFamily));
                }
                if (this._length > ProxyV2ConnectionFactory.this.getMaxProxyHeader()) {
                    throw new IOException(String.format("Proxy v2 Unsupported PROXY mode 0x%x,0x%x,0x%x", versionAndCommand, transportAndFamily, this._length));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v2 fixed length packet part is now parsed");
                }
                this._headerParsed = true;
            }

            private void releaseAndClose() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Proxy v2 releasing buffer and closing");
                }
                this._buffer.release();
                this.close();
            }

            private static String toUnixDomainPath(byte[] bytes) {
                int i = 0;
                while (i < bytes.length && bytes[i++] != 0) {
                }
                return new String(bytes, 0, i, StandardCharsets.US_ASCII).trim();
            }
        }

        private static enum Transport {
            UNSPEC,
            STREAM,
            DGRAM;

        }

        private static enum Family {
            UNSPEC,
            INET,
            INET6,
            UNIX;

        }
    }

    public static class ProxyEndPoint
    implements EndPoint,
    EndPoint.Wrapper {
        private final EndPoint _endPoint;
        private final SocketAddress _local;
        private final SocketAddress _remote;
        private final Map<Integer, byte[]> _tlvs;
        private final EndPoint.SslSessionData _sslSessionData;

        public ProxyEndPoint(EndPoint endPoint, SocketAddress local, SocketAddress remote) {
            this(endPoint, local, remote, null, null);
        }

        public ProxyEndPoint(EndPoint endPoint, SocketAddress local, SocketAddress remote, Map<Integer, byte[]> tlvs, EndPoint.SslSessionData sslSessionData) {
            this._endPoint = endPoint;
            this._local = local;
            this._remote = remote;
            this._tlvs = tlvs;
            this._sslSessionData = sslSessionData;
        }

        @Override
        public EndPoint.SslSessionData getSslSessionData() {
            return this._sslSessionData;
        }

        @Override
        public EndPoint unwrap() {
            return this._endPoint;
        }

        public byte[] getTLV(int type) {
            return this._tlvs != null ? this._tlvs.get(type) : null;
        }

        @Override
        public void close(Throwable cause) {
            this._endPoint.close(cause);
        }

        @Override
        public int fill(ByteBuffer buffer) throws IOException {
            return this._endPoint.fill(buffer);
        }

        @Override
        public void fillInterested(Callback callback) throws ReadPendingException {
            this._endPoint.fillInterested(callback);
        }

        @Override
        public boolean flush(ByteBuffer ... buffer) throws IOException {
            return this._endPoint.flush(buffer);
        }

        @Override
        public Connection getConnection() {
            return this._endPoint.getConnection();
        }

        @Override
        public void setConnection(Connection connection) {
            this._endPoint.setConnection(connection);
        }

        @Override
        public long getCreatedTimeStamp() {
            return this._endPoint.getCreatedTimeStamp();
        }

        @Override
        public long getIdleTimeout() {
            return this._endPoint.getIdleTimeout();
        }

        @Override
        public void setIdleTimeout(long idleTimeout) {
            this._endPoint.setIdleTimeout(idleTimeout);
        }

        @Override
        public InetSocketAddress getLocalAddress() {
            SocketAddress local = this.getLocalSocketAddress();
            if (local instanceof InetSocketAddress) {
                return (InetSocketAddress)local;
            }
            return null;
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return this._local;
        }

        @Override
        public InetSocketAddress getRemoteAddress() {
            SocketAddress remote = this.getRemoteSocketAddress();
            if (remote instanceof InetSocketAddress) {
                return (InetSocketAddress)remote;
            }
            return null;
        }

        @Override
        public SocketAddress getRemoteSocketAddress() {
            return this._remote;
        }

        @Override
        public Object getTransport() {
            return this._endPoint.getTransport();
        }

        @Override
        public boolean isFillInterested() {
            return this._endPoint.isFillInterested();
        }

        @Override
        public boolean isInputShutdown() {
            return this._endPoint.isInputShutdown();
        }

        @Override
        public boolean isOpen() {
            return this._endPoint.isOpen();
        }

        @Override
        public boolean isOutputShutdown() {
            return this._endPoint.isOutputShutdown();
        }

        @Override
        public void onClose(Throwable cause) {
            this._endPoint.onClose(cause);
        }

        @Override
        public void onOpen() {
            this._endPoint.onOpen();
        }

        @Override
        public void shutdownOutput() {
            this._endPoint.shutdownOutput();
        }

        public String toString() {
            return String.format("%s@%x[remote=%s,local=%s,endpoint=%s]", this.getClass().getSimpleName(), this.hashCode(), this._remote, this._local, this._endPoint);
        }

        @Override
        public boolean tryFillInterested(Callback callback) {
            return this._endPoint.tryFillInterested(callback);
        }

        @Override
        public void upgrade(Connection newConnection) {
            this._endPoint.upgrade(newConnection);
        }

        @Override
        public void write(Callback callback, ByteBuffer ... buffers) throws WritePendingException {
            this._endPoint.write(callback, buffers);
        }
    }
}

