/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.server;

import java.nio.ByteBuffer;
import wiremock.org.eclipse.jetty.http.HttpFields;
import wiremock.org.eclipse.jetty.http.MetaData;
import wiremock.org.eclipse.jetty.io.Content;
import wiremock.org.eclipse.jetty.server.HttpConfiguration;
import wiremock.org.eclipse.jetty.server.TunnelSupport;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.eclipse.jetty.util.StaticException;
import wiremock.org.eclipse.jetty.util.thread.Invocable;

public interface HttpStream
extends Callback {
    public static final Exception CONTENT_NOT_CONSUMED = new StaticException("Unconsumed request content");
    public static final String UPGRADE_CONNECTION_ATTRIBUTE = HttpStream.class.getName() + ".upgradeConnection";

    public String getId();

    public Content.Chunk read();

    public void demand();

    public void prepareResponse(HttpFields.Mutable var1);

    public void send(MetaData.Request var1, MetaData.Response var2, boolean var3, ByteBuffer var4, Callback var5);

    default public void push(MetaData.Request resource) {
        throw new UnsupportedOperationException();
    }

    public long getIdleTimeout();

    public void setIdleTimeout(long var1);

    public boolean isCommitted();

    default public TunnelSupport getTunnelSupport() {
        return null;
    }

    public Throwable consumeAvailable();

    public static Throwable consumeAvailable(HttpStream stream, HttpConfiguration httpConfig) {
        int maxReads = httpConfig.getMaxUnconsumedRequestContentReads();
        for (int numReads = 0; maxReads < 0 || numReads < maxReads; ++numReads) {
            Content.Chunk content = stream.read();
            if (content == null) break;
            content.release();
            if (!Content.Chunk.isFailure(content)) continue;
            return content.getFailure();
        }
        return CONTENT_NOT_CONSUMED;
    }

    @Override
    default public Invocable.InvocationType getInvocationType() {
        return Invocable.InvocationType.NON_BLOCKING;
    }

    public static class Wrapper
    implements HttpStream {
        private final HttpStream _wrapped;

        public Wrapper(HttpStream wrapped) {
            this._wrapped = wrapped;
        }

        public HttpStream getWrapped() {
            return this._wrapped;
        }

        @Override
        public final String getId() {
            return this.getWrapped().getId();
        }

        @Override
        public Content.Chunk read() {
            return this.getWrapped().read();
        }

        @Override
        public void demand() {
            this.getWrapped().demand();
        }

        @Override
        public void prepareResponse(HttpFields.Mutable headers) {
            this.getWrapped().prepareResponse(headers);
        }

        @Override
        public void send(MetaData.Request request, MetaData.Response response, boolean last, ByteBuffer content, Callback callback) {
            this.getWrapped().send(request, response, last, content, callback);
        }

        @Override
        public void push(MetaData.Request resource) {
            this.getWrapped().push(resource);
        }

        @Override
        public long getIdleTimeout() {
            return this.getWrapped().getIdleTimeout();
        }

        @Override
        public void setIdleTimeout(long idleTimeoutMs) {
            this.getWrapped().setIdleTimeout(idleTimeoutMs);
        }

        @Override
        public final boolean isCommitted() {
            return this.getWrapped().isCommitted();
        }

        @Override
        public TunnelSupport getTunnelSupport() {
            return this.getWrapped().getTunnelSupport();
        }

        @Override
        public final Throwable consumeAvailable() {
            return this.getWrapped().consumeAvailable();
        }

        @Override
        public void succeeded() {
            this.getWrapped().succeeded();
        }

        @Override
        public void failed(Throwable x) {
            this.getWrapped().failed(x);
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return this.getWrapped().getInvocationType();
        }
    }
}

