/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.server;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import wiremock.org.eclipse.jetty.http.HttpVersion;
import wiremock.org.eclipse.jetty.io.Connection;
import wiremock.org.eclipse.jetty.io.EndPoint;
import wiremock.org.eclipse.jetty.server.Connector;
import wiremock.org.eclipse.jetty.server.HttpConfiguration;
import wiremock.org.eclipse.jetty.util.Attributes;
import wiremock.org.eclipse.jetty.util.HostPort;

public interface ConnectionMetaData
extends Attributes {
    public String getId();

    public HttpConfiguration getHttpConfiguration();

    public HttpVersion getHttpVersion();

    public String getProtocol();

    public Connection getConnection();

    public Connector getConnector();

    public boolean isPersistent();

    default public boolean isSecure() {
        EndPoint endPoint = this.getConnection().getEndPoint();
        return endPoint != null && endPoint.isSecure();
    }

    default public boolean isPushSupported() {
        return false;
    }

    public SocketAddress getRemoteSocketAddress();

    public SocketAddress getLocalSocketAddress();

    default public HostPort getServerAuthority() {
        HttpConfiguration httpConfiguration = this.getHttpConfiguration();
        HostPort authority = httpConfiguration.getServerAuthority();
        if (authority != null) {
            return authority;
        }
        SocketAddress localSocketAddress = this.getLocalSocketAddress();
        if (localSocketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)localSocketAddress;
            return new HostPort(inetSocketAddress.getHostString(), inetSocketAddress.getPort());
        }
        if (localSocketAddress != null) {
            return new HostPort(localSocketAddress.toString());
        }
        return null;
    }

    public static class Wrapper
    extends Attributes.Wrapper
    implements ConnectionMetaData {
        public Wrapper(ConnectionMetaData wrapped) {
            super(wrapped);
        }

        @Override
        public ConnectionMetaData getWrapped() {
            return (ConnectionMetaData)super.getWrapped();
        }

        @Override
        public String getId() {
            return this.getWrapped().getId();
        }

        @Override
        public HttpConfiguration getHttpConfiguration() {
            return this.getWrapped().getHttpConfiguration();
        }

        @Override
        public HttpVersion getHttpVersion() {
            return this.getWrapped().getHttpVersion();
        }

        @Override
        public String getProtocol() {
            return this.getWrapped().getProtocol();
        }

        @Override
        public Connection getConnection() {
            return this.getWrapped().getConnection();
        }

        @Override
        public Connector getConnector() {
            return this.getWrapped().getConnector();
        }

        @Override
        public boolean isPersistent() {
            return this.getWrapped().isPersistent();
        }

        @Override
        public boolean isSecure() {
            return this.getWrapped().isSecure();
        }

        @Override
        public boolean isPushSupported() {
            return this.getWrapped().isPushSupported();
        }

        @Override
        public SocketAddress getRemoteSocketAddress() {
            return this.getWrapped().getRemoteSocketAddress();
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return this.getWrapped().getLocalSocketAddress();
        }

        @Override
        public HostPort getServerAuthority() {
            return this.getWrapped().getServerAuthority();
        }
    }
}

