/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.security.jaas;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import wiremock.org.eclipse.jetty.security.PropertyUserStore;
import wiremock.org.eclipse.jetty.util.component.AbstractLifeCycle;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class PropertyUserStoreManager
extends AbstractLifeCycle {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyUserStoreManager.class);
    private Map<String, PropertyUserStore> _propertyUserStores;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyUserStore getPropertyUserStore(String file) {
        PropertyUserStoreManager propertyUserStoreManager = this;
        synchronized (propertyUserStoreManager) {
            if (this._propertyUserStores == null) {
                return null;
            }
            return this._propertyUserStores.get(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyUserStore addPropertyUserStore(String file, PropertyUserStore store) {
        PropertyUserStoreManager propertyUserStoreManager = this;
        synchronized (propertyUserStoreManager) {
            Objects.requireNonNull(this._propertyUserStores);
            PropertyUserStore existing = this._propertyUserStores.get(file);
            if (existing != null) {
                return existing;
            }
            this._propertyUserStores.put(file, store);
            return store;
        }
    }

    @Override
    protected void doStart() throws Exception {
        this._propertyUserStores = new HashMap<String, PropertyUserStore>();
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        for (Map.Entry<String, PropertyUserStore> entry : this._propertyUserStores.entrySet()) {
            try {
                entry.getValue().stop();
            }
            catch (Exception e) {
                LOG.warn("Error stopping PropertyUserStore at {}", (Object)entry.getKey(), (Object)e);
            }
        }
        this._propertyUserStores = null;
        super.doStop();
    }
}

