/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.security.internal;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import wiremock.org.eclipse.jetty.http.HttpFields;
import wiremock.org.eclipse.jetty.security.AuthenticationState;
import wiremock.org.eclipse.jetty.security.IdentityService;
import wiremock.org.eclipse.jetty.security.LoginService;
import wiremock.org.eclipse.jetty.security.ServerAuthException;
import wiremock.org.eclipse.jetty.security.UserIdentity;
import wiremock.org.eclipse.jetty.security.authentication.LoginAuthenticator;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.Response;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class DeferredAuthenticationState
implements AuthenticationState.Deferred {
    private static final Logger LOG = LoggerFactory.getLogger(DeferredAuthenticationState.class);
    protected final LoginAuthenticator _authenticator;
    private IdentityService.Association _association;
    static final Response __deferredResponse = new AuthenticationState.Deferred.DeferredResponse(){

        @Override
        public Request getRequest() {
            return null;
        }

        @Override
        public int getStatus() {
            return 0;
        }

        @Override
        public void setStatus(int code) {
        }

        @Override
        public HttpFields.Mutable getHeaders() {
            return null;
        }

        @Override
        public Supplier<HttpFields> getTrailersSupplier() {
            return null;
        }

        @Override
        public void setTrailersSupplier(Supplier<HttpFields> trailers) {
        }

        @Override
        public void write(boolean last, ByteBuffer content, Callback callback) {
            callback.succeeded();
        }

        @Override
        public boolean isCommitted() {
            return true;
        }

        @Override
        public boolean hasLastWrite() {
            return false;
        }

        @Override
        public boolean isCompletedSuccessfully() {
            return false;
        }

        @Override
        public void reset() {
        }

        @Override
        public CompletableFuture<Void> writeInterim(int status, HttpFields headers) {
            return null;
        }
    };

    public DeferredAuthenticationState(LoginAuthenticator authenticator) {
        if (authenticator == null) {
            throw new NullPointerException("No Authenticator");
        }
        this._authenticator = authenticator;
    }

    @Override
    public AuthenticationState.Succeeded authenticate(Request request) {
        try {
            AuthenticationState authenticationState = this._authenticator.validateRequest(request, __deferredResponse, Callback.NOOP);
            if (authenticationState != null) {
                AuthenticationState.setAuthenticationState(request, authenticationState);
                if (authenticationState instanceof AuthenticationState.Succeeded) {
                    AuthenticationState.Succeeded succeeded = (AuthenticationState.Succeeded)authenticationState;
                    LoginService loginService = this._authenticator.getLoginService();
                    IdentityService identityService = loginService.getIdentityService();
                    if (identityService != null) {
                        UserIdentity user = succeeded.getUserIdentity();
                        this._association = identityService.associate(user, null);
                    }
                    return succeeded;
                }
            }
        }
        catch (ServerAuthException e) {
            LOG.debug("Unable to authenticate {}", (Object)request, (Object)e);
        }
        return null;
    }

    @Override
    public AuthenticationState authenticate(Request request, Response response, Callback callback) {
        try {
            LoginService loginService = this._authenticator.getLoginService();
            IdentityService identityService = loginService.getIdentityService();
            AuthenticationState authenticationState = this._authenticator.validateRequest(request, response, callback);
            if (authenticationState != null) {
                AuthenticationState.setAuthenticationState(request, authenticationState);
                if (authenticationState instanceof AuthenticationState.Succeeded && identityService != null) {
                    UserIdentity user = ((AuthenticationState.Succeeded)authenticationState).getUserIdentity();
                    this._association = identityService.associate(user, null);
                }
            }
            return authenticationState;
        }
        catch (ServerAuthException e) {
            LOG.debug("Unable to authenticate {}", (Object)request, (Object)e);
            return null;
        }
    }

    @Override
    public AuthenticationState.Succeeded login(String username, Object password, Request request, Response response) {
        if (username == null) {
            return null;
        }
        UserIdentity identity = this._authenticator.login(username, password, request, response);
        if (identity != null) {
            IdentityService identityService = this._authenticator.getLoginService().getIdentityService();
            LoginAuthenticator.UserAuthenticationSucceeded authentication = new LoginAuthenticator.UserAuthenticationSucceeded("API", identity);
            if (identityService != null) {
                this._association = identityService.associate(identity, null);
            }
            return authentication;
        }
        return null;
    }

    @Override
    public void logout(Request request, Response response) {
        this._authenticator.logout(request, response);
    }

    @Override
    public IdentityService.Association getAssociation() {
        return this._association;
    }
}

