/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.server.internal;

import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import wiremock.org.eclipse.jetty.http2.HTTP2Channel;
import wiremock.org.eclipse.jetty.http2.HTTP2Stream;
import wiremock.org.eclipse.jetty.http2.HTTP2StreamEndPoint;
import wiremock.org.eclipse.jetty.http2.frames.HeadersFrame;
import wiremock.org.eclipse.jetty.io.Connection;
import wiremock.org.eclipse.jetty.util.Callback;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class ServerHTTP2StreamEndPoint
extends HTTP2StreamEndPoint
implements HTTP2Channel.Server {
    private static final Logger LOG = LoggerFactory.getLogger(ServerHTTP2StreamEndPoint.class);

    public ServerHTTP2StreamEndPoint(HTTP2Stream stream) {
        super(stream);
    }

    @Override
    public Runnable onDataAvailable() {
        this.processDataAvailable();
        return null;
    }

    @Override
    public Runnable onTrailer(HeadersFrame frame) {
        return null;
    }

    @Override
    public void onTimeout(TimeoutException timeout, BiConsumer<Runnable, Boolean> consumer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("idle timeout on {}", (Object)this, (Object)timeout);
        }
        boolean result = true;
        Connection connection = this.getConnection();
        if (connection != null) {
            result = connection.onIdleExpired(timeout);
        }
        Runnable r = null;
        if (result) {
            this.processFailure(timeout);
            r = () -> this.close(timeout);
        }
        consumer.accept(r, result);
    }

    @Override
    public Runnable onFailure(Throwable failure, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("failure on {}", (Object)this, (Object)failure);
        }
        this.processFailure(failure);
        this.close(failure);
        return callback::succeeded;
    }

    @Override
    public boolean isIdle() {
        return false;
    }
}

