/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.parser;

import java.nio.ByteBuffer;
import wiremock.org.eclipse.jetty.http.MetaData;
import wiremock.org.eclipse.jetty.http2.ErrorCode;
import wiremock.org.eclipse.jetty.http2.frames.FrameType;
import wiremock.org.eclipse.jetty.http2.frames.HeadersFrame;
import wiremock.org.eclipse.jetty.http2.frames.PriorityFrame;
import wiremock.org.eclipse.jetty.http2.parser.BodyParser;
import wiremock.org.eclipse.jetty.http2.parser.HeaderBlockFragments;
import wiremock.org.eclipse.jetty.http2.parser.HeaderBlockParser;
import wiremock.org.eclipse.jetty.http2.parser.HeaderParser;
import wiremock.org.eclipse.jetty.http2.parser.Parser;
import wiremock.org.eclipse.jetty.util.BufferUtil;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class HeadersBodyParser
extends BodyParser {
    private static final Logger LOG = LoggerFactory.getLogger(HeadersBodyParser.class);
    private final HeaderBlockParser headerBlockParser;
    private final HeaderBlockFragments headerBlockFragments;
    private State state = State.PREPARE;
    private int cursor;
    private int length;
    private int paddingLength;
    private boolean exclusive;
    private int parentStreamId;
    private int weight;

    public HeadersBodyParser(HeaderParser headerParser, Parser.Listener listener, HeaderBlockParser headerBlockParser, HeaderBlockFragments headerBlockFragments) {
        super(headerParser, listener);
        this.headerBlockParser = headerBlockParser;
        this.headerBlockFragments = headerBlockFragments;
    }

    private void reset() {
        this.state = State.PREPARE;
        this.cursor = 0;
        this.length = 0;
        this.paddingLength = 0;
        this.exclusive = false;
        this.parentStreamId = 0;
        this.weight = 0;
    }

    @Override
    protected void emptyBody(ByteBuffer buffer) {
        if (this.hasFlag(32)) {
            this.connectionFailure(buffer, ErrorCode.PROTOCOL_ERROR.code, "invalid_headers_priority_frame");
        } else if (this.hasFlag(4)) {
            MetaData metaData = this.headerBlockParser.parse(BufferUtil.EMPTY_BUFFER, 0);
            HeadersFrame frame = new HeadersFrame(this.getStreamId(), metaData, null, this.isEndStream());
            if (!this.rateControlOnEvent(frame)) {
                this.connectionFailure(buffer, ErrorCode.ENHANCE_YOUR_CALM_ERROR.code, "invalid_headers_frame_rate");
            } else {
                this.onHeaders(frame);
            }
        } else if (this.headerBlockFragments.getStreamId() != 0) {
            this.connectionFailure(buffer, ErrorCode.PROTOCOL_ERROR.code, "invalid_headers_frame");
        } else {
            this.headerBlockFragments.setStreamId(this.getStreamId());
            this.headerBlockFragments.setEndStream(this.isEndStream());
        }
    }

    @Override
    public boolean parse(ByteBuffer buffer) {
        boolean loop = false;
        block11: while (buffer.hasRemaining() || loop) {
            switch (this.state.ordinal()) {
                case 0: {
                    if (this.getStreamId() == 0) {
                        return this.connectionFailure(buffer, ErrorCode.PROTOCOL_ERROR.code, "invalid_headers_frame");
                    }
                    this.length = this.getBodyLength();
                    if (this.isPadding()) {
                        this.state = State.PADDING_LENGTH;
                        continue block11;
                    }
                    if (this.hasFlag(32)) {
                        this.state = State.EXCLUSIVE;
                        continue block11;
                    }
                    this.state = State.HEADERS;
                    continue block11;
                }
                case 1: {
                    if (this.length < 1) {
                        return this.connectionFailure(buffer, ErrorCode.FRAME_SIZE_ERROR.code, "invalid_headers_frame_padding");
                    }
                    this.paddingLength = buffer.get() & 0xFF;
                    --this.length;
                    this.length -= this.paddingLength;
                    this.state = this.hasFlag(32) ? State.EXCLUSIVE : State.HEADERS;
                    loop = this.length == 0;
                    continue block11;
                }
                case 2: {
                    if (this.length < 5) {
                        return this.connectionFailure(buffer, ErrorCode.FRAME_SIZE_ERROR.code, "invalid_headers_frame");
                    }
                    int currByte = buffer.get(buffer.position());
                    this.exclusive = (currByte & 0x80) == 128;
                    this.state = State.PARENT_STREAM_ID;
                    continue block11;
                }
                case 3: {
                    if (buffer.remaining() >= 4) {
                        this.parentStreamId = buffer.getInt();
                        this.parentStreamId &= Integer.MAX_VALUE;
                        this.length -= 4;
                        this.state = State.WEIGHT;
                        continue block11;
                    }
                    this.state = State.PARENT_STREAM_ID_BYTES;
                    this.cursor = 4;
                    continue block11;
                }
                case 4: {
                    int currByte = buffer.get() & 0xFF;
                    --this.cursor;
                    this.parentStreamId += currByte << 8 * this.cursor;
                    --this.length;
                    if (this.cursor != 0) continue block11;
                    this.parentStreamId &= Integer.MAX_VALUE;
                    this.state = State.WEIGHT;
                    continue block11;
                }
                case 5: {
                    if (this.getStreamId() == this.parentStreamId) {
                        return this.connectionFailure(buffer, ErrorCode.PROTOCOL_ERROR.code, "invalid_priority_frame");
                    }
                    this.weight = (buffer.get() & 0xFF) + 1;
                    --this.length;
                    this.state = State.HEADERS;
                    loop = this.length == 0;
                    continue block11;
                }
                case 6: {
                    if (!this.hasFlag(4)) {
                        this.headerBlockFragments.setStreamId(this.getStreamId());
                        this.headerBlockFragments.setEndStream(this.isEndStream());
                        if (this.hasFlag(32)) {
                            this.headerBlockFragments.setPriorityFrame(new PriorityFrame(this.getStreamId(), this.parentStreamId, this.weight, this.exclusive));
                        }
                    }
                    this.state = State.HEADER_BLOCK;
                    continue block11;
                }
                case 7: {
                    if (this.hasFlag(4)) {
                        int maxLength = this.headerBlockParser.getMaxHeaderListSize();
                        if (maxLength > 0 && this.length > maxLength) {
                            return this.connectionFailure(buffer, ErrorCode.REFUSED_STREAM_ERROR.code, "invalid_headers_frame");
                        }
                        MetaData metaData = this.headerBlockParser.parse(buffer, this.length);
                        if (metaData == HeaderBlockParser.SESSION_FAILURE) {
                            return false;
                        }
                        if (metaData == null) continue block11;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Parsed {} frame hpack from {}", (Object)FrameType.HEADERS, (Object)buffer);
                        }
                        this.state = State.PADDING;
                        boolean bl = loop = this.paddingLength == 0;
                        if (metaData != HeaderBlockParser.STREAM_FAILURE) {
                            this.onHeaders(this.parentStreamId, this.weight, this.exclusive, metaData);
                            continue block11;
                        }
                        HeadersFrame frame = new HeadersFrame(this.getStreamId(), metaData, null, this.isEndStream());
                        if (this.rateControlOnEvent(frame)) continue block11;
                        return this.connectionFailure(buffer, ErrorCode.ENHANCE_YOUR_CALM_ERROR.code, "invalid_headers_frame_rate");
                    }
                    int remaining = buffer.remaining();
                    if (remaining < this.length) {
                        if (!this.headerBlockFragments.storeFragment(buffer, remaining, false)) {
                            return this.connectionFailure(buffer, ErrorCode.PROTOCOL_ERROR.code, "invalid_headers_frame");
                        }
                        this.length -= remaining;
                        continue block11;
                    }
                    if (!this.headerBlockFragments.storeFragment(buffer, this.length, false)) {
                        return this.connectionFailure(buffer, ErrorCode.PROTOCOL_ERROR.code, "invalid_headers_frame");
                    }
                    this.state = State.PADDING;
                    loop = this.paddingLength == 0;
                    continue block11;
                }
                case 8: {
                    int size = Math.min(buffer.remaining(), this.paddingLength);
                    buffer.position(buffer.position() + size);
                    this.paddingLength -= size;
                    if (this.paddingLength != 0) continue block11;
                    this.reset();
                    return true;
                }
            }
            throw new IllegalStateException();
        }
        return false;
    }

    private void onHeaders(int parentStreamId, int weight, boolean exclusive, MetaData metaData) {
        PriorityFrame priorityFrame = null;
        if (this.hasFlag(32)) {
            priorityFrame = new PriorityFrame(this.getStreamId(), parentStreamId, weight, exclusive);
        }
        HeadersFrame frame = new HeadersFrame(this.getStreamId(), metaData, priorityFrame, this.isEndStream());
        this.onHeaders(frame);
    }

    private void onHeaders(HeadersFrame frame) {
        this.notifyHeaders(frame);
    }

    private static enum State {
        PREPARE,
        PADDING_LENGTH,
        EXCLUSIVE,
        PARENT_STREAM_ID,
        PARENT_STREAM_ID_BYTES,
        WEIGHT,
        HEADERS,
        HEADER_BLOCK,
        PADDING;

    }
}

