/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.generator;

import java.nio.ByteBuffer;
import java.util.Arrays;
import wiremock.org.eclipse.jetty.http2.frames.Frame;
import wiremock.org.eclipse.jetty.http2.frames.FrameType;
import wiremock.org.eclipse.jetty.http2.frames.GoAwayFrame;
import wiremock.org.eclipse.jetty.http2.generator.FrameGenerator;
import wiremock.org.eclipse.jetty.http2.generator.HeaderGenerator;
import wiremock.org.eclipse.jetty.io.ByteBufferPool;
import wiremock.org.eclipse.jetty.io.RetainableByteBuffer;
import wiremock.org.eclipse.jetty.util.BufferUtil;

public class GoAwayGenerator
extends FrameGenerator {
    public GoAwayGenerator(HeaderGenerator headerGenerator) {
        super(headerGenerator);
    }

    @Override
    public int generate(ByteBufferPool.Accumulator accumulator, Frame frame) {
        GoAwayFrame goAwayFrame = (GoAwayFrame)frame;
        return this.generateGoAway(accumulator, goAwayFrame.getLastStreamId(), goAwayFrame.getError(), goAwayFrame.getPayload());
    }

    public int generateGoAway(ByteBufferPool.Accumulator accumulator, int lastStreamId, int error, byte[] payload) {
        if (lastStreamId < 0) {
            lastStreamId = 0;
        }
        int fixedLength = 8;
        int maxPayloadLength = 16384 - fixedLength;
        if (payload != null && payload.length > maxPayloadLength) {
            payload = Arrays.copyOfRange(payload, 0, maxPayloadLength);
        }
        int length = fixedLength + (payload != null ? payload.length : 0);
        RetainableByteBuffer header = this.generateHeader(FrameType.GO_AWAY, length, 0, 0);
        ByteBuffer byteBuffer = header.getByteBuffer();
        byteBuffer.putInt(lastStreamId);
        byteBuffer.putInt(error);
        if (payload != null) {
            byteBuffer.put(payload);
        }
        BufferUtil.flipToFlush(byteBuffer, 0);
        accumulator.append(header);
        return 9 + length;
    }
}

