/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.http2.frames;

import java.nio.ByteBuffer;
import wiremock.org.eclipse.jetty.http2.frames.FrameType;
import wiremock.org.eclipse.jetty.http2.frames.StreamFrame;

public class DataFrame
extends StreamFrame {
    private final ByteBuffer data;
    private final boolean endStream;
    private final int length;
    private final int padding;

    public DataFrame(ByteBuffer data, boolean endStream) {
        this(0, data, endStream);
    }

    public DataFrame(int streamId, ByteBuffer data, boolean endStream) {
        this(streamId, data, endStream, 0);
    }

    public DataFrame(int streamId, ByteBuffer data, boolean endStream, int padding) {
        super(FrameType.DATA, streamId);
        this.data = data;
        this.endStream = endStream;
        this.length = data.remaining();
        this.padding = padding;
    }

    public ByteBuffer getByteBuffer() {
        return this.data;
    }

    public boolean isEndStream() {
        return this.endStream;
    }

    public int remaining() {
        return this.data.remaining();
    }

    public int padding() {
        return this.padding;
    }

    public int flowControlLength() {
        return this.length + this.padding;
    }

    @Override
    public DataFrame withStreamId(int streamId) {
        return new DataFrame(streamId, this.getByteBuffer(), this.isEndStream());
    }

    @Override
    public String toString() {
        return String.format("%s#%d{length:%d,end=%b}", super.toString(), this.getStreamId(), this.length, this.isEndStream());
    }
}

