/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.ee10.servlet;

import wiremock.org.eclipse.jetty.util.resource.Resource;

public class Source {
    public static final Source EMBEDDED = new Source(Origin.EMBEDDED);
    public static final Source JAKARTA_API = new Source(Origin.JAKARTA_API);
    public final Origin _origin;
    public final String _name;
    public Resource _resource;

    public Source(Origin o) {
        this(o, (String)null);
    }

    public Source(Origin o, Class<?> clazz) {
        this(o, clazz.getName());
    }

    public Source(Origin o, Resource resource) {
        this(o, resource.getURI().toASCIIString());
        this._resource = resource;
    }

    public Source(Origin o, String name) {
        if (o == null) {
            throw new IllegalArgumentException("Origin is null");
        }
        this._origin = o;
        this._name = name;
    }

    public Origin getOrigin() {
        return this._origin;
    }

    public Resource getResource() {
        return this._resource;
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return String.valueOf((Object)this._origin) + ":" + (this._name == null ? "<null>" : this._name);
    }

    public static enum Origin {
        EMBEDDED,
        JAKARTA_API,
        DESCRIPTOR,
        ANNOTATION;

    }
}

