/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.MessageSourceValidationMessage;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.com.networknt.schema.VersionCode;
import wiremock.com.networknt.schema.annotation.JsonNodeAnnotation;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class ContainsValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(ContainsValidator.class);
    private static final String CONTAINS_MAX = "contains.max";
    private static final String CONTAINS_MIN = "contains.min";
    private final JsonSchema schema;
    private final boolean isMinV201909 = VersionCode.MinV201909.getVersions().contains((Object)this.validationContext.getMetaSchema().getSpecification());
    private final Integer min;
    private final Integer max;
    private Boolean hasUnevaluatedItemsValidator = null;

    public ContainsValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.CONTAINS, validationContext);
        Integer currentMax = null;
        Integer currentMin = null;
        if (schemaNode.isObject() || schemaNode.isBoolean()) {
            Optional<JsonNode> minNode;
            this.schema = validationContext.newSchema(schemaLocation, evaluationPath, schemaNode, parentSchema);
            JsonNode parentSchemaNode = parentSchema.getSchemaNode();
            Optional<JsonNode> maxNode = Optional.ofNullable(parentSchemaNode.get(ValidatorTypeCode.MAX_CONTAINS.getValue())).filter(JsonNode::canConvertToExactIntegral);
            if (maxNode.isPresent()) {
                currentMax = maxNode.get().intValue();
            }
            if ((minNode = Optional.ofNullable(parentSchemaNode.get(ValidatorTypeCode.MIN_CONTAINS.getValue())).filter(JsonNode::canConvertToExactIntegral)).isPresent()) {
                currentMin = minNode.get().intValue();
            }
        } else {
            this.schema = null;
        }
        this.max = currentMax;
        this.min = currentMin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        ContainsValidator.debug(logger, executionContext, node, rootNode, instanceLocation);
        Set<ValidationMessage> results = null;
        int actual = 0;
        int i = 0;
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        if (null != this.schema && node.isArray()) {
            boolean failFast = executionContext.isFailFast();
            try {
                executionContext.setFailFast(false);
                for (JsonNode n : node) {
                    JsonNodePath path;
                    if (this.schema.validate(executionContext, n, rootNode, path = instanceLocation.append(i)).isEmpty()) {
                        ++actual;
                        indexes.add(i);
                    }
                    ++i;
                }
            }
            finally {
                executionContext.setFailFast(failFast);
            }
            int m = 1;
            if (this.min != null) {
                m = this.min;
            }
            if (actual < m) {
                results = this.boundsViolated(this.isMinV201909 ? ValidatorTypeCode.MIN_CONTAINS : ValidatorTypeCode.CONTAINS, executionContext.getExecutionConfig().getLocale(), executionContext.isFailFast(), node, instanceLocation, m);
            }
            if (this.max != null && actual > this.max) {
                results = this.boundsViolated(this.isMinV201909 ? ValidatorTypeCode.MAX_CONTAINS : ValidatorTypeCode.CONTAINS, executionContext.getExecutionConfig().getLocale(), executionContext.isFailFast(), node, instanceLocation, this.max);
            }
        }
        boolean collectAnnotations = this.collectAnnotations();
        if (this.schema != null) {
            if (collectAnnotations || this.collectAnnotations(executionContext, "contains")) {
                if (actual == i) {
                    executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword("contains").value(true).build());
                } else {
                    executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath).schemaLocation(this.schemaLocation).keyword("contains").value(indexes).build());
                }
            }
            if (this.min != null) {
                String minContainsKeyword = "minContains";
                if (collectAnnotations || this.collectAnnotations(executionContext, minContainsKeyword)) {
                    executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath.append(minContainsKeyword)).schemaLocation(this.schemaLocation.append(minContainsKeyword)).keyword(minContainsKeyword).value(this.min).build());
                }
            }
            if (this.max != null) {
                String maxContainsKeyword = "maxContains";
                if (collectAnnotations || this.collectAnnotations(executionContext, maxContainsKeyword)) {
                    executionContext.getAnnotations().put(JsonNodeAnnotation.builder().instanceLocation(instanceLocation).evaluationPath(this.evaluationPath.append(maxContainsKeyword)).schemaLocation(this.schemaLocation.append(maxContainsKeyword)).keyword(maxContainsKeyword).value(this.max).build());
                }
            }
        }
        return results == null ? Collections.emptySet() : results;
    }

    @Override
    public void preloadJsonSchema() {
        Optional.ofNullable(this.schema).ifPresent(JsonSchema::initializeValidators);
        this.collectAnnotations();
    }

    private Set<ValidationMessage> boundsViolated(ValidatorTypeCode validatorTypeCode, Locale locale, boolean failFast, JsonNode instanceNode, JsonNodePath instanceLocation, int bounds) {
        String messageKey = "contains";
        if (ValidatorTypeCode.MIN_CONTAINS.equals(validatorTypeCode)) {
            messageKey = CONTAINS_MIN;
        } else if (ValidatorTypeCode.MAX_CONTAINS.equals(validatorTypeCode)) {
            messageKey = CONTAINS_MAX;
        }
        return Collections.singleton(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(instanceNode)).instanceLocation(instanceLocation)).messageKey(messageKey)).locale(locale)).failFast(failFast)).arguments(String.valueOf(bounds), this.schema.getSchemaNode().toString())).code(validatorTypeCode.getErrorCode())).type(validatorTypeCode.getValue())).build());
    }

    private boolean collectAnnotations() {
        return this.hasUnevaluatedItemsValidator();
    }

    private boolean hasUnevaluatedItemsValidator() {
        if (this.hasUnevaluatedItemsValidator == null) {
            this.hasUnevaluatedItemsValidator = this.hasAdjacentKeywordInEvaluationPath("unevaluatedItems");
        }
        return this.hasUnevaluatedItemsValidator;
    }
}

