/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.DateTimeUnit;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.matching.AbsentPattern;
import com.github.tomakehurst.wiremock.matching.AbstractDateTimePattern;
import com.github.tomakehurst.wiremock.matching.AfterDateTimePattern;
import com.github.tomakehurst.wiremock.matching.AnythingPattern;
import com.github.tomakehurst.wiremock.matching.BeforeDateTimePattern;
import com.github.tomakehurst.wiremock.matching.ContainsPattern;
import com.github.tomakehurst.wiremock.matching.EqualToDateTimePattern;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.EqualToXmlPattern;
import com.github.tomakehurst.wiremock.matching.LogicalAnd;
import com.github.tomakehurst.wiremock.matching.LogicalOr;
import com.github.tomakehurst.wiremock.matching.MatchesJsonPathPattern;
import com.github.tomakehurst.wiremock.matching.MatchesJsonSchemaPattern;
import com.github.tomakehurst.wiremock.matching.MatchesXPathPattern;
import com.github.tomakehurst.wiremock.matching.NegativeContainsPattern;
import com.github.tomakehurst.wiremock.matching.NegativeRegexPattern;
import com.github.tomakehurst.wiremock.matching.NotPattern;
import com.github.tomakehurst.wiremock.matching.PathTemplatePattern;
import com.github.tomakehurst.wiremock.matching.RegexPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import wiremock.com.fasterxml.jackson.core.JsonParser;
import wiremock.com.fasterxml.jackson.core.type.TypeReference;
import wiremock.com.fasterxml.jackson.databind.DeserializationContext;
import wiremock.com.fasterxml.jackson.databind.JsonDeserializer;
import wiremock.com.fasterxml.jackson.databind.JsonMappingException;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.org.xmlunit.diff.ComparisonType;

public class StringValuePatternJsonDeserializer
extends JsonDeserializer<StringValuePattern> {
    private static final Map<String, Class<? extends StringValuePattern>> PATTERNS = Map.ofEntries(Map.entry("equalTo", EqualToPattern.class), Map.entry("equalToJson", EqualToJsonPattern.class), Map.entry("matchesJsonPath", MatchesJsonPathPattern.class), Map.entry("matchesJsonSchema", MatchesJsonSchemaPattern.class), Map.entry("equalToXml", EqualToXmlPattern.class), Map.entry("matchesXPath", MatchesXPathPattern.class), Map.entry("contains", ContainsPattern.class), Map.entry("not", NotPattern.class), Map.entry("doesNotContain", NegativeContainsPattern.class), Map.entry("matches", RegexPattern.class), Map.entry("doesNotMatch", NegativeRegexPattern.class), Map.entry("before", BeforeDateTimePattern.class), Map.entry("after", AfterDateTimePattern.class), Map.entry("equalToDateTime", EqualToDateTimePattern.class), Map.entry("anything", AnythingPattern.class), Map.entry("absent", AbsentPattern.class), Map.entry("and", LogicalAnd.class), Map.entry("or", LogicalOr.class), Map.entry("matchesPathTemplate", PathTemplatePattern.class));

    @Override
    public StringValuePattern deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode rootNode = (JsonNode)parser.readValueAsTree();
        return this.buildStringValuePattern(rootNode);
    }

    public StringValuePattern buildStringValuePattern(JsonNode rootNode) throws JsonMappingException {
        Class<? extends StringValuePattern> patternClass = StringValuePatternJsonDeserializer.findPatternClass(rootNode);
        if (patternClass.equals(AbsentPattern.class)) {
            return AbsentPattern.ABSENT;
        }
        if (patternClass.equals(EqualToJsonPattern.class)) {
            return this.deserializeEqualToJson(rootNode);
        }
        if (patternClass.equals(MatchesJsonSchemaPattern.class)) {
            return this.deserializeMatchesJsonSchema(rootNode);
        }
        if (patternClass.equals(EqualToXmlPattern.class)) {
            return this.deserializeEqualToXml(rootNode);
        }
        if (patternClass.equals(MatchesJsonPathPattern.class)) {
            return this.deserialiseMatchesJsonPathPattern(rootNode);
        }
        if (patternClass.equals(MatchesXPathPattern.class)) {
            return this.deserialiseMatchesXPathPattern(rootNode);
        }
        if (patternClass.equals(EqualToPattern.class)) {
            return this.deserializeEqualTo(rootNode);
        }
        if (AbstractDateTimePattern.class.isAssignableFrom(patternClass)) {
            Map.Entry<String, JsonNode> mainFieldEntry = StringValuePatternJsonDeserializer.findMainFieldEntry(rootNode);
            String matcherName = mainFieldEntry.getKey();
            return this.deserialiseDateTimePattern(rootNode, matcherName);
        }
        if (patternClass.equals(LogicalAnd.class)) {
            return this.deserializeAnd(rootNode);
        }
        if (patternClass.equals(LogicalOr.class)) {
            return this.deserializeOr(rootNode);
        }
        if (patternClass.equals(NotPattern.class)) {
            return this.deserializeNot(rootNode);
        }
        Map.Entry<String, JsonNode> mainFieldEntry = StringValuePatternJsonDeserializer.findMainFieldEntry(rootNode);
        if (!mainFieldEntry.getValue().isTextual()) {
            throw new JsonMappingException(mainFieldEntry.getKey() + " operand must be a non-null string");
        }
        String operand = mainFieldEntry.getValue().textValue();
        try {
            Constructor<? extends StringValuePattern> constructor = StringValuePatternJsonDeserializer.findConstructor(patternClass);
            return constructor.newInstance(operand);
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, StringValuePattern.class);
        }
    }

    private static Map.Entry<String, JsonNode> findMainFieldEntry(JsonNode rootNode) {
        List<Map.Entry<String, JsonNode>> list = StringValuePatternJsonDeserializer.getListFromNode(rootNode);
        return list.stream().filter(input -> PATTERNS.containsKey(input.getKey())).findFirst().orElseThrow(NoSuchElementException::new);
    }

    private EqualToPattern deserializeEqualTo(JsonNode rootNode) throws JsonMappingException {
        if (!rootNode.has("equalTo")) {
            throw new JsonMappingException(String.valueOf(rootNode) + " is not a valid match operation");
        }
        JsonNode equalToNode = rootNode.findValue("equalTo");
        if (!equalToNode.isTextual()) {
            throw new JsonMappingException("equalTo operand must be a non-null string");
        }
        String operand = equalToNode.textValue();
        Boolean ignoreCase = StringValuePatternJsonDeserializer.fromNullable(rootNode.findValue("caseInsensitive"));
        return new EqualToPattern(operand, ignoreCase);
    }

    private EqualToJsonPattern deserializeEqualToJson(JsonNode rootNode) throws JsonMappingException {
        if (!rootNode.has("equalToJson")) {
            throw new JsonMappingException(String.valueOf(rootNode) + " is not a valid match operation");
        }
        JsonNode operand = rootNode.findValue("equalToJson");
        Boolean ignoreArrayOrder = StringValuePatternJsonDeserializer.fromNullable(rootNode.findValue("ignoreArrayOrder"));
        Boolean ignoreExtraElements = StringValuePatternJsonDeserializer.fromNullable(rootNode.findValue("ignoreExtraElements"));
        if (operand.isTextual()) {
            return new EqualToJsonPattern(operand.textValue(), ignoreArrayOrder, ignoreExtraElements);
        }
        return new EqualToJsonPattern(operand, ignoreArrayOrder, ignoreExtraElements);
    }

    private MatchesJsonSchemaPattern deserializeMatchesJsonSchema(JsonNode rootNode) throws JsonMappingException {
        WireMock.JsonSchemaVersion schemaVersion;
        if (!rootNode.has("matchesJsonSchema")) {
            throw new JsonMappingException(String.valueOf(rootNode) + " is not a valid match operation");
        }
        JsonNode operand = rootNode.findValue("matchesJsonSchema");
        try {
            String schemaVersionString = StringValuePatternJsonDeserializer.fromNullableTextNode(rootNode.findValue("schemaVersion"));
            schemaVersion = schemaVersionString != null ? WireMock.JsonSchemaVersion.valueOf(schemaVersionString) : WireMock.JsonSchemaVersion.DEFAULT;
        }
        catch (Exception e) {
            throw new JsonMappingException("schemaVersion must be one of " + Json.write(WireMock.JsonSchemaVersion.values()));
        }
        if (operand.isTextual()) {
            return new MatchesJsonSchemaPattern(operand.textValue(), schemaVersion);
        }
        return new MatchesJsonSchemaPattern(operand, schemaVersion);
    }

    private EqualToXmlPattern deserializeEqualToXml(JsonNode rootNode) throws JsonMappingException {
        if (!rootNode.has("equalToXml")) {
            throw new JsonMappingException(String.valueOf(rootNode) + " is not a valid match operation");
        }
        JsonNode operand = rootNode.findValue("equalToXml");
        Boolean enablePlaceholders = StringValuePatternJsonDeserializer.fromNullable(rootNode.findValue("enablePlaceholders"));
        String placeholderOpeningDelimiterRegex = StringValuePatternJsonDeserializer.fromNullableTextNode(rootNode.findValue("placeholderOpeningDelimiterRegex"));
        String placeholderClosingDelimiterRegex = StringValuePatternJsonDeserializer.fromNullableTextNode(rootNode.findValue("placeholderClosingDelimiterRegex"));
        Set<ComparisonType> exemptedComparisons = StringValuePatternJsonDeserializer.comparisonTypeSetFromArray(rootNode.findValue("exemptedComparisons"));
        Boolean ignoreOrderOfSameNode = StringValuePatternJsonDeserializer.fromNullable(rootNode.findValue("ignoreOrderOfSameNode"));
        EqualToXmlPattern.NamespaceAwareness namespaceAwareness = StringValuePatternJsonDeserializer.deserializeNamespaceAwareness(rootNode);
        return new EqualToXmlPattern(operand.textValue(), enablePlaceholders, placeholderOpeningDelimiterRegex, placeholderClosingDelimiterRegex, exemptedComparisons, ignoreOrderOfSameNode, namespaceAwareness);
    }

    private static EqualToXmlPattern.NamespaceAwareness deserializeNamespaceAwareness(JsonNode rootNode) {
        String namespaceAwarenessString = StringValuePatternJsonDeserializer.fromNullableTextNode(rootNode.findValue("namespaceAwareness"));
        return namespaceAwarenessString == null ? null : EqualToXmlPattern.NamespaceAwareness.valueOf(namespaceAwarenessString);
    }

    private MatchesJsonPathPattern deserialiseMatchesJsonPathPattern(JsonNode rootNode) throws JsonMappingException {
        if (!rootNode.has("matchesJsonPath")) {
            throw new JsonMappingException(String.valueOf(rootNode) + " is not a valid match operation");
        }
        JsonNode outerPatternNode = rootNode.findValue("matchesJsonPath");
        if (outerPatternNode.isTextual()) {
            return new MatchesJsonPathPattern(outerPatternNode.textValue());
        }
        if (!outerPatternNode.has("expression")) {
            throw new JsonMappingException("expression is required in the advanced matchesJsonPath form");
        }
        String expression = outerPatternNode.findValue("expression").textValue();
        StringValuePattern valuePattern = this.buildStringValuePattern(outerPatternNode);
        return new MatchesJsonPathPattern(expression, valuePattern);
    }

    private MatchesXPathPattern deserialiseMatchesXPathPattern(JsonNode rootNode) throws JsonMappingException {
        if (!rootNode.has("matchesXPath")) {
            throw new JsonMappingException(String.valueOf(rootNode) + " is not a valid match operation");
        }
        JsonNode namespacesNode = rootNode.findValue("xPathNamespaces");
        Map<String, String> namespaces = namespacesNode != null ? StringValuePatternJsonDeserializer.toNamespaceMap(namespacesNode) : Collections.emptyMap();
        JsonNode outerPatternNode = rootNode.findValue("matchesXPath");
        if (outerPatternNode.isTextual()) {
            return new MatchesXPathPattern(outerPatternNode.textValue(), namespaces);
        }
        if (!outerPatternNode.has("expression")) {
            throw new JsonMappingException("expression is required in the advanced matchesXPath form");
        }
        String expression = outerPatternNode.findValue("expression").textValue();
        StringValuePattern valuePattern = this.buildStringValuePattern(outerPatternNode);
        return new MatchesXPathPattern(expression, namespaces, valuePattern);
    }

    private StringValuePattern deserialiseDateTimePattern(JsonNode rootNode, String matcherName) throws JsonMappingException {
        JsonNode dateTimeNode = rootNode.findValue(matcherName);
        JsonNode formatNode = rootNode.findValue("actualFormat");
        JsonNode truncateExpectedNode = rootNode.findValue("truncateExpected");
        JsonNode truncateActualNode = rootNode.findValue("truncateActual");
        JsonNode applyTruncationLastNode = rootNode.findValue("applyTruncationLast");
        JsonNode expectedOffsetAmountNode = rootNode.findValue("expectedOffset");
        JsonNode expectedOffsetUnitNode = rootNode.findValue("expectedOffsetUnit");
        switch (matcherName) {
            case "before": {
                return new BeforeDateTimePattern(dateTimeNode.textValue(), formatNode != null ? formatNode.textValue() : null, truncateExpectedNode != null ? truncateExpectedNode.textValue() : null, truncateActualNode != null ? truncateActualNode.textValue() : null, applyTruncationLastNode != null && applyTruncationLastNode.booleanValue(), expectedOffsetAmountNode != null ? Integer.valueOf(expectedOffsetAmountNode.intValue()) : null, expectedOffsetUnitNode != null ? DateTimeUnit.valueOf(expectedOffsetUnitNode.textValue().toUpperCase()) : null);
            }
            case "after": {
                return new AfterDateTimePattern(dateTimeNode.textValue(), formatNode != null ? formatNode.textValue() : null, truncateExpectedNode != null ? truncateExpectedNode.textValue() : null, truncateActualNode != null ? truncateActualNode.textValue() : null, applyTruncationLastNode != null && applyTruncationLastNode.booleanValue(), expectedOffsetAmountNode != null ? Integer.valueOf(expectedOffsetAmountNode.intValue()) : null, expectedOffsetUnitNode != null ? DateTimeUnit.valueOf(expectedOffsetUnitNode.textValue().toUpperCase()) : null);
            }
            case "equalToDateTime": {
                return new EqualToDateTimePattern(dateTimeNode.textValue(), formatNode != null ? formatNode.textValue() : null, truncateExpectedNode != null ? truncateExpectedNode.textValue() : null, truncateActualNode != null ? truncateActualNode.textValue() : null, applyTruncationLastNode != null && applyTruncationLastNode.booleanValue(), expectedOffsetAmountNode != null ? Integer.valueOf(expectedOffsetAmountNode.intValue()) : null, expectedOffsetUnitNode != null ? DateTimeUnit.valueOf(expectedOffsetUnitNode.textValue().toUpperCase()) : null);
            }
        }
        throw new JsonMappingException(String.valueOf(rootNode) + " is not a valid match operation");
    }

    private LogicalAnd deserializeAnd(JsonNode node) throws JsonMappingException {
        LogicalAnd logicalAnd;
        block9: {
            JsonNode operandsNode = node.get("and");
            if (!operandsNode.isArray()) {
                throw new JsonMappingException("and field must be an array of matchers");
            }
            JsonParser parser = Json.getObjectMapper().treeAsTokens(node.get("and"));
            try {
                List operands = (List)parser.readValueAs(new TypeReference<List<StringValuePattern>>(){});
                logicalAnd = new LogicalAnd(operands);
                if (parser == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Exceptions.throwUnchecked(e, LogicalAnd.class);
                }
            }
            parser.close();
        }
        return logicalAnd;
    }

    private LogicalOr deserializeOr(JsonNode node) throws JsonMappingException {
        LogicalOr logicalOr;
        block9: {
            JsonNode operandsNode = node.get("or");
            if (!operandsNode.isArray()) {
                throw new JsonMappingException("and field must be an array of matchers");
            }
            JsonParser parser = Json.getObjectMapper().treeAsTokens(node.get("or"));
            try {
                List operands = (List)parser.readValueAs(new TypeReference<List<StringValuePattern>>(){});
                logicalOr = new LogicalOr(operands);
                if (parser == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Exceptions.throwUnchecked(e, LogicalOr.class);
                }
            }
            parser.close();
        }
        return logicalOr;
    }

    private StringValuePattern deserializeNot(JsonNode rootNode) throws JsonMappingException {
        NotPattern notPattern;
        block9: {
            if (!rootNode.has("not")) {
                throw new JsonMappingException(String.valueOf(rootNode) + " is not a valid not operation");
            }
            JsonNode notNode = rootNode.findValue("not");
            JsonParser parser = Json.getObjectMapper().treeAsTokens(notNode);
            try {
                StringValuePattern unexpectedPattern = (StringValuePattern)parser.readValueAs(new TypeReference<StringValuePattern>(){});
                notPattern = new NotPattern(unexpectedPattern);
                if (parser == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Exceptions.throwUnchecked(e, NotPattern.class);
                }
            }
            parser.close();
        }
        return notPattern;
    }

    private static Map<String, String> toNamespaceMap(JsonNode namespacesNode) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Iterator<Map.Entry<String, JsonNode>> fields = namespacesNode.fields();
        while (fields.hasNext()) {
            Map.Entry<String, JsonNode> field = fields.next();
            map.put(field.getKey(), field.getValue().textValue());
        }
        return map;
    }

    private static Boolean fromNullable(JsonNode node) {
        return node == null ? null : Boolean.valueOf(node.asBoolean());
    }

    private static String fromNullableTextNode(JsonNode node) {
        return node == null ? null : node.asText();
    }

    private static Set<ComparisonType> comparisonTypeSetFromArray(JsonNode node) {
        if (node == null || !node.isArray()) {
            return null;
        }
        LinkedHashSet<ComparisonType> comparisonTypes = new LinkedHashSet<ComparisonType>();
        for (JsonNode itemNode : node) {
            comparisonTypes.add(ComparisonType.valueOf(itemNode.textValue()));
        }
        return comparisonTypes;
    }

    private static Constructor<? extends StringValuePattern> findConstructor(Class<? extends StringValuePattern> clazz) {
        Optional<Constructor> optionalConstructor = Arrays.stream(clazz.getDeclaredConstructors()).filter(input -> input.getParameterTypes().length == 1 && input.getGenericParameterTypes()[0].equals(String.class)).findFirst();
        if (optionalConstructor.isEmpty()) {
            throw new IllegalStateException("Constructor for " + clazz.getSimpleName() + " must have a single string argument constructor");
        }
        return optionalConstructor.get();
    }

    private static Class<? extends StringValuePattern> findPatternClass(JsonNode rootNode) throws JsonMappingException {
        for (Map.Entry<String, JsonNode> node : StringValuePatternJsonDeserializer.getListFromNode(rootNode)) {
            Class<? extends StringValuePattern> patternClass = PATTERNS.get(node.getKey());
            if (patternClass == null) continue;
            return patternClass;
        }
        throw new JsonMappingException(String.valueOf(rootNode) + " is not a valid match operation");
    }

    private static List<Map.Entry<String, JsonNode>> getListFromNode(JsonNode rootNode) {
        LinkedList<Map.Entry<String, JsonNode>> list = new LinkedList<Map.Entry<String, JsonNode>>();
        rootNode.fields().forEachRemaining(list::add);
        return list;
    }
}

