/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty12;

import wiremock.jakarta.servlet.ServletException;
import wiremock.org.eclipse.jetty.ee10.servlet.Dispatcher;
import wiremock.org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import wiremock.org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import wiremock.org.eclipse.jetty.ee10.servlet.ServletContextResponse;
import wiremock.org.eclipse.jetty.server.Request;
import wiremock.org.eclipse.jetty.server.Response;
import wiremock.org.eclipse.jetty.server.handler.ErrorHandler;
import wiremock.org.eclipse.jetty.util.Callback;

public class NotFoundHandler
extends ErrorHandler {
    private final ErrorHandler DEFAULT_HANDLER = new ErrorHandler();
    private final ServletContextHandler adminServiceHandler;

    public NotFoundHandler(ServletContextHandler adminServiceHandler) {
        this.adminServiceHandler = adminServiceHandler;
    }

    @Override
    public boolean errorPageForMethod(String method) {
        return true;
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        if (response.getStatus() == 404) {
            Dispatcher requestDispatcher = (Dispatcher)this.adminServiceHandler.getServletContext().getRequestDispatcher("/not-matched");
            try {
                requestDispatcher.error(((ServletContextRequest)request).getServletApiRequest(), ((ServletContextResponse)response).getServletApiResponse());
                callback.succeeded();
                return true;
            }
            catch (ServletException e) {
                callback.failed(e);
            }
        } else {
            try {
                return this.DEFAULT_HANDLER.handle(request, response, callback);
            }
            catch (Exception e) {
                callback.failed(e);
            }
        }
        return false;
    }
}

